/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.util.XPopupUtils;
import java.util.HashMap;

public final class KeyboardUtils {
    public static int sDecorViewInvisibleHeightPre;
    private static ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
    private static HashMap<View, OnSoftInputChangedListener> listenerMap;
    private static int sDecorViewDelta;

    private KeyboardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    private static int getDecorViewInvisibleHeight(Window window) {
        View decorView = window.getDecorView();
        if (decorView == null) {
            return sDecorViewInvisibleHeightPre;
        }
        Rect outRect = new Rect();
        decorView.getWindowVisibleDisplayFrame(outRect);
        int delta = Math.abs(decorView.getBottom() - outRect.bottom);
        if (XPopupUtils.isNavBarVisible(window)) {
            delta -= XPopupUtils.getNavBarHeight();
        }
        if (delta <= XPopupUtils.getNavBarHeight() + XPopupUtils.getStatusBarHeight()) {
            sDecorViewDelta = delta;
            return 0;
        }
        return delta - sDecorViewDelta;
    }

    public static void registerSoftInputChangedListener(final Window window, BasePopupView popupView, OnSoftInputChangedListener listener) {
        int flags = window.getAttributes().flags;
        if ((flags & 0x200) != 0) {
            window.clearFlags(512);
        }
        FrameLayout contentView = (FrameLayout)window.findViewById(0x1020002);
        sDecorViewInvisibleHeightPre = KeyboardUtils.getDecorViewInvisibleHeight(window);
        listenerMap.put((View)popupView, listener);
        ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int height = KeyboardUtils.getDecorViewInvisibleHeight(window);
                if (sDecorViewInvisibleHeightPre != height) {
                    for (OnSoftInputChangedListener changedListener : listenerMap.values()) {
                        changedListener.onSoftInputChanged(height);
                    }
                    sDecorViewInvisibleHeightPre = height;
                }
            }
        };
        contentView.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
    }

    public static void removeLayoutChangeListener(View decorView, BasePopupView popupView) {
        onGlobalLayoutListener = null;
        listenerMap.remove((Object)popupView);
        if (decorView == null) {
            return;
        }
        View contentView = decorView.findViewById(0x1020002);
        if (contentView == null) {
            return;
        }
        contentView.getViewTreeObserver().removeGlobalOnLayoutListener(onGlobalLayoutListener);
    }

    public static void showSoftInput(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        imm.showSoftInput(view, 2);
    }

    public static void hideSoftInput(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void hideSoftInput(@NonNull Window window) {
        View view = window.getCurrentFocus();
        if (view == null) {
            View decorView = window.getDecorView();
            View focusView = decorView.findViewWithTag((Object)"keyboardTagView");
            if (focusView == null) {
                view = new EditText(window.getContext());
                view.setTag((Object)"keyboardTagView");
                ((ViewGroup)decorView).addView(view, 0, 0);
            } else {
                view = focusView;
            }
            view.requestFocus();
        }
        KeyboardUtils.hideSoftInput(view);
    }

    static {
        listenerMap = new HashMap();
        sDecorViewDelta = 0;
    }

    public static interface OnSoftInputChangedListener {
        public void onSoftInputChanged(int var1);
    }
}

