/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScaleAlphaAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.BubbleLayout;

public abstract class BubbleAttachPopupView
extends BasePopupView {
    protected int defaultOffsetY = 0;
    protected int defaultOffsetX = 0;
    protected BubbleLayout bubbleContainer;
    public boolean isShowUp;
    public boolean isShowLeft;
    float translationX = 0.0f;
    float translationY = 0.0f;
    float maxY = XPopupUtils.getAppHeight(this.getContext());
    int overflow = XPopupUtils.dp2px(this.getContext(), 10.0f);
    float centerY = 0.0f;

    public BubbleAttachPopupView(@NonNull Context context) {
        super(context);
        this.bubbleContainer = (BubbleLayout)this.findViewById(R.id.bubbleContainer);
    }

    protected void addInnerContent() {
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.bubbleContainer, false);
        this.bubbleContainer.addView(contentView);
    }

    @Override
    protected final int getInnerLayoutId() {
        return R.layout._xpopup_bubble_attach_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        if (this.bubbleContainer.getChildCount() == 0) {
            this.addInnerContent();
        }
        if (this.popupInfo.atViewRect == null && this.popupInfo.touchPoint == null) {
            throw new IllegalArgumentException("atView() or watchView() must be called for BubbleAttachPopupView before show()\uff01");
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.bubbleContainer.setElevation(XPopupUtils.dp2px(this.getContext(), 10.0f));
        }
        this.bubbleContainer.setShadowRadius(XPopupUtils.dp2px(this.getContext(), 0.0f));
        this.defaultOffsetY = this.popupInfo.offsetY;
        this.defaultOffsetX = this.popupInfo.offsetX;
        this.bubbleContainer.setTranslationX(this.popupInfo.offsetX);
        this.bubbleContainer.setTranslationY(this.popupInfo.offsetY);
        XPopupUtils.applyPopupSize((ViewGroup)this.getPopupContentView(), this.getMaxWidth(), this.getMaxHeight(), this.getPopupWidth(), this.getPopupHeight(), new Runnable(){

            @Override
            public void run() {
                BubbleAttachPopupView.this.doAttach();
            }
        });
    }

    public void doAttach() {
        this.maxY = XPopupUtils.getAppHeight(this.getContext()) - this.overflow;
        final boolean isRTL = XPopupUtils.isLayoutRtl(this.getContext());
        if (this.popupInfo.touchPoint != null) {
            boolean isTallerThanWindowHeight;
            if (XPopup.longClickPoint != null) {
                this.popupInfo.touchPoint = XPopup.longClickPoint;
            }
            this.centerY = this.popupInfo.touchPoint.y;
            boolean bl = isTallerThanWindowHeight = this.popupInfo.touchPoint.y + (float)this.getPopupContentView().getMeasuredHeight() > this.maxY;
            this.isShowUp = isTallerThanWindowHeight ? this.popupInfo.touchPoint.y > (float)(XPopupUtils.getScreenHeight(this.getContext()) / 2) : false;
            this.isShowLeft = this.popupInfo.touchPoint.x < (float)(XPopupUtils.getAppWidth(this.getContext()) / 2);
            ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
            int maxHeight = (int)(this.isShowUpToTarget() ? this.popupInfo.touchPoint.y - (float)XPopupUtils.getStatusBarHeight() - (float)this.overflow : (float)XPopupUtils.getScreenHeight(this.getContext()) - this.popupInfo.touchPoint.y - (float)this.overflow);
            int maxWidth = (int)(this.isShowLeft ? (float)XPopupUtils.getAppWidth(this.getContext()) - this.popupInfo.touchPoint.x - (float)this.overflow : this.popupInfo.touchPoint.x - (float)this.overflow);
            if (this.getPopupContentView().getMeasuredHeight() > maxHeight) {
                params.height = maxHeight;
            }
            if (this.getPopupContentView().getMeasuredWidth() > maxWidth) {
                params.width = maxWidth;
            }
            this.getPopupContentView().setLayoutParams(params);
            this.getPopupContentView().post(new Runnable(){

                @Override
                public void run() {
                    if (isRTL) {
                        BubbleAttachPopupView.this.translationX = BubbleAttachPopupView.this.isShowLeft ? -((float)XPopupUtils.getAppWidth(BubbleAttachPopupView.this.getContext()) - BubbleAttachPopupView.this.popupInfo.touchPoint.x - (float)BubbleAttachPopupView.this.getPopupContentView().getMeasuredWidth() - (float)BubbleAttachPopupView.this.defaultOffsetX) : -((float)XPopupUtils.getAppWidth(BubbleAttachPopupView.this.getContext()) - BubbleAttachPopupView.this.popupInfo.touchPoint.x + (float)BubbleAttachPopupView.this.defaultOffsetX);
                    } else {
                        float f = BubbleAttachPopupView.this.translationX = BubbleAttachPopupView.this.isShowLeft ? BubbleAttachPopupView.this.popupInfo.touchPoint.x + (float)BubbleAttachPopupView.this.defaultOffsetX : BubbleAttachPopupView.this.popupInfo.touchPoint.x - (float)BubbleAttachPopupView.this.getPopupContentView().getMeasuredWidth() - (float)BubbleAttachPopupView.this.defaultOffsetX;
                    }
                    if (BubbleAttachPopupView.this.popupInfo.isCenterHorizontal) {
                        BubbleAttachPopupView.this.translationX = BubbleAttachPopupView.this.isShowLeft ? (isRTL ? (BubbleAttachPopupView.this.translationX += (float)BubbleAttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f) : (BubbleAttachPopupView.this.translationX -= (float)BubbleAttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f)) : (isRTL ? (BubbleAttachPopupView.this.translationX -= (float)BubbleAttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f) : (BubbleAttachPopupView.this.translationX += (float)BubbleAttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f));
                    }
                    BubbleAttachPopupView.this.translationY = BubbleAttachPopupView.this.isShowUpToTarget() ? BubbleAttachPopupView.this.popupInfo.touchPoint.y - (float)BubbleAttachPopupView.this.getPopupContentView().getMeasuredHeight() - (float)BubbleAttachPopupView.this.defaultOffsetY : BubbleAttachPopupView.this.popupInfo.touchPoint.y + (float)BubbleAttachPopupView.this.defaultOffsetY;
                    if (BubbleAttachPopupView.this.isShowUpToTarget()) {
                        BubbleAttachPopupView.this.bubbleContainer.setLook(BubbleLayout.Look.BOTTOM);
                    } else {
                        BubbleAttachPopupView.this.bubbleContainer.setLook(BubbleLayout.Look.TOP);
                    }
                    if (BubbleAttachPopupView.this.popupInfo.isCenterHorizontal) {
                        BubbleAttachPopupView.this.bubbleContainer.setLookPositionCenter(true);
                    } else if (BubbleAttachPopupView.this.isShowLeft) {
                        BubbleAttachPopupView.this.bubbleContainer.setLookPosition(XPopupUtils.dp2px(BubbleAttachPopupView.this.getContext(), 1.0f));
                    } else {
                        BubbleAttachPopupView.this.bubbleContainer.setLookPosition(BubbleAttachPopupView.this.bubbleContainer.getMeasuredWidth() - XPopupUtils.dp2px(BubbleAttachPopupView.this.getContext(), 1.0f));
                    }
                    BubbleAttachPopupView.this.bubbleContainer.invalidate();
                    BubbleAttachPopupView.this.translationX -= (float)BubbleAttachPopupView.this.getActivityContentLeft();
                    BubbleAttachPopupView.this.getPopupContentView().setTranslationX(BubbleAttachPopupView.this.translationX);
                    BubbleAttachPopupView.this.getPopupContentView().setTranslationY(BubbleAttachPopupView.this.translationY);
                    BubbleAttachPopupView.this.initAndStartAnimation();
                }
            });
        } else {
            int maxWidth;
            final Rect rect = this.popupInfo.atViewRect;
            int centerX = (rect.left + rect.right) / 2;
            boolean isTallerThanWindowHeight = (float)(rect.bottom + this.getPopupContentView().getMeasuredHeight()) > this.maxY;
            this.centerY = (rect.top + rect.bottom) / 2;
            this.isShowUp = isTallerThanWindowHeight;
            this.isShowLeft = centerX < XPopupUtils.getAppWidth(this.getContext()) / 2;
            ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
            int maxHeight = this.isShowUpToTarget() ? rect.top - XPopupUtils.getStatusBarHeight() - this.overflow : XPopupUtils.getScreenHeight(this.getContext()) - rect.bottom - this.overflow;
            int n = maxWidth = this.isShowLeft ? XPopupUtils.getAppWidth(this.getContext()) - rect.left - this.overflow : rect.right - this.overflow;
            if (this.getPopupContentView().getMeasuredHeight() > maxHeight) {
                params.height = maxHeight;
            }
            if (this.getPopupContentView().getMeasuredWidth() > maxWidth) {
                params.width = maxWidth;
            }
            this.getPopupContentView().setLayoutParams(params);
            this.getPopupContentView().post(new Runnable(){

                @Override
                public void run() {
                    if (isRTL) {
                        BubbleAttachPopupView.this.translationX = BubbleAttachPopupView.this.isShowLeft ? (float)(-(XPopupUtils.getAppWidth(BubbleAttachPopupView.this.getContext()) - rect.left - BubbleAttachPopupView.this.getPopupContentView().getMeasuredWidth() - BubbleAttachPopupView.this.defaultOffsetX)) : (float)(-(XPopupUtils.getAppWidth(BubbleAttachPopupView.this.getContext()) - rect.right + BubbleAttachPopupView.this.defaultOffsetX));
                    } else {
                        float f = BubbleAttachPopupView.this.translationX = BubbleAttachPopupView.this.isShowLeft ? (float)(rect.left + BubbleAttachPopupView.this.defaultOffsetX) : (float)(rect.right - BubbleAttachPopupView.this.getPopupContentView().getMeasuredWidth() - BubbleAttachPopupView.this.defaultOffsetX);
                    }
                    if (BubbleAttachPopupView.this.popupInfo.isCenterHorizontal) {
                        BubbleAttachPopupView.this.translationX = BubbleAttachPopupView.this.isShowLeft ? (isRTL ? (BubbleAttachPopupView.this.translationX -= (float)(rect.width() - BubbleAttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f) : (BubbleAttachPopupView.this.translationX += (float)(rect.width() - BubbleAttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f)) : (isRTL ? (BubbleAttachPopupView.this.translationX += (float)(rect.width() - BubbleAttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f) : (BubbleAttachPopupView.this.translationX -= (float)(rect.width() - BubbleAttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f));
                    }
                    BubbleAttachPopupView.this.translationY = BubbleAttachPopupView.this.isShowUpToTarget() ? (float)(rect.top - BubbleAttachPopupView.this.getPopupContentView().getMeasuredHeight() - BubbleAttachPopupView.this.defaultOffsetY) : (float)(rect.bottom + BubbleAttachPopupView.this.defaultOffsetY);
                    if (BubbleAttachPopupView.this.isShowUpToTarget()) {
                        BubbleAttachPopupView.this.bubbleContainer.setLook(BubbleLayout.Look.BOTTOM);
                    } else {
                        BubbleAttachPopupView.this.bubbleContainer.setLook(BubbleLayout.Look.TOP);
                    }
                    if (BubbleAttachPopupView.this.popupInfo.isCenterHorizontal) {
                        BubbleAttachPopupView.this.bubbleContainer.setLookPositionCenter(true);
                    } else {
                        BubbleAttachPopupView.this.bubbleContainer.setLookPosition(rect.left + rect.width() / 2 - (int)BubbleAttachPopupView.this.translationX);
                    }
                    BubbleAttachPopupView.this.bubbleContainer.invalidate();
                    BubbleAttachPopupView.this.translationX -= (float)BubbleAttachPopupView.this.getActivityContentLeft();
                    BubbleAttachPopupView.this.getPopupContentView().setTranslationX(BubbleAttachPopupView.this.translationX);
                    BubbleAttachPopupView.this.getPopupContentView().setTranslationY(BubbleAttachPopupView.this.translationY);
                    BubbleAttachPopupView.this.initAndStartAnimation();
                }
            });
        }
    }

    protected void initAndStartAnimation() {
        this.initAnimator();
        this.doShowAnimation();
        this.doAfterShow();
    }

    protected boolean isShowUpToTarget() {
        if (this.popupInfo.positionByWindowCenter) {
            return this.centerY > (float)(XPopupUtils.getAppHeight(this.getContext()) / 2);
        }
        return (this.isShowUp || this.popupInfo.popupPosition == PopupPosition.Top) && this.popupInfo.popupPosition != PopupPosition.Bottom;
    }

    public BubbleAttachPopupView setArrowOffset(int offset) {
        this.bubbleContainer.arrowOffset = offset;
        this.bubbleContainer.invalidate();
        return this;
    }

    public BubbleAttachPopupView setBubbleBgColor(int color2) {
        this.bubbleContainer.setBubbleColor(color2);
        this.bubbleContainer.invalidate();
        return this;
    }

    public BubbleAttachPopupView setBubbleRadius(int radius) {
        this.bubbleContainer.setBubbleRadius(radius);
        this.bubbleContainer.invalidate();
        return this;
    }

    public BubbleAttachPopupView setArrowWidth(int width) {
        this.bubbleContainer.setLookWidth(width);
        this.bubbleContainer.invalidate();
        return this;
    }

    public BubbleAttachPopupView setArrowHeight(int height) {
        this.bubbleContainer.setLookLength(height);
        this.bubbleContainer.invalidate();
        return this;
    }

    public BubbleAttachPopupView setBubbleShadowSize(int size) {
        this.bubbleContainer.setShadowRadius(size);
        this.bubbleContainer.invalidate();
        return this;
    }

    public BubbleAttachPopupView setBubbleShadowColor(int color2) {
        this.bubbleContainer.setShadowColor(color2);
        this.bubbleContainer.invalidate();
        return this;
    }

    public BubbleAttachPopupView setArrowRadius(int radius) {
        this.bubbleContainer.setArrowRadius(radius);
        this.bubbleContainer.invalidate();
        return this;
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        return new ScaleAlphaAnimator(this.getPopupContentView(), this.getAnimationDuration(), PopupAnimation.ScaleAlphaFromCenter);
    }
}

