/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util;

import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.provider.Settings;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.OvershootInterpolator;
import android.widget.EditText;
import android.widget.Toast;
import androidx.annotation.FloatRange;
import com.lxj.xpopup.R;
import com.lxj.xpopup.core.AttachPopupView;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.core.BottomPopupView;
import com.lxj.xpopup.core.BubbleAttachPopupView;
import com.lxj.xpopup.core.CenterPopupView;
import com.lxj.xpopup.core.DrawerPopupView;
import com.lxj.xpopup.core.PositionPopupView;
import com.lxj.xpopup.impl.FullScreenPopupView;
import com.lxj.xpopup.impl.PartShadowPopupView;
import com.lxj.xpopup.interfaces.XPopupImageLoader;
import com.lxj.xpopup.util.FuckRomUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class XPopupUtils {
    private static int sDecorViewDelta = 0;
    private static int preKeyboardHeight = 0;
    private static final char[] HEX_DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] HEX_DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static int getAppHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (wm == null) {
            return -1;
        }
        Point point = new Point();
        wm.getDefaultDisplay().getSize(point);
        return point.y;
    }

    public static int getAppWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (wm == null) {
            return -1;
        }
        Point point = new Point();
        wm.getDefaultDisplay().getSize(point);
        return point.x;
    }

    public static int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (wm == null) {
            return -1;
        }
        Point point = new Point();
        wm.getDefaultDisplay().getRealSize(point);
        return point.y;
    }

    public static int getScreenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (wm == null) {
            return -1;
        }
        Point point = new Point();
        wm.getDefaultDisplay().getRealSize(point);
        return point.x;
    }

    public static int dp2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static int getStatusBarHeight() {
        Resources resources = Resources.getSystem();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resources.getDimensionPixelSize(resourceId);
    }

    public static int getNavBarHeight() {
        Resources res = Resources.getSystem();
        int resourceId = res.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId != 0) {
            return res.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static void setWidthHeight(View target, int width, int height) {
        if (width <= 0 && height <= 0) {
            return;
        }
        ViewGroup.LayoutParams params = target.getLayoutParams();
        if (width > 0) {
            params.width = width;
        }
        if (height > 0) {
            params.height = height;
        }
        target.setLayoutParams(params);
    }

    public static void applyPopupSize(final ViewGroup content, final int maxWidth, final int maxHeight, final int popupWidth, final int popupHeight, final Runnable afterApplySize) {
        content.post(new Runnable(){

            @Override
            public void run() {
                ViewGroup.LayoutParams params = content.getLayoutParams();
                View implView = content.getChildAt(0);
                ViewGroup.LayoutParams implParams = implView.getLayoutParams();
                int w = content.getMeasuredWidth();
                if (maxWidth > 0) {
                    params.width = Math.min(w, maxWidth);
                    if (implParams.width == -1) {
                        implParams.width = Math.min(w, maxWidth);
                    }
                    if (popupWidth > 0) {
                        params.width = Math.min(popupWidth, maxWidth);
                        implParams.width = Math.min(popupWidth, maxWidth);
                    }
                } else if (popupWidth > 0) {
                    params.width = popupWidth;
                    implParams.width = popupWidth;
                }
                int h = content.getMeasuredHeight();
                if (maxHeight > 0) {
                    params.height = Math.min(h, maxHeight);
                    if (popupHeight > 0) {
                        params.height = Math.min(popupHeight, maxHeight);
                        implParams.height = Math.min(popupHeight, maxHeight);
                    }
                } else if (popupHeight > 0) {
                    params.height = popupHeight;
                    implParams.height = popupHeight;
                }
                implView.setLayoutParams(implParams);
                content.setLayoutParams(params);
                content.post(new Runnable(){

                    @Override
                    public void run() {
                        if (afterApplySize != null) {
                            afterApplySize.run();
                        }
                    }
                });
            }
        });
    }

    public static void setCursorDrawableColor(EditText et, int color2) {
    }

    public static BitmapDrawable createBitmapDrawable(Resources resources, int width, int color2) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)20, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setColor(color2);
        canvas.drawRect(0.0f, 0.0f, (float)bitmap.getWidth(), 4.0f, paint);
        paint.setColor(0);
        canvas.drawRect(0.0f, 4.0f, (float)bitmap.getWidth(), 20.0f, paint);
        BitmapDrawable bitmapDrawable = new BitmapDrawable(resources, bitmap);
        bitmapDrawable.setGravity(80);
        return bitmapDrawable;
    }

    public static StateListDrawable createSelector(Drawable defaultDrawable, Drawable focusDrawable) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842908}, focusDrawable);
        stateListDrawable.addState(new int[0], defaultDrawable);
        return stateListDrawable;
    }

    public static boolean isInRect(float x, float y, Rect rect) {
        return x >= (float)rect.left && x <= (float)rect.right && y >= (float)rect.top && y <= (float)rect.bottom;
    }

    public static int getDecorViewInvisibleHeight(Window window) {
        View decorView = window.getDecorView();
        Rect outRect = new Rect();
        decorView.getWindowVisibleDisplayFrame(outRect);
        int delta = Math.abs(decorView.getBottom() - outRect.bottom);
        if (delta <= XPopupUtils.getNavBarHeight()) {
            sDecorViewDelta = delta;
            return 0;
        }
        return delta - sDecorViewDelta;
    }

    public static void moveUpToKeyboard(int keyboardHeight, final BasePopupView pv) {
        preKeyboardHeight = keyboardHeight;
        pv.post(new Runnable(){

            @Override
            public void run() {
                XPopupUtils.moveUpToKeyboardInternal(preKeyboardHeight, pv);
            }
        });
    }

    private static void moveUpToKeyboardInternal(int keyboardHeight, BasePopupView pv) {
        if (pv.popupInfo == null || !pv.popupInfo.isMoveUpToKeyboard.booleanValue()) {
            return;
        }
        if (pv instanceof PositionPopupView || pv instanceof AttachPopupView || pv instanceof BubbleAttachPopupView) {
            return;
        }
        ArrayList<EditText> allEts = new ArrayList<EditText>();
        XPopupUtils.findAllEditText(allEts, (ViewGroup)pv);
        EditText focusEt = null;
        for (EditText et : allEts) {
            if (!et.isFocused()) continue;
            focusEt = et;
            break;
        }
        int dy = 0;
        int popupHeight = pv.getPopupContentView().getHeight();
        int popupWidth = pv.getPopupContentView().getWidth();
        if (pv.getPopupImplView() != null) {
            popupHeight = Math.min(popupHeight, pv.getPopupImplView().getMeasuredHeight());
            popupWidth = Math.min(popupWidth, pv.getPopupImplView().getMeasuredWidth());
        }
        int screenHeight = pv.getMeasuredHeight();
        int focusEtTop = 0;
        int focusBottom = 0;
        if (focusEt != null) {
            int[] locations = new int[2];
            focusEt.getLocationInWindow(locations);
            focusEtTop = locations[1];
            focusBottom = focusEtTop + focusEt.getMeasuredHeight();
        }
        int animDuration = 100;
        if (pv instanceof FullScreenPopupView || pv instanceof DrawerPopupView) {
            int overflowHeight = (int)((float)(focusBottom + keyboardHeight - screenHeight) - pv.getPopupContentView().getTranslationY());
            if (focusEt != null && overflowHeight > 0) {
                dy = overflowHeight;
            }
        } else if (pv instanceof CenterPopupView) {
            int popupBottom = (screenHeight + popupHeight) / 2;
            int targetY = popupBottom + keyboardHeight - screenHeight;
            if (focusEt == null || focusEtTop - targetY < 0) {
                // empty if block
            }
            dy = Math.max(0, targetY);
        } else if (pv instanceof BottomPopupView) {
            dy = keyboardHeight;
        } else if (pv instanceof PartShadowPopupView) {
            int overflowHeight = (int)((float)(focusBottom + keyboardHeight - screenHeight) - pv.getPopupContentView().getTranslationY());
            if (focusEt != null && overflowHeight > 0) {
                dy = overflowHeight;
            }
        }
        pv.getPopupContentView().animate().translationY((float)(-dy)).setDuration((long)animDuration).setInterpolator((TimeInterpolator)new OvershootInterpolator(0.0f)).start();
    }

    public static void moveDown(BasePopupView pv) {
        if (pv instanceof PositionPopupView || pv instanceof AttachPopupView || pv instanceof BubbleAttachPopupView) {
            return;
        }
        if (pv instanceof FullScreenPopupView && pv.getPopupContentView().hasTransientState()) {
            return;
        }
        pv.getPopupContentView().animate().translationY(0.0f).setDuration(100L).start();
    }

    public static boolean isNavBarVisible(Window window) {
        boolean isVisible = false;
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        int count = decorView.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = decorView.getChildAt(i);
            int id2 = child.getId();
            if (id2 == -1) continue;
            try {
                String resourceEntryName = window.getContext().getResources().getResourceEntryName(id2);
                if (!"navigationBarBackground".equals(resourceEntryName) || child.getVisibility() != 0) continue;
                isVisible = true;
            }
            catch (Resources.NotFoundException e) {}
            break;
        }
        if (isVisible) {
            int visibility;
            if (FuckRomUtils.isSamsung() && Build.VERSION.SDK_INT >= 17 && Build.VERSION.SDK_INT < 29) {
                try {
                    return Settings.Global.getInt((ContentResolver)window.getContext().getContentResolver(), (String)"navigationbar_hide_bar_enabled") == 0;
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            isVisible = ((visibility = decorView.getSystemUiVisibility()) & 2) == 0;
        }
        return isVisible;
    }

    public static void findAllEditText(ArrayList<EditText> list, ViewGroup group) {
        for (int i = 0; i < group.getChildCount(); ++i) {
            View v = group.getChildAt(i);
            if (v instanceof EditText && v.getVisibility() == 0) {
                list.add((EditText)v);
                continue;
            }
            if (!(v instanceof ViewGroup)) continue;
            XPopupUtils.findAllEditText(list, (ViewGroup)v);
        }
    }

    public static void saveBmpToAlbum(final Context context, final XPopupImageLoader imageLoader, final Object uri) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                File source = imageLoader.getImageFile(context, uri);
                if (source == null) {
                    XPopupUtils.showToast(context, context.getString(R.string.xpopup_image_not_exist));
                    return;
                }
                try {
                    File dir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM), context.getPackageName());
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    File destFile = new File(dir, System.currentTimeMillis() + "." + XPopupUtils.getImageType(source));
                    if (Build.VERSION.SDK_INT < 29) {
                        if (destFile.exists()) {
                            destFile.delete();
                        }
                        destFile.createNewFile();
                        try (FileOutputStream out = new FileOutputStream(destFile);){
                            XPopupUtils.writeFileFromIS(out, new FileInputStream(source));
                        }
                        Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
                        intent.setData(Uri.parse((String)("file://" + destFile.getAbsolutePath())));
                        context.sendBroadcast(intent);
                    } else {
                        ContentValues contentValues = new ContentValues();
                        contentValues.put("_display_name", destFile.getName());
                        contentValues.put("mime_type", "image/*");
                        Uri contentUri = Environment.getExternalStorageState().equals("mounted") ? MediaStore.Images.Media.EXTERNAL_CONTENT_URI : MediaStore.Images.Media.INTERNAL_CONTENT_URI;
                        contentValues.put("relative_path", Environment.DIRECTORY_DCIM + "/" + context.getPackageName());
                        contentValues.put("is_pending", Integer.valueOf(1));
                        Uri uri2 = context.getContentResolver().insert(contentUri, contentValues);
                        if (uri2 == null) {
                            XPopupUtils.showToast(context, context.getString(R.string.xpopup_saved_fail));
                            return;
                        }
                        ContentResolver resolver = context.getContentResolver();
                        try (OutputStream out = resolver.openOutputStream(uri2);){
                            XPopupUtils.writeFileFromIS(out, new FileInputStream(source));
                        }
                        contentValues.clear();
                        contentValues.put("is_pending", Integer.valueOf(0));
                        resolver.update(uri2, contentValues, null, null);
                    }
                    XPopupUtils.showToast(context, context.getString(R.string.xpopup_saved_to_gallery));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    XPopupUtils.showToast(context, context.getString(R.string.xpopup_saved_fail));
                }
            }
        });
    }

    private static void showToast(final Context context, final String text) {
        Handler mainHandler = new Handler(Looper.getMainLooper());
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (context != null) {
                    Toast.makeText((Context)context, (CharSequence)text, (int)0).show();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeFileFromIS(OutputStream fos, InputStream is) {
        BufferedOutputStream os = null;
        try {
            int len;
            os = new BufferedOutputStream(fos);
            byte[] data = new byte[8192];
            while ((len = is.read(data, 0, 8192)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap renderScriptBlur(Context context, Bitmap src, @FloatRange(from=0.0, to=25.0, fromInclusive=false) float radius, boolean recycle) {
        RenderScript rs = null;
        Bitmap ret = recycle ? src : src.copy(src.getConfig(), true);
        try {
            rs = RenderScript.create((Context)context);
            rs.setMessageHandler(new RenderScript.RSMessageHandler());
            Allocation input = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)ret, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
            Allocation output = Allocation.createTyped((RenderScript)rs, (Type)input.getType());
            ScriptIntrinsicBlur blurScript = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            blurScript.setInput(input);
            blurScript.setRadius(radius);
            blurScript.forEach(output);
            output.copyTo(ret);
        }
        finally {
            if (rs != null) {
                rs.destroy();
            }
        }
        return ret;
    }

    public static Bitmap view2Bitmap(View view) {
        Bitmap bitmap;
        if (view == null) {
            return null;
        }
        boolean drawingCacheEnabled = view.isDrawingCacheEnabled();
        boolean willNotCacheDrawing = view.willNotCacheDrawing();
        view.setDrawingCacheEnabled(true);
        view.setWillNotCacheDrawing(false);
        Bitmap drawingCache = view.getDrawingCache();
        if (null == drawingCache) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
            view.buildDrawingCache();
            drawingCache = view.getDrawingCache();
            if (drawingCache != null) {
                bitmap = Bitmap.createBitmap((Bitmap)drawingCache);
            } else {
                bitmap = Bitmap.createBitmap((int)view.getMeasuredWidth(), (int)view.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                view.draw(canvas);
            }
        } else {
            bitmap = Bitmap.createBitmap((Bitmap)drawingCache);
        }
        view.destroyDrawingCache();
        view.setWillNotCacheDrawing(willNotCacheDrawing);
        view.setDrawingCacheEnabled(drawingCacheEnabled);
        return bitmap;
    }

    public static boolean isLayoutRtl(Context context) {
        Locale primaryLocale = Build.VERSION.SDK_INT >= 24 ? context.getResources().getConfiguration().getLocales().get(0) : context.getResources().getConfiguration().locale;
        return TextUtils.getLayoutDirectionFromLocale((Locale)primaryLocale) == 1;
    }

    public static Activity context2Activity(View view) {
        Context context = view.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public static Drawable createDrawable(int color2, float radius) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setShape(0);
        drawable.setColor(color2);
        drawable.setCornerRadius(radius);
        return drawable;
    }

    public static Drawable createDrawable(int color2, float tlRadius, float trRadius, float brRadius, float blRadius) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setShape(0);
        drawable.setColor(color2);
        drawable.setCornerRadii(new float[]{tlRadius, tlRadius, trRadius, trRadius, brRadius, brRadius, blRadius, blRadius});
        return drawable;
    }

    public static boolean hasSetKeyListener(View view) {
        try {
            Object keyListener;
            Class<?> viewClazz = Class.forName("android.view.View");
            Method listenerInfoMethod = viewClazz.getDeclaredMethod("getListenerInfo", new Class[0]);
            if (!listenerInfoMethod.isAccessible()) {
                listenerInfoMethod.setAccessible(true);
            }
            Object listenerInfoObj = listenerInfoMethod.invoke((Object)view, new Object[0]);
            Class<?> listenerInfoClazz = Class.forName("android.view.View$ListenerInfo");
            Field mOnKeyListenerField = listenerInfoClazz.getDeclaredField("mOnKeyListener");
            if (!mOnKeyListenerField.isAccessible()) {
                mOnKeyListenerField.setAccessible(true);
            }
            return (keyListener = mOnKeyListenerField.get(listenerInfoObj)) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int maxWidth, int maxHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        while (height > maxHeight || width > maxWidth) {
            height >>= 1;
            width >>= 1;
            inSampleSize <<= 1;
        }
        return inSampleSize;
    }

    public static Bitmap getBitmap(File file, int maxWidth, int maxHeight) {
        if (file == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        options.inSampleSize = XPopupUtils.calculateInSampleSize(options, maxWidth, maxHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
    }

    public static int[] getImageSize(File file) {
        if (file == null) {
            return new int[]{0, 0};
        }
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)opts);
        return new int[]{opts.outWidth, opts.outHeight};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageType(File file) {
        if (file == null) {
            return "";
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byte[] bytes = new byte[12];
            if (((InputStream)is).read(bytes) != -1) {
                String type = XPopupUtils.bytes2HexString(bytes, true).toUpperCase();
                if (type.contains("FFD8FF")) {
                    String string2 = "jpg";
                    return string2;
                }
                if (type.contains("89504E47")) {
                    String string3 = "png";
                    return string3;
                }
                if (type.contains("47494638")) {
                    String string4 = "gif";
                    return string4;
                }
                if (type.contains("49492A00") || type.contains("4D4D002A")) {
                    String string5 = "tiff";
                    return string5;
                }
                if (type.contains("424D")) {
                    String string6 = "bmp";
                    return string6;
                }
                if (type.startsWith("52494646") && type.endsWith("57454250")) {
                    String string7 = "webp";
                    return string7;
                }
                if (type.contains("00000100") || type.contains("00000200")) {
                    String string8 = "ico";
                    return string8;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static String bytes2HexString(byte[] bytes, boolean isUpperCase) {
        if (bytes == null) {
            return "";
        }
        char[] hexDigits = isUpperCase ? HEX_DIGITS_UPPER : HEX_DIGITS_LOWER;
        int len = bytes.length;
        if (len <= 0) {
            return "";
        }
        char[] ret = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            ret[j++] = hexDigits[bytes[i] >> 4 & 0xF];
            ret[j++] = hexDigits[bytes[i] & 0xF];
        }
        return new String(ret);
    }

    public static int getRotateDegree(String filePath) {
        try {
            ExifInterface exifInterface = new ExifInterface(filePath);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    return 90;
                }
                case 3: {
                    return 180;
                }
                case 8: {
                    return 270;
                }
            }
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static Bitmap rotate(Bitmap src, int degrees, float px, float py) {
        if (degrees == 0) {
            return src;
        }
        Matrix matrix = new Matrix();
        matrix.setRotate((float)degrees, px, py);
        Bitmap ret = Bitmap.createBitmap((Bitmap)src, (int)0, (int)0, (int)src.getWidth(), (int)src.getHeight(), (Matrix)matrix, (boolean)true);
        return ret;
    }

    public static Rect getViewRect(View view) {
        Rect rect = new Rect();
        view.getGlobalVisibleRect(rect);
        return rect;
    }

    public static boolean isLandscape(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }
}

