/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.lxj.xpopup.interfaces.XPopupImageLoader;
import com.lxj.xpopup.util.XPopupUtils;
import java.io.File;

public class SmartGlideImageLoader
implements XPopupImageLoader {
    int errorImg = 0;
    int unit20M = 0x1400000;

    public SmartGlideImageLoader() {
    }

    public SmartGlideImageLoader(int errorImgRes) {
        this.errorImg = errorImgRes;
    }

    public SmartGlideImageLoader(int memorySizeLimit, int errorImgRes) {
        this.errorImg = errorImgRes;
        this.unit20M = memorySizeLimit;
    }

    @Override
    public void loadImage(int position, @NonNull Object url, final @NonNull ImageView imageView, final @Nullable ProgressBar progressBar) {
        Glide.with((View)imageView).asBitmap().load(url).listener((RequestListener)new RequestListener<Bitmap>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                if (progressBar != null) {
                    progressBar.setVisibility(8);
                }
                return false;
            }

            public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource) {
                int r;
                if (progressBar != null) {
                    progressBar.setVisibility(8);
                }
                if ((r = resource.getByteCount() / SmartGlideImageLoader.this.unit20M) >= 1) {
                    imageView.setImageBitmap(XPopupUtils.compressBySampleSize(resource, r));
                    return true;
                }
                return false;
            }
        }).apply(((RequestOptions)new RequestOptions().error(this.errorImg)).override(Integer.MIN_VALUE)).into(imageView);
    }

    @Override
    public File getImageFile(@NonNull Context context, @NonNull Object uri) {
        try {
            return (File)Glide.with((Context)context).downloadOnly().load(uri).submit().get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

