/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.lxj.easyadapter.EasyAdapter;
import com.lxj.easyadapter.MultiItemTypeAdapter;
import com.lxj.easyadapter.ViewHolder;
import com.lxj.xpopup.R;
import com.lxj.xpopup.core.AttachPopupView;
import com.lxj.xpopup.interfaces.OnSelectListener;
import com.lxj.xpopup.widget.VerticalRecyclerView;
import java.util.Arrays;

public class AttachListPopupView
extends AttachPopupView {
    RecyclerView recyclerView;
    protected int bindLayoutId;
    protected int bindItemLayoutId;
    String[] data;
    int[] iconIds;
    private OnSelectListener selectListener;

    public AttachListPopupView(@NonNull Context context, int bindLayoutId, int bindItemLayoutId) {
        super(context);
        this.bindLayoutId = bindLayoutId;
        this.bindItemLayoutId = bindItemLayoutId;
        this.addInnerContent();
    }

    @Override
    protected int getImplLayoutId() {
        return this.bindLayoutId == 0 ? R.layout._xpopup_attach_impl_list : this.bindLayoutId;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        if (this.bindLayoutId != 0) {
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        }
        EasyAdapter<String> adapter = new EasyAdapter<String>(Arrays.asList(this.data), this.bindItemLayoutId == 0 ? R.layout._xpopup_adapter_text : this.bindItemLayoutId){

            protected void bind(@NonNull ViewHolder holder, @NonNull String s, int position) {
                holder.setText(R.id.tv_text, (CharSequence)s);
                if (AttachListPopupView.this.iconIds != null && AttachListPopupView.this.iconIds.length > position) {
                    holder.getView(R.id.iv_image).setVisibility(0);
                    holder.getView(R.id.iv_image).setBackgroundResource(AttachListPopupView.this.iconIds[position]);
                } else {
                    holder.getView(R.id.iv_image).setVisibility(8);
                }
                if (AttachListPopupView.this.bindItemLayoutId == 0) {
                    if (AttachListPopupView.this.popupInfo.isDarkTheme) {
                        ((TextView)holder.getView(R.id.tv_text)).setTextColor(AttachListPopupView.this.getResources().getColor(R.color._xpopup_white_color));
                    } else {
                        ((TextView)holder.getView(R.id.tv_text)).setTextColor(AttachListPopupView.this.getResources().getColor(R.color._xpopup_dark_color));
                    }
                }
            }
        };
        adapter.setOnItemClickListener((MultiItemTypeAdapter.OnItemClickListener)new MultiItemTypeAdapter.SimpleOnItemClickListener((EasyAdapter)adapter){
            final /* synthetic */ EasyAdapter val$adapter;
            {
                this.val$adapter = easyAdapter;
            }

            public void onItemClick(View view, RecyclerView.ViewHolder holder, int position) {
                if (AttachListPopupView.this.selectListener != null) {
                    AttachListPopupView.this.selectListener.onSelect(position, (String)this.val$adapter.getData().get(position));
                }
                if (AttachListPopupView.this.popupInfo.autoDismiss.booleanValue()) {
                    AttachListPopupView.this.dismiss();
                }
            }
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        this.applyTheme();
    }

    protected void applyTheme() {
        if (this.bindLayoutId == 0) {
            if (this.popupInfo.isDarkTheme) {
                this.applyDarkTheme();
            } else {
                this.applyLightTheme();
            }
        }
    }

    @Override
    protected void applyDarkTheme() {
        super.applyDarkTheme();
        ((VerticalRecyclerView)this.recyclerView).setupDivider(true);
    }

    @Override
    protected void applyLightTheme() {
        super.applyLightTheme();
        ((VerticalRecyclerView)this.recyclerView).setupDivider(false);
    }

    public AttachListPopupView setStringData(String[] data, int[] iconIds) {
        this.data = data;
        this.iconIds = iconIds;
        return this;
    }

    public AttachListPopupView setOnSelectListener(OnSelectListener selectListener) {
        this.selectListener = selectListener;
        return this;
    }
}

