/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.transition.ChangeBounds;
import androidx.transition.Transition;
import androidx.transition.TransitionManager;
import androidx.transition.TransitionSet;
import com.google.android.material.transition.MaterialFade;
import com.lxj.xpopup.R;
import com.lxj.xpopup.core.CenterPopupView;
import com.lxj.xpopup.util.XPopupUtils;

public class LoadingPopupView
extends CenterPopupView {
    private Style loadingStyle = Style.Spinner;
    private TextView tv_title;
    private View progressBar;
    private View spinnerView;
    private boolean firstShow = true;
    private CharSequence title;

    public LoadingPopupView(@NonNull Context context, int bindLayoutId) {
        super(context);
        this.bindLayoutId = bindLayoutId;
        this.addInnerContent();
    }

    @Override
    protected int getImplLayoutId() {
        return this.bindLayoutId != 0 ? this.bindLayoutId : R.layout._xpopup_center_impl_loading;
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        this.progressBar = this.findViewById(R.id.loadProgress);
        this.spinnerView = this.findViewById(R.id.loadview);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getPopupImplView().setElevation(10.0f);
        }
        if (this.bindLayoutId == 0) {
            this.getPopupImplView().setBackground(XPopupUtils.createDrawable(Color.parseColor((String)"#212121"), this.popupInfo.borderRadius));
        }
        this.setup();
    }

    @Override
    protected void onShow() {
        super.onShow();
        this.firstShow = false;
    }

    protected void setup() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!LoadingPopupView.this.firstShow) {
                    TransitionSet set = new TransitionSet().setDuration((long)LoadingPopupView.this.getAnimationDuration()).addTransition((Transition)new MaterialFade()).addTransition((Transition)new ChangeBounds());
                    TransitionManager.beginDelayedTransition((ViewGroup)LoadingPopupView.this.centerPopupContainer, (Transition)set);
                }
                if (LoadingPopupView.this.title == null || LoadingPopupView.this.title.length() == 0) {
                    XPopupUtils.setVisible((View)LoadingPopupView.this.tv_title, false);
                } else {
                    XPopupUtils.setVisible((View)LoadingPopupView.this.tv_title, true);
                    if (LoadingPopupView.this.tv_title != null) {
                        LoadingPopupView.this.tv_title.setText(LoadingPopupView.this.title);
                    }
                }
                if (LoadingPopupView.this.loadingStyle == Style.Spinner) {
                    XPopupUtils.setVisible(LoadingPopupView.this.progressBar, false);
                    XPopupUtils.setVisible(LoadingPopupView.this.spinnerView, true);
                } else {
                    XPopupUtils.setVisible(LoadingPopupView.this.progressBar, true);
                    XPopupUtils.setVisible(LoadingPopupView.this.spinnerView, false);
                }
            }
        });
    }

    public LoadingPopupView setTitle(CharSequence title) {
        this.title = title;
        this.setup();
        return this;
    }

    public LoadingPopupView setStyle(Style style2) {
        this.loadingStyle = style2;
        this.setup();
        return this;
    }

    @Override
    protected void onDismiss() {
        super.onDismiss();
        this.firstShow = true;
    }

    public static enum Style {
        Spinner,
        ProgressBar;

    }
}

