/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.BlurAnimator;
import com.lxj.xpopup.animator.EmptyAnimator;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScaleAlphaAnimator;
import com.lxj.xpopup.animator.ScrollScaleAnimator;
import com.lxj.xpopup.animator.ShadowBgAnimator;
import com.lxj.xpopup.animator.TranslateAlphaAnimator;
import com.lxj.xpopup.animator.TranslateAnimator;
import com.lxj.xpopup.core.FullScreenDialog;
import com.lxj.xpopup.core.ImageViewerPopupView;
import com.lxj.xpopup.core.PopupInfo;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupStatus;
import com.lxj.xpopup.impl.FullScreenPopupView;
import com.lxj.xpopup.impl.PartShadowPopupView;
import com.lxj.xpopup.util.KeyboardUtils;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.util.navbar.NavigationBarObserver;
import com.lxj.xpopup.util.navbar.OnNavigationBarListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class BasePopupView
extends FrameLayout
implements OnNavigationBarListener,
LifecycleObserver {
    private static Stack<BasePopupView> stack = new Stack();
    public PopupInfo popupInfo;
    protected PopupAnimator popupContentAnimator;
    protected ShadowBgAnimator shadowBgAnimator;
    protected BlurAnimator blurAnimator;
    private int touchSlop;
    public PopupStatus popupStatus = PopupStatus.Dismiss;
    private boolean isCreated = false;
    private Handler handler = new Handler(Looper.getMainLooper());
    private Runnable initTask = new Runnable(){

        @Override
        public void run() {
            BasePopupView.this.applySize(false);
            BasePopupView.this.getPopupContentView().setAlpha(1.0f);
            BasePopupView.this.collectAnimator();
            if (BasePopupView.this.popupInfo.xPopupCallback != null) {
                BasePopupView.this.popupInfo.xPopupCallback.beforeShow();
            }
            BasePopupView.this.doShowAnimation();
            BasePopupView.this.doAfterShow();
        }
    };
    private boolean hasMoveUp = false;
    private Runnable attachTask = new Runnable(){

        @Override
        public void run() {
            BasePopupView.this.attachDialog();
            if (BasePopupView.this.getContext() instanceof FragmentActivity) {
                ((FragmentActivity)BasePopupView.this.getContext()).getLifecycle().addObserver((LifecycleObserver)BasePopupView.this);
            }
            BasePopupView.this.popupInfo.decorView = (ViewGroup)BasePopupView.this.dialog.getWindow().getDecorView();
            KeyboardUtils.registerSoftInputChangedListener(BasePopupView.this.dialog.getWindow(), BasePopupView.this, new KeyboardUtils.OnSoftInputChangedListener(){

                @Override
                public void onSoftInputChanged(int height) {
                    if (height == 0) {
                        XPopupUtils.moveDown(BasePopupView.this);
                        BasePopupView.this.hasMoveUp = false;
                    } else {
                        if (BasePopupView.this instanceof FullScreenPopupView && BasePopupView.this.popupStatus == PopupStatus.Showing) {
                            return;
                        }
                        if (BasePopupView.this instanceof PartShadowPopupView && BasePopupView.this.popupStatus == PopupStatus.Showing) {
                            return;
                        }
                        XPopupUtils.moveUpToKeyboard(height, BasePopupView.this);
                        BasePopupView.this.hasMoveUp = true;
                    }
                }
            });
            BasePopupView.this.init();
        }
    };
    protected FullScreenDialog dialog;
    private Runnable doAfterShowTask = new Runnable(){

        @Override
        public void run() {
            BasePopupView.this.popupStatus = PopupStatus.Show;
            BasePopupView.this.onShow();
            BasePopupView.this.focusAndProcessBackPress();
            if (BasePopupView.this.popupInfo != null && BasePopupView.this.popupInfo.xPopupCallback != null) {
                BasePopupView.this.popupInfo.xPopupCallback.onShow();
            }
            if (BasePopupView.this.dialog == null) {
                return;
            }
            if (XPopupUtils.getDecorViewInvisibleHeight(BasePopupView.this.dialog.getWindow()) > 0 && !BasePopupView.this.hasMoveUp) {
                XPopupUtils.moveUpToKeyboard(XPopupUtils.getDecorViewInvisibleHeight(BasePopupView.this.dialog.getWindow()), BasePopupView.this);
            }
        }
    };
    private ShowSoftInputTask showSoftInputTask;
    private Runnable doAfterDismissTask = new Runnable(){

        @Override
        public void run() {
            if (BasePopupView.this.popupInfo.autoOpenSoftInput.booleanValue() && BasePopupView.this instanceof PartShadowPopupView) {
                KeyboardUtils.hideSoftInput((View)BasePopupView.this);
            }
            BasePopupView.this.onDismiss();
            if (BasePopupView.this.popupInfo != null && BasePopupView.this.popupInfo.xPopupCallback != null) {
                BasePopupView.this.popupInfo.xPopupCallback.onDismiss();
            }
            if (BasePopupView.this.dismissWithRunnable != null) {
                BasePopupView.this.dismissWithRunnable.run();
                BasePopupView.this.dismissWithRunnable = null;
            }
            BasePopupView.this.popupStatus = PopupStatus.Dismiss;
            NavigationBarObserver.getInstance().removeOnNavigationBarListener(BasePopupView.this);
            if (!stack.isEmpty()) {
                stack.pop();
            }
            if (BasePopupView.this.popupInfo != null && BasePopupView.this.popupInfo.isRequestFocus) {
                if (!stack.isEmpty()) {
                    ((BasePopupView)stack.get(stack.size() - 1)).focusAndProcessBackPress();
                } else {
                    View needFocusView = BasePopupView.this.popupInfo.decorView.findViewById(0x1020002);
                    if (needFocusView != null) {
                        needFocusView.setFocusable(true);
                        needFocusView.setFocusableInTouchMode(true);
                    }
                }
            }
            if (BasePopupView.this.popupInfo != null && BasePopupView.this.popupInfo.decorView != null) {
                BasePopupView.this.dialog.dismiss();
            }
        }
    };
    Runnable dismissWithRunnable;
    private float x;
    private float y;

    public BasePopupView(@NonNull Context context) {
        super(context);
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.shadowBgAnimator = new ShadowBgAnimator((View)this);
        View contentView = LayoutInflater.from((Context)context).inflate(this.getPopupLayoutId(), (ViewGroup)this, false);
        contentView.setAlpha(0.0f);
        this.addView(contentView);
    }

    protected void init() {
        NavigationBarObserver.getInstance().register(this.getContext());
        NavigationBarObserver.getInstance().addOnNavigationBarListener(this);
        if (!this.isCreated) {
            this.initPopupContent();
        }
        if (!(this instanceof FullScreenPopupView) && !(this instanceof ImageViewerPopupView)) {
            XPopupUtils.setWidthHeight(this.getTargetSizeView(), this.getMaxWidth() != 0 && this.getPopupWidth() > this.getMaxWidth() ? this.getMaxWidth() : this.getPopupWidth(), this.getMaxHeight() != 0 && this.getPopupHeight() > this.getMaxHeight() ? this.getMaxHeight() : this.getPopupHeight());
        }
        if (!this.isCreated) {
            this.isCreated = true;
            this.onCreate();
            if (this.popupInfo.xPopupCallback != null) {
                this.popupInfo.xPopupCallback.onCreated();
            }
        }
        this.handler.postDelayed(this.initTask, 50L);
    }

    private void collectAnimator() {
        if (this.popupContentAnimator == null) {
            if (this.popupInfo.customAnimator != null) {
                this.popupContentAnimator = this.popupInfo.customAnimator;
                this.popupContentAnimator.targetView = this.getPopupContentView();
            } else {
                this.popupContentAnimator = this.genAnimatorByPopupType();
                if (this.popupContentAnimator == null) {
                    this.popupContentAnimator = this.getPopupAnimator();
                }
            }
            if (this.popupInfo.hasShadowBg.booleanValue()) {
                this.shadowBgAnimator.initAnimator();
            }
            if (this.popupInfo.hasBlurBg.booleanValue()) {
                this.blurAnimator = new BlurAnimator((View)this);
                this.blurAnimator.hasShadowBg = this.popupInfo.hasShadowBg;
                this.blurAnimator.decorBitmap = XPopupUtils.view2Bitmap(((Activity)this.getContext()).getWindow().getDecorView());
                this.blurAnimator.initAnimator();
            }
            if (this.popupContentAnimator != null) {
                this.popupContentAnimator.initAnimator();
            }
        }
    }

    @Override
    public void onNavigationBarChange(boolean show) {
        if (!show) {
            this.applyFull();
        } else {
            this.applySize(true);
        }
    }

    protected void applyFull() {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        params.topMargin = 0;
        params.leftMargin = 0;
        params.bottomMargin = 0;
        params.rightMargin = 0;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    protected void applySize(boolean isShowNavBar) {
        int height = XPopupUtils.getPhoneScreenHeight(this.dialog.getWindow());
        if (this.popupInfo.decorView.getChildCount() > 0) {
            height = this.popupInfo.decorView.getChildAt(0).getMeasuredHeight();
        }
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        int rotation = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getRotation();
        boolean isNavBarShown = XPopupUtils.isNavBarVisible(this.dialog.getWindow());
        if (rotation == 0) {
            params.leftMargin = 0;
            params.rightMargin = 0;
            params.bottomMargin = 0;
        } else if (rotation == 1) {
            params.bottomMargin = 0;
            params.rightMargin = isNavBarShown ? XPopupUtils.getPhoneScreenHeight(this.dialog.getWindow()) - height : 0;
            params.leftMargin = 0;
        } else if (rotation == 3) {
            params.bottomMargin = 0;
            params.leftMargin = 0;
            params.rightMargin = isNavBarShown ? XPopupUtils.getPhoneScreenHeight(this.dialog.getWindow()) - height : 0;
        }
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public BasePopupView show() {
        if (this.popupStatus == PopupStatus.Showing) {
            return this;
        }
        this.popupStatus = PopupStatus.Showing;
        if (this.dialog != null && this.dialog.isShowing()) {
            return this;
        }
        this.handler.post(this.attachTask);
        return this;
    }

    private void attachDialog() {
        if (this.dialog == null) {
            this.dialog = new FullScreenDialog(this.getContext()).setContent(this);
        }
        this.dialog.show();
    }

    protected void doAfterShow() {
        this.handler.removeCallbacks(this.doAfterShowTask);
        this.handler.postDelayed(this.doAfterShowTask, (long)this.getAnimationDuration());
    }

    public void focusAndProcessBackPress() {
        if (this.popupInfo.isRequestFocus) {
            this.setFocusableInTouchMode(true);
            this.requestFocus();
            if (!stack.contains(this)) {
                stack.push(this);
            }
        }
        this.setOnKeyListener(new BackPressListener());
        if (!this.popupInfo.autoFocusEditText) {
            this.showSoftInput((View)this);
        }
        ArrayList<EditText> list = new ArrayList<EditText>();
        XPopupUtils.findAllEditText(list, (ViewGroup)this.getPopupContentView());
        for (int i = 0; i < list.size(); ++i) {
            EditText et = list.get(i);
            et.setOnKeyListener((View.OnKeyListener)new BackPressListener());
            if (i != 0 || !this.popupInfo.autoFocusEditText) continue;
            et.setFocusable(true);
            et.setFocusableInTouchMode(true);
            et.requestFocus();
            this.showSoftInput((View)et);
        }
    }

    protected void showSoftInput(View focusView) {
        if (this.popupInfo.autoOpenSoftInput.booleanValue()) {
            if (this.showSoftInputTask == null) {
                this.showSoftInputTask = new ShowSoftInputTask(focusView);
            } else {
                this.handler.removeCallbacks((Runnable)this.showSoftInputTask);
            }
            this.handler.postDelayed((Runnable)this.showSoftInputTask, 10L);
        }
    }

    protected void dismissOrHideSoftInput() {
        if (KeyboardUtils.sDecorViewInvisibleHeightPre == 0) {
            this.dismiss();
        } else {
            KeyboardUtils.hideSoftInput((View)this);
        }
    }

    protected PopupAnimator genAnimatorByPopupType() {
        if (this.popupInfo == null || this.popupInfo.popupAnimation == null) {
            return null;
        }
        switch (this.popupInfo.popupAnimation) {
            case ScaleAlphaFromCenter: 
            case ScaleAlphaFromLeftTop: 
            case ScaleAlphaFromRightTop: 
            case ScaleAlphaFromLeftBottom: 
            case ScaleAlphaFromRightBottom: {
                return new ScaleAlphaAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case TranslateAlphaFromLeft: 
            case TranslateAlphaFromTop: 
            case TranslateAlphaFromRight: 
            case TranslateAlphaFromBottom: {
                return new TranslateAlphaAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case TranslateFromLeft: 
            case TranslateFromTop: 
            case TranslateFromRight: 
            case TranslateFromBottom: {
                return new TranslateAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case ScrollAlphaFromLeft: 
            case ScrollAlphaFromLeftTop: 
            case ScrollAlphaFromTop: 
            case ScrollAlphaFromRightTop: 
            case ScrollAlphaFromRight: 
            case ScrollAlphaFromRightBottom: 
            case ScrollAlphaFromBottom: 
            case ScrollAlphaFromLeftBottom: {
                return new ScrollScaleAnimator(this.getPopupContentView(), this.popupInfo.popupAnimation);
            }
            case NoAnimation: {
                return new EmptyAnimator(this.getPopupContentView());
            }
        }
        return null;
    }

    protected abstract int getPopupLayoutId();

    protected int getImplLayoutId() {
        return -1;
    }

    protected PopupAnimator getPopupAnimator() {
        return null;
    }

    protected void initPopupContent() {
    }

    protected void onCreate() {
    }

    protected void applyDarkTheme() {
    }

    protected void doShowAnimation() {
        if (this.popupInfo.hasShadowBg.booleanValue() && !this.popupInfo.hasBlurBg.booleanValue()) {
            this.shadowBgAnimator.animateShow();
        } else if (this.popupInfo.hasBlurBg.booleanValue() && this.blurAnimator != null) {
            this.blurAnimator.animateShow();
        }
        if (this.popupContentAnimator != null) {
            this.popupContentAnimator.animateShow();
        }
    }

    protected void doDismissAnimation() {
        if (this.popupInfo.hasShadowBg.booleanValue() && !this.popupInfo.hasBlurBg.booleanValue()) {
            this.shadowBgAnimator.animateDismiss();
        } else if (this.popupInfo.hasBlurBg.booleanValue() && this.blurAnimator != null) {
            this.blurAnimator.animateDismiss();
        }
        if (this.popupContentAnimator != null) {
            this.popupContentAnimator.animateDismiss();
        }
    }

    public View getPopupContentView() {
        return this.getChildAt(0);
    }

    public View getPopupImplView() {
        return ((ViewGroup)this.getPopupContentView()).getChildAt(0);
    }

    public int getAnimationDuration() {
        return this.popupInfo.popupAnimation == PopupAnimation.NoAnimation ? 10 : XPopup.getAnimationDuration() + 10;
    }

    protected int getMaxWidth() {
        return 0;
    }

    protected int getMaxHeight() {
        return this.popupInfo.maxHeight;
    }

    protected int getPopupWidth() {
        return 0;
    }

    protected int getPopupHeight() {
        return 0;
    }

    protected View getTargetSizeView() {
        return this.getPopupContentView();
    }

    public void dismiss() {
        this.handler.removeCallbacks(this.attachTask);
        this.handler.removeCallbacks(this.initTask);
        if (this.popupStatus == PopupStatus.Dismissing || this.popupStatus == PopupStatus.Dismiss) {
            return;
        }
        this.popupStatus = PopupStatus.Dismissing;
        this.clearFocus();
        this.doDismissAnimation();
        this.doAfterDismiss();
    }

    public void smartDismiss() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                BasePopupView.this.delayDismiss(XPopup.getAnimationDuration() + 50);
            }
        });
    }

    public void delayDismiss(long delay) {
        if (delay < 0L) {
            delay = 0L;
        }
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                BasePopupView.this.dismiss();
            }
        }, delay);
    }

    public void delayDismissWith(long delay, Runnable runnable) {
        this.dismissWithRunnable = runnable;
        this.delayDismiss(delay);
    }

    protected void doAfterDismiss() {
        if (this.popupInfo == null || this.popupInfo.decorView == null) {
            return;
        }
        if (this.popupInfo.autoOpenSoftInput.booleanValue() && !(this instanceof PartShadowPopupView)) {
            KeyboardUtils.hideSoftInput((View)this);
        }
        this.handler.removeCallbacks(this.doAfterDismissTask);
        this.handler.postDelayed(this.doAfterDismissTask, (long)this.getAnimationDuration());
    }

    public void dismissWith(Runnable runnable) {
        this.dismissWithRunnable = runnable;
        this.dismiss();
    }

    public boolean isShow() {
        return this.popupStatus != PopupStatus.Dismiss;
    }

    public boolean isDismiss() {
        return this.popupStatus == PopupStatus.Dismiss;
    }

    public void toggle() {
        if (this.isShow()) {
            this.dismiss();
        } else {
            this.show();
        }
    }

    protected void onDismiss() {
        FragmentManager manager;
        List fragments;
        if (this.getContext() instanceof FragmentActivity && (fragments = (manager = ((FragmentActivity)this.getContext()).getSupportFragmentManager()).getFragments()) != null && fragments.size() > 0 && this.getInternalFragmentNames() != null) {
            for (int i = 0; i < fragments.size(); ++i) {
                String name = ((Fragment)fragments.get(i)).getClass().getSimpleName();
                if (!this.getInternalFragmentNames().contains(name)) continue;
                manager.beginTransaction().remove((Fragment)fragments.get(i)).commitAllowingStateLoss();
            }
        }
    }

    protected List<String> getInternalFragmentNames() {
        return null;
    }

    protected void onShow() {
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        this.destroy();
    }

    public void destroy() {
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
        this.onDetachedFromWindow();
        this.popupInfo.atView = null;
        this.popupInfo.watchView = null;
        this.popupInfo.xPopupCallback = null;
        this.popupInfo = null;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        stack.clear();
        this.handler.removeCallbacksAndMessages(null);
        NavigationBarObserver.getInstance().removeOnNavigationBarListener(this);
        if (this.popupInfo != null) {
            if (this.popupInfo.decorView != null) {
                KeyboardUtils.removeLayoutChangeListener((View)this.popupInfo.decorView, this);
            }
            if (this.popupInfo.isDestroyOnDismiss) {
                this.popupInfo.atView = null;
                this.popupInfo.watchView = null;
                this.popupInfo.xPopupCallback = null;
                this.popupInfo = null;
            }
        }
        this.popupStatus = PopupStatus.Dismiss;
        this.showSoftInputTask = null;
        this.hasMoveUp = false;
        if (this.blurAnimator != null && this.blurAnimator.decorBitmap != null && !this.blurAnimator.decorBitmap.isRecycled()) {
            this.blurAnimator.decorBitmap.recycle();
            this.blurAnimator.decorBitmap = null;
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        Rect rect = new Rect();
        this.getPopupContentView().getGlobalVisibleRect(rect);
        if (!XPopupUtils.isInRect(event.getX(), event.getY(), rect)) {
            switch (event.getAction()) {
                case 0: {
                    this.x = event.getX();
                    this.y = event.getY();
                    break;
                }
                case 1: {
                    float dx = event.getX() - this.x;
                    float dy = event.getY() - this.y;
                    float distance = (float)Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0));
                    if (distance < (float)this.touchSlop && this.popupInfo.isDismissOnTouchOutside.booleanValue()) {
                        this.dismiss();
                    }
                    this.x = 0.0f;
                    this.y = 0.0f;
                }
            }
        }
        return true;
    }

    class BackPressListener
    implements View.OnKeyListener {
        BackPressListener() {
        }

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (keyCode == 4 && event.getAction() == 1) {
                if (BasePopupView.this.popupInfo.isDismissOnBackPressed.booleanValue() && (BasePopupView.this.popupInfo.xPopupCallback == null || !BasePopupView.this.popupInfo.xPopupCallback.onBackPressed())) {
                    BasePopupView.this.dismissOrHideSoftInput();
                }
                return true;
            }
            return false;
        }
    }

    static class ShowSoftInputTask
    implements Runnable {
        View focusView;
        boolean isDone = false;

        public ShowSoftInputTask(View focusView) {
            this.focusView = focusView;
        }

        @Override
        public void run() {
            if (this.focusView != null && !this.isDone) {
                this.isDone = true;
                KeyboardUtils.showSoftInput(this.focusView);
            }
        }
    }
}

