/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.lxj.xpopup.R;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.animator.ScrollScaleAnimator;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.enums.PopupPosition;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.PartShadowContainer;

public abstract class AttachPopupView
extends BasePopupView {
    protected int defaultOffsetY = 0;
    protected int defaultOffsetX = 0;
    protected PartShadowContainer attachPopupContainer;
    public boolean isShowUp;
    boolean isShowLeft;
    protected int bgDrawableMargin = 6;
    float translationX = 0.0f;
    float translationY = 0.0f;
    float maxY = XPopupUtils.getWindowHeight(this.getContext());
    float maxX = 0.0f;

    public AttachPopupView(@NonNull Context context) {
        super(context);
        this.attachPopupContainer = (PartShadowContainer)this.findViewById(R.id.attachPopupContainer);
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout._xpopup_attach_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.attachPopupContainer, false);
        this.attachPopupContainer.addView(contentView);
        if (this.popupInfo.getAtView() == null && this.popupInfo.touchPoint == null) {
            throw new IllegalArgumentException("atView() or touchPoint must not be null for AttachPopupView \uff01");
        }
        this.defaultOffsetY = this.popupInfo.offsetY == 0 ? XPopupUtils.dp2px(this.getContext(), 4.0f) : this.popupInfo.offsetY;
        this.defaultOffsetX = this.popupInfo.offsetX == 0 ? XPopupUtils.dp2px(this.getContext(), 0.0f) : this.popupInfo.offsetX;
        this.attachPopupContainer.setTranslationX(this.popupInfo.offsetX);
        this.attachPopupContainer.setTranslationY(this.popupInfo.offsetY);
        if (!this.popupInfo.hasShadowBg.booleanValue()) {
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.getPopupImplView().getBackground() != null) {
                    Drawable newDrawable = this.getPopupImplView().getBackground().getConstantState().newDrawable();
                    this.attachPopupContainer.setBackground(newDrawable);
                    this.getPopupImplView().setBackground(null);
                } else {
                    this.attachPopupContainer.setBackgroundColor(-1);
                }
                this.attachPopupContainer.setElevation(XPopupUtils.dp2px(this.getContext(), 20.0f));
            } else if (this.getPopupImplView().getBackground() == null) {
                this.defaultOffsetX -= this.bgDrawableMargin;
                this.defaultOffsetY -= this.bgDrawableMargin;
                this.attachPopupContainer.setBackgroundResource(R.drawable._xpopup_shadow);
            } else {
                Drawable newDrawable = this.getPopupImplView().getBackground().getConstantState().newDrawable();
                this.getPopupImplView().setBackground(null);
                this.attachPopupContainer.setBackground(newDrawable);
            }
        }
        XPopupUtils.applyPopupSize((ViewGroup)this.getPopupContentView(), this.getMaxWidth(), this.getMaxHeight(), new Runnable(){

            @Override
            public void run() {
                AttachPopupView.this.doAttach();
            }
        });
    }

    protected void doAttach() {
        if (this.popupInfo.touchPoint != null) {
            boolean isTallerThanWindowHeight;
            this.maxX = Math.max(this.popupInfo.touchPoint.x - (float)this.getPopupContentView().getMeasuredWidth(), 0.0f);
            boolean bl = isTallerThanWindowHeight = this.popupInfo.touchPoint.y + (float)this.getPopupContentView().getMeasuredHeight() > this.maxY;
            this.isShowUp = isTallerThanWindowHeight ? this.popupInfo.touchPoint.y > (float)(XPopupUtils.getWindowHeight(this.getContext()) / 2) : false;
            boolean bl2 = this.isShowLeft = this.popupInfo.touchPoint.x < (float)(XPopupUtils.getWindowWidth(this.getContext()) / 2);
            if (this.isShowUpToTarget()) {
                if ((float)this.getPopupContentView().getMeasuredHeight() > this.popupInfo.touchPoint.y) {
                    ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
                    params.height = (int)(this.popupInfo.touchPoint.y - (float)XPopupUtils.getStatusBarHeight());
                    this.getPopupContentView().setLayoutParams(params);
                }
            } else if ((float)this.getPopupContentView().getMeasuredHeight() + this.popupInfo.touchPoint.y > (float)XPopupUtils.getWindowHeight(this.getContext())) {
                ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
                params.height = (int)((float)XPopupUtils.getWindowHeight(this.getContext()) - this.popupInfo.touchPoint.y);
                this.getPopupContentView().setLayoutParams(params);
            }
            this.getPopupContentView().post(new Runnable(){

                @Override
                public void run() {
                    AttachPopupView.this.translationX = (AttachPopupView.this.isShowLeft ? AttachPopupView.this.popupInfo.touchPoint.x : AttachPopupView.this.maxX) + (float)(AttachPopupView.this.isShowLeft ? AttachPopupView.this.defaultOffsetX : -AttachPopupView.this.defaultOffsetX);
                    if (AttachPopupView.this.popupInfo.isCenterHorizontal) {
                        AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? (AttachPopupView.this.translationX -= (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f) : (AttachPopupView.this.translationX += (float)AttachPopupView.this.getPopupContentView().getMeasuredWidth() / 2.0f);
                    }
                    AttachPopupView.this.translationY = AttachPopupView.this.isShowUpToTarget() ? AttachPopupView.this.popupInfo.touchPoint.y - (float)AttachPopupView.this.getPopupContentView().getMeasuredHeight() - (float)AttachPopupView.this.defaultOffsetY : AttachPopupView.this.popupInfo.touchPoint.y + (float)AttachPopupView.this.defaultOffsetY;
                    AttachPopupView.this.getPopupContentView().setTranslationX(AttachPopupView.this.translationX);
                    AttachPopupView.this.getPopupContentView().setTranslationY(AttachPopupView.this.translationY);
                }
            });
        } else {
            int centerY;
            boolean isTallerThanWindowHeight;
            int[] locations = new int[2];
            this.popupInfo.getAtView().getLocationOnScreen(locations);
            final Rect rect = new Rect(locations[0], locations[1], locations[0] + this.popupInfo.getAtView().getMeasuredWidth(), locations[1] + this.popupInfo.getAtView().getMeasuredHeight());
            this.maxX = Math.max(rect.right - this.getPopupContentView().getMeasuredWidth(), 0);
            int centerX = (rect.left + rect.right) / 2;
            boolean bl = isTallerThanWindowHeight = (float)(rect.bottom + this.getPopupContentView().getMeasuredHeight()) > this.maxY;
            this.isShowUp = isTallerThanWindowHeight ? (centerY = (rect.top + rect.bottom) / 2) > XPopupUtils.getWindowHeight(this.getContext()) / 2 : false;
            boolean bl3 = this.isShowLeft = centerX < XPopupUtils.getWindowWidth(this.getContext()) / 2;
            if (this.isShowUpToTarget()) {
                if (this.getPopupContentView().getMeasuredHeight() > rect.top) {
                    ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
                    params.height = rect.top - XPopupUtils.getStatusBarHeight();
                    this.getPopupContentView().setLayoutParams(params);
                }
            } else if (this.getPopupContentView().getMeasuredHeight() + rect.bottom > XPopupUtils.getWindowHeight(this.getContext())) {
                ViewGroup.LayoutParams params = this.getPopupContentView().getLayoutParams();
                params.height = XPopupUtils.getWindowHeight(this.getContext()) - rect.bottom;
                this.getPopupContentView().setLayoutParams(params);
            }
            this.getPopupContentView().post(new Runnable(){

                @Override
                public void run() {
                    AttachPopupView.this.translationX = (AttachPopupView.this.isShowLeft ? (float)rect.left : AttachPopupView.this.maxX) + (float)(AttachPopupView.this.isShowLeft ? AttachPopupView.this.defaultOffsetX : -AttachPopupView.this.defaultOffsetX);
                    if (AttachPopupView.this.popupInfo.isCenterHorizontal) {
                        AttachPopupView.this.translationX = AttachPopupView.this.isShowLeft ? (AttachPopupView.this.translationX += (float)(rect.width() - AttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f) : (AttachPopupView.this.translationX -= (float)(rect.width() - AttachPopupView.this.getPopupContentView().getMeasuredWidth()) / 2.0f);
                    }
                    AttachPopupView.this.translationY = AttachPopupView.this.isShowUpToTarget() ? (float)(rect.top - AttachPopupView.this.getPopupContentView().getMeasuredHeight() - AttachPopupView.this.defaultOffsetY) : (float)(rect.bottom + AttachPopupView.this.defaultOffsetY);
                    AttachPopupView.this.getPopupContentView().setTranslationX(AttachPopupView.this.translationX);
                    AttachPopupView.this.getPopupContentView().setTranslationY(AttachPopupView.this.translationY);
                }
            });
        }
    }

    protected boolean isShowUpToTarget() {
        return (this.isShowUp || this.popupInfo.popupPosition == PopupPosition.Top) && this.popupInfo.popupPosition != PopupPosition.Bottom;
    }

    @Override
    protected PopupAnimator getPopupAnimator() {
        ScrollScaleAnimator animator = this.isShowUpToTarget() ? new ScrollScaleAnimator(this.getPopupContentView(), this.isShowLeft ? PopupAnimation.ScrollAlphaFromLeftBottom : PopupAnimation.ScrollAlphaFromRightBottom) : new ScrollScaleAnimator(this.getPopupContentView(), this.isShowLeft ? PopupAnimation.ScrollAlphaFromLeftTop : PopupAnimation.ScrollAlphaFromRightTop);
        return animator;
    }
}

