/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.widget;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.lxj.xpopup.util.XPopupUtils;

public class LoadingView
extends View {
    private Paint paint;
    private float radius;
    private float radiusOffset;
    private float stokeWidth = 2.0f;
    private ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    private int startColor = Color.parseColor((String)"#CCCCCC");
    private int endColor = Color.parseColor((String)"#333333");
    int lineCount = 12;
    float avgAngle = 360.0f / (float)this.lineCount;
    int time = 0;
    float centerX;
    float centerY;
    float startX;
    float endX;
    private Runnable increaseTask = new Runnable(){

        @Override
        public void run() {
            ++LoadingView.this.time;
            LoadingView.this.postInvalidate(0, 0, LoadingView.this.getMeasuredWidth(), LoadingView.this.getMeasuredHeight());
        }
    };

    public LoadingView(Context context) {
        this(context, null);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.paint = new Paint(1);
        this.stokeWidth = XPopupUtils.dp2px(context, this.stokeWidth);
        this.paint.setStrokeWidth(this.stokeWidth);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.radius = this.getMeasuredWidth() / 2;
        this.radiusOffset = this.radius / 2.5f;
        this.centerX = this.getMeasuredWidth() / 2;
        this.centerY = this.getMeasuredHeight() / 2;
        this.stokeWidth *= (float)this.getMeasuredWidth() * 1.0f / (float)XPopupUtils.dp2px(this.getContext(), 30.0f);
        this.paint.setStrokeWidth(this.stokeWidth);
        this.startX = this.centerX + this.radiusOffset;
        this.endX = this.startX + this.radius / 3.0f;
        this.removeCallbacks(this.increaseTask);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = this.lineCount - 1; i >= 0; --i) {
            int temp = Math.abs(i + this.time) % this.lineCount;
            float fraction = (float)(temp + 1) * 1.0f / (float)this.lineCount;
            int color2 = (Integer)this.argbEvaluator.evaluate(fraction, (Object)this.startColor, (Object)this.endColor);
            this.paint.setColor(color2);
            canvas.drawLine(this.startX, this.centerY, this.endX, this.centerY, this.paint);
            canvas.drawCircle(this.startX, this.centerY, this.stokeWidth / 2.0f, this.paint);
            canvas.drawCircle(this.endX, this.centerY, this.stokeWidth / 2.0f, this.paint);
            canvas.rotate(this.avgAngle, this.centerX, this.centerY);
        }
        this.postDelayed(this.increaseTask, 60L);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.increaseTask);
    }
}

