/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.animator;

import android.animation.TimeInterpolator;
import android.view.View;
import android.view.animation.OvershootInterpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.enums.PopupAnimation;

public class ScaleAlphaAnimator
extends PopupAnimator {
    public ScaleAlphaAnimator(View target, PopupAnimation popupAnimation) {
        super(target, popupAnimation);
    }

    @Override
    public void initAnimator() {
        this.targetView.setScaleX(0.0f);
        this.targetView.setScaleY(0.0f);
        this.targetView.setAlpha(0.0f);
        this.targetView.post(new Runnable(){

            @Override
            public void run() {
                ScaleAlphaAnimator.this.applyPivot();
            }
        });
    }

    private void applyPivot() {
        switch (this.popupAnimation) {
            case ScaleAlphaFromCenter: {
                this.targetView.setPivotX((float)(this.targetView.getMeasuredWidth() / 2));
                this.targetView.setPivotY((float)(this.targetView.getMeasuredHeight() / 2));
                break;
            }
            case ScaleAlphaFromLeftTop: {
                this.targetView.setPivotX(0.0f);
                this.targetView.setPivotY(0.0f);
                break;
            }
            case ScaleAlphaFromRightTop: {
                this.targetView.setPivotX((float)this.targetView.getMeasuredWidth());
                this.targetView.setPivotY(0.0f);
                break;
            }
            case ScaleAlphaFromLeftBottom: {
                this.targetView.setPivotX(0.0f);
                this.targetView.setPivotY((float)this.targetView.getMeasuredHeight());
                break;
            }
            case ScaleAlphaFromRightBottom: {
                this.targetView.setPivotX((float)this.targetView.getMeasuredWidth());
                this.targetView.setPivotY((float)this.targetView.getMeasuredHeight());
            }
        }
    }

    @Override
    public void animateShow() {
        this.targetView.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setDuration((long)XPopup.getAnimationDuration()).setInterpolator((TimeInterpolator)new OvershootInterpolator(1.0f)).start();
    }

    @Override
    public void animateDismiss() {
        this.targetView.animate().scaleX(0.0f).scaleY(0.0f).alpha(0.0f).setDuration((long)XPopup.getAnimationDuration()).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).start();
    }
}

