/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.core;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.transition.ChangeBounds;
import androidx.transition.ChangeImageTransform;
import androidx.transition.ChangeTransform;
import androidx.transition.Transition;
import androidx.transition.TransitionListenerAdapter;
import androidx.transition.TransitionManager;
import androidx.transition.TransitionSet;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.lxj.xpopup.R;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.core.BasePopupView;
import com.lxj.xpopup.enums.PopupStatus;
import com.lxj.xpopup.interfaces.OnDragChangeListener;
import com.lxj.xpopup.interfaces.OnSrcViewUpdateListener;
import com.lxj.xpopup.interfaces.XPopupImageLoader;
import com.lxj.xpopup.photoview.OnMatrixChangedListener;
import com.lxj.xpopup.photoview.PhotoView;
import com.lxj.xpopup.util.XPermission;
import com.lxj.xpopup.util.XPopupUtils;
import com.lxj.xpopup.widget.BlankView;
import com.lxj.xpopup.widget.HackyViewPager;
import com.lxj.xpopup.widget.PhotoViewContainer;
import java.util.ArrayList;
import java.util.List;

public class ImageViewerPopupView
extends BasePopupView
implements OnDragChangeListener,
View.OnClickListener {
    protected FrameLayout container;
    protected PhotoViewContainer photoViewContainer;
    protected BlankView placeholderView;
    protected TextView tv_pager_indicator;
    protected TextView tv_save;
    protected HackyViewPager pager;
    protected ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    protected List<Object> urls = new ArrayList<Object>();
    protected XPopupImageLoader imageLoader;
    protected OnSrcViewUpdateListener srcViewUpdateListener;
    protected int position;
    protected Rect rect = null;
    protected ImageView srcView;
    protected PhotoView snapshotView;
    protected boolean isShowPlaceholder = false;
    protected int placeholderColor = -1;
    protected int placeholderStrokeColor = -1;
    protected int placeholderRadius = -1;
    protected boolean isShowSaveBtn = true;
    protected boolean isShowIndicator = true;
    protected boolean isInfinite = false;
    protected View customView;
    protected int bgColor = Color.rgb((int)32, (int)36, (int)46);

    public ImageViewerPopupView(@NonNull Context context) {
        super(context);
        this.container = (FrameLayout)this.findViewById(R.id.container);
        if (this.getImplLayoutId() > 0) {
            this.customView = LayoutInflater.from((Context)this.getContext()).inflate(this.getImplLayoutId(), (ViewGroup)this.container, false);
            this.customView.setVisibility(4);
            this.customView.setAlpha(0.0f);
            this.container.addView(this.customView);
        }
    }

    @Override
    protected int getPopupLayoutId() {
        return R.layout._xpopup_image_viewer_popup_view;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.tv_pager_indicator = (TextView)this.findViewById(R.id.tv_pager_indicator);
        this.tv_save = (TextView)this.findViewById(R.id.tv_save);
        this.placeholderView = (BlankView)this.findViewById(R.id.placeholderView);
        this.photoViewContainer = (PhotoViewContainer)this.findViewById(R.id.photoViewContainer);
        this.photoViewContainer.setOnDragChangeListener(this);
        this.pager = (HackyViewPager)this.findViewById(R.id.pager);
        this.pager.setAdapter(new PhotoViewAdapter());
        this.pager.setCurrentItem(this.position);
        this.pager.setVisibility(4);
        this.addOrUpdateSnapshot();
        if (this.isInfinite) {
            this.pager.setOffscreenPageLimit(this.urls.size() / 2);
        }
        this.pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int i) {
                ImageViewerPopupView.this.position = i;
                ImageViewerPopupView.this.showPagerIndicator();
                if (ImageViewerPopupView.this.srcViewUpdateListener != null) {
                    ImageViewerPopupView.this.srcViewUpdateListener.onSrcViewUpdate(ImageViewerPopupView.this, i);
                }
            }
        });
        if (!this.isShowIndicator) {
            this.tv_pager_indicator.setVisibility(8);
        }
        if (!this.isShowSaveBtn) {
            this.tv_save.setVisibility(8);
        } else {
            this.tv_save.setOnClickListener((View.OnClickListener)this);
        }
    }

    private void setupPlaceholder() {
        this.placeholderView.setVisibility(this.isShowPlaceholder ? 0 : 4);
        if (this.isShowPlaceholder) {
            if (this.placeholderColor != -1) {
                this.placeholderView.color = this.placeholderColor;
            }
            if (this.placeholderRadius != -1) {
                this.placeholderView.radius = this.placeholderRadius;
            }
            if (this.placeholderStrokeColor != -1) {
                this.placeholderView.strokeColor = this.placeholderStrokeColor;
            }
            XPopupUtils.setWidthHeight(this.placeholderView, this.rect.width(), this.rect.height());
            this.placeholderView.setTranslationX(this.rect.left);
            this.placeholderView.setTranslationY(this.rect.top);
            this.placeholderView.invalidate();
        }
    }

    private void showPagerIndicator() {
        if (this.urls.size() > 1) {
            int posi = this.isInfinite ? this.position % this.urls.size() : this.position;
            this.tv_pager_indicator.setText((CharSequence)(posi + 1 + "/" + this.urls.size()));
        }
        if (this.isShowSaveBtn) {
            this.tv_save.setVisibility(0);
        }
    }

    private void addOrUpdateSnapshot() {
        if (this.srcView == null) {
            return;
        }
        if (this.snapshotView == null) {
            this.snapshotView = new PhotoView(this.getContext());
            this.photoViewContainer.addView((View)this.snapshotView);
            this.snapshotView.setScaleType(this.srcView.getScaleType());
            this.snapshotView.setTranslationX(this.rect.left);
            this.snapshotView.setTranslationY(this.rect.top);
            XPopupUtils.setWidthHeight((View)this.snapshotView, this.rect.width(), this.rect.height());
        }
        this.setupPlaceholder();
        this.snapshotView.setImageDrawable(this.srcView.getDrawable());
    }

    @Override
    protected void doAfterShow() {
    }

    @Override
    public void doShowAnimation() {
        if (this.srcView == null) {
            this.photoViewContainer.setBackgroundColor(this.bgColor);
            this.pager.setVisibility(0);
            this.showPagerIndicator();
            this.photoViewContainer.isReleasing = false;
            ImageViewerPopupView.super.doAfterShow();
            return;
        }
        this.photoViewContainer.isReleasing = true;
        this.snapshotView.setVisibility(0);
        if (this.customView != null) {
            this.customView.setVisibility(0);
        }
        this.snapshotView.post(new Runnable(){

            @Override
            public void run() {
                TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)ImageViewerPopupView.this.snapshotView.getParent()), (Transition)new TransitionSet().setDuration((long)ImageViewerPopupView.this.getDuration()).addTransition((Transition)new ChangeBounds()).addTransition((Transition)new ChangeTransform()).addTransition((Transition)new ChangeImageTransform()).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).addListener((Transition.TransitionListener)new TransitionListenerAdapter(){

                    public void onTransitionEnd(@NonNull Transition transition) {
                        ImageViewerPopupView.this.pager.setVisibility(0);
                        ImageViewerPopupView.this.snapshotView.setVisibility(4);
                        ImageViewerPopupView.this.showPagerIndicator();
                        ImageViewerPopupView.this.photoViewContainer.isReleasing = false;
                        ImageViewerPopupView.super.doAfterShow();
                    }
                }));
                ImageViewerPopupView.this.snapshotView.setTranslationY(0.0f);
                ImageViewerPopupView.this.snapshotView.setTranslationX(0.0f);
                ImageViewerPopupView.this.snapshotView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                XPopupUtils.setWidthHeight((View)ImageViewerPopupView.this.snapshotView, ImageViewerPopupView.this.photoViewContainer.getWidth(), ImageViewerPopupView.this.photoViewContainer.getHeight());
                ImageViewerPopupView.this.animateShadowBg(ImageViewerPopupView.this.bgColor);
                if (ImageViewerPopupView.this.customView != null) {
                    ImageViewerPopupView.this.customView.animate().alpha(1.0f).setDuration((long)ImageViewerPopupView.this.getDuration()).start();
                }
            }
        });
    }

    private void animateShadowBg(final int endColor) {
        final int start = ((ColorDrawable)this.photoViewContainer.getBackground()).getColor();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ImageViewerPopupView.this.photoViewContainer.setBackgroundColor((Integer)ImageViewerPopupView.this.argbEvaluator.evaluate(animation.getAnimatedFraction(), (Object)start, (Object)endColor));
            }
        });
        animator.setDuration((long)this.getDuration()).setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.start();
    }

    private int getDuration() {
        return XPopup.getAnimationDuration() + 60;
    }

    @Override
    public void doDismissAnimation() {
        if (this.srcView == null) {
            this.photoViewContainer.setBackgroundColor(0);
            this.doAfterDismiss();
            this.pager.setVisibility(4);
            this.placeholderView.setVisibility(4);
            return;
        }
        this.tv_pager_indicator.setVisibility(4);
        this.tv_save.setVisibility(4);
        this.pager.setVisibility(4);
        this.snapshotView.setVisibility(0);
        this.photoViewContainer.isReleasing = true;
        TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)this.snapshotView.getParent()), (Transition)new TransitionSet().setDuration((long)this.getDuration()).addTransition((Transition)new ChangeBounds()).addTransition((Transition)new ChangeTransform()).addTransition((Transition)new ChangeImageTransform()).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).addListener((Transition.TransitionListener)new TransitionListenerAdapter(){

            public void onTransitionEnd(@NonNull Transition transition) {
                ImageViewerPopupView.this.doAfterDismiss();
                ImageViewerPopupView.this.pager.setVisibility(4);
                ImageViewerPopupView.this.snapshotView.setVisibility(0);
                ImageViewerPopupView.this.pager.setScaleX(1.0f);
                ImageViewerPopupView.this.pager.setScaleY(1.0f);
                ImageViewerPopupView.this.snapshotView.setScaleX(1.0f);
                ImageViewerPopupView.this.snapshotView.setScaleY(1.0f);
                ImageViewerPopupView.this.placeholderView.setVisibility(4);
            }
        }));
        this.snapshotView.setTranslationY(this.rect.top);
        this.snapshotView.setTranslationX(this.rect.left);
        this.snapshotView.setScaleX(1.0f);
        this.snapshotView.setScaleY(1.0f);
        this.snapshotView.setScaleType(this.srcView.getScaleType());
        XPopupUtils.setWidthHeight((View)this.snapshotView, this.rect.width(), this.rect.height());
        this.animateShadowBg(0);
        if (this.customView != null) {
            this.customView.animate().alpha(0.0f).setDuration((long)this.getDuration()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    if (ImageViewerPopupView.this.customView != null) {
                        ImageViewerPopupView.this.customView.setVisibility(4);
                    }
                }
            }).start();
        }
    }

    @Override
    public int getAnimationDuration() {
        return 0;
    }

    @Override
    public void dismiss() {
        if (this.popupStatus != PopupStatus.Show) {
            return;
        }
        this.popupStatus = PopupStatus.Dismissing;
        this.doDismissAnimation();
    }

    public ImageViewerPopupView setImageUrls(List<Object> urls) {
        this.urls = urls;
        return this;
    }

    public ImageViewerPopupView setSrcViewUpdateListener(OnSrcViewUpdateListener srcViewUpdateListener) {
        this.srcViewUpdateListener = srcViewUpdateListener;
        return this;
    }

    public ImageViewerPopupView setXPopupImageLoader(XPopupImageLoader imageLoader) {
        this.imageLoader = imageLoader;
        return this;
    }

    public ImageViewerPopupView isShowPlaceholder(boolean isShow) {
        this.isShowPlaceholder = isShow;
        return this;
    }

    public ImageViewerPopupView isShowIndicator(boolean isShow) {
        this.isShowIndicator = isShow;
        return this;
    }

    public ImageViewerPopupView isShowSaveButton(boolean isShowSaveBtn) {
        this.isShowSaveBtn = isShowSaveBtn;
        return this;
    }

    public ImageViewerPopupView isInfinite(boolean isInfinite) {
        this.isInfinite = isInfinite;
        return this;
    }

    public ImageViewerPopupView setPlaceholderColor(int color2) {
        this.placeholderColor = color2;
        return this;
    }

    public ImageViewerPopupView setPlaceholderRadius(int radius) {
        this.placeholderRadius = radius;
        return this;
    }

    public ImageViewerPopupView setPlaceholderStrokeColor(int strokeColor) {
        this.placeholderStrokeColor = strokeColor;
        return this;
    }

    public ImageViewerPopupView setSingleSrcView(ImageView srcView, Object url) {
        if (this.urls == null) {
            this.urls = new ArrayList<Object>();
        }
        this.urls.clear();
        this.urls.add(url);
        this.setSrcView(srcView, 0);
        return this;
    }

    public ImageViewerPopupView setSrcView(ImageView srcView, int position) {
        this.srcView = srcView;
        this.position = position;
        if (srcView != null) {
            int[] locations = new int[2];
            this.srcView.getLocationInWindow(locations);
            this.rect = new Rect(locations[0], locations[1], locations[0] + srcView.getWidth(), locations[1] + srcView.getHeight());
        }
        return this;
    }

    public void updateSrcView(ImageView srcView) {
        this.setSrcView(srcView, this.position);
        this.addOrUpdateSnapshot();
    }

    @Override
    public void onRelease() {
        this.dismiss();
    }

    @Override
    public void onDragChange(int dy, float scale, float fraction) {
        this.tv_pager_indicator.setAlpha(1.0f - fraction);
        if (this.customView != null) {
            this.customView.setAlpha(1.0f - fraction);
        }
        if (this.isShowSaveBtn) {
            this.tv_save.setAlpha(1.0f - fraction);
        }
        this.photoViewContainer.setBackgroundColor((Integer)this.argbEvaluator.evaluate(fraction * 0.8f, (Object)this.bgColor, (Object)0));
    }

    @Override
    protected void onDismiss() {
        super.onDismiss();
        this.srcView = null;
    }

    public void onClick(View v) {
        if (v == this.tv_save) {
            this.save();
        }
    }

    protected void save() {
        XPermission.create(this.getContext(), "android.permission-group.STORAGE").callback(new XPermission.SimpleCallback(){

            @Override
            public void onGranted() {
                XPopupUtils.saveBmpToAlbum(ImageViewerPopupView.this.getContext(), ImageViewerPopupView.this.imageLoader, ImageViewerPopupView.this.urls.get(ImageViewerPopupView.this.isInfinite ? ImageViewerPopupView.this.position % ImageViewerPopupView.this.urls.size() : ImageViewerPopupView.this.position));
            }

            @Override
            public void onDenied() {
                Toast.makeText((Context)ImageViewerPopupView.this.getContext(), (CharSequence)"\u6ca1\u6709\u4fdd\u5b58\u6743\u9650\uff0c\u4fdd\u5b58\u529f\u80fd\u65e0\u6cd5\u4f7f\u7528\uff01", (int)0).show();
            }
        }).request();
    }

    public class PhotoViewAdapter
    extends PagerAdapter {
        public int getCount() {
            return ImageViewerPopupView.this.isInfinite ? 0x3FFFFFFF : ImageViewerPopupView.this.urls.size();
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object o) {
            return o == view;
        }

        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            final PhotoView photoView = new PhotoView(container.getContext());
            if (ImageViewerPopupView.this.imageLoader != null) {
                ImageViewerPopupView.this.imageLoader.loadImage(position, ImageViewerPopupView.this.urls.get(ImageViewerPopupView.this.isInfinite ? position % ImageViewerPopupView.this.urls.size() : position), (ImageView)photoView);
            }
            photoView.setOnMatrixChangeListener(new OnMatrixChangedListener(){

                @Override
                public void onMatrixChanged(RectF rect) {
                    Matrix matrix = new Matrix();
                    photoView.getSuppMatrix(matrix);
                    ImageViewerPopupView.this.snapshotView.setSuppMatrix(matrix);
                }
            });
            container.addView((View)photoView);
            photoView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ImageViewerPopupView.this.dismiss();
                }
            });
            return photoView;
        }

        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View)object);
        }
    }
}

