/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.impl;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.lxj.easyadapter.EasyAdapter;
import com.lxj.easyadapter.MultiItemTypeAdapter;
import com.lxj.easyadapter.ViewHolder;
import com.lxj.xpopup.R;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.core.CenterPopupView;
import com.lxj.xpopup.interfaces.OnSelectListener;
import com.lxj.xpopup.widget.CheckView;
import java.util.Arrays;

public class CenterListPopupView
extends CenterPopupView {
    RecyclerView recyclerView;
    TextView tv_title;
    CharSequence title;
    String[] data;
    int[] iconIds;
    private OnSelectListener selectListener;
    int checkedPosition = -1;

    public CenterListPopupView(@NonNull Context context) {
        super(context);
    }

    public CenterListPopupView bindLayout(int layoutId) {
        this.bindLayoutId = layoutId;
        return this;
    }

    public CenterListPopupView bindItemLayout(int itemLayoutId) {
        this.bindItemLayoutId = itemLayoutId;
        return this;
    }

    @Override
    protected int getImplLayoutId() {
        return this.bindLayoutId == 0 ? R.layout._xpopup_center_impl_list : this.bindLayoutId;
    }

    @Override
    protected void initPopupContent() {
        super.initPopupContent();
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        if (this.tv_title != null) {
            if (TextUtils.isEmpty((CharSequence)this.title)) {
                this.tv_title.setVisibility(8);
                this.findViewById(R.id.xpopup_divider).setVisibility(8);
            } else {
                this.tv_title.setText(this.title);
            }
        }
        EasyAdapter<String> adapter = new EasyAdapter<String>(Arrays.asList(this.data), this.bindItemLayoutId == 0 ? R.layout._xpopup_adapter_text : this.bindItemLayoutId){

            protected void bind(@NonNull ViewHolder holder, @NonNull String s, int position) {
                holder.setText(R.id.tv_text, (CharSequence)s);
                if (CenterListPopupView.this.iconIds != null && CenterListPopupView.this.iconIds.length > position) {
                    holder.getView(R.id.iv_image).setVisibility(0);
                    holder.getView(R.id.iv_image).setBackgroundResource(CenterListPopupView.this.iconIds[position]);
                } else {
                    holder.getView(R.id.iv_image).setVisibility(8);
                }
                if (CenterListPopupView.this.checkedPosition != -1) {
                    if (holder.getView(R.id.check_view) != null) {
                        holder.getView(R.id.check_view).setVisibility(position == CenterListPopupView.this.checkedPosition ? 0 : 8);
                        ((CheckView)holder.getView(R.id.check_view)).setColor(XPopup.getPrimaryColor());
                    }
                    ((TextView)holder.getView(R.id.tv_text)).setTextColor(position == CenterListPopupView.this.checkedPosition ? XPopup.getPrimaryColor() : CenterListPopupView.this.getResources().getColor(R.color._xpopup_title_color));
                }
                if (position == CenterListPopupView.this.data.length - 1) {
                    holder.getView(R.id.xpopup_divider).setVisibility(4);
                }
            }
        };
        adapter.setOnItemClickListener((MultiItemTypeAdapter.OnItemClickListener)new MultiItemTypeAdapter.SimpleOnItemClickListener((EasyAdapter)adapter){
            final /* synthetic */ EasyAdapter val$adapter;
            {
                this.val$adapter = easyAdapter;
            }

            public void onItemClick(View view, RecyclerView.ViewHolder holder, int position) {
                if (CenterListPopupView.this.selectListener != null && position >= 0 && position < this.val$adapter.getData().size()) {
                    CenterListPopupView.this.selectListener.onSelect(position, (String)this.val$adapter.getData().get(position));
                }
                if (CenterListPopupView.this.checkedPosition != -1) {
                    CenterListPopupView.this.checkedPosition = position;
                    this.val$adapter.notifyDataSetChanged();
                }
                if (CenterListPopupView.this.popupInfo.autoDismiss.booleanValue()) {
                    CenterListPopupView.this.dismiss();
                }
            }
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)adapter);
    }

    public CenterListPopupView setStringData(CharSequence title, String[] data, int[] iconIds) {
        this.title = title;
        this.data = data;
        this.iconIds = iconIds;
        return this;
    }

    public CenterListPopupView setOnSelectListener(OnSelectListener selectListener) {
        this.selectListener = selectListener;
        return this;
    }

    public CenterListPopupView setCheckedPosition(int position) {
        this.checkedPosition = position;
        return this;
    }

    @Override
    protected int getMaxWidth() {
        return this.popupInfo.maxWidth == 0 ? (int)((float)super.getMaxWidth() * 0.8f) : this.popupInfo.maxWidth;
    }
}

