/*
 * Decompiled with CFR 0.152.
 */
package com.lxj.xpopup.animator;

import android.animation.TimeInterpolator;
import android.view.View;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.animator.PopupAnimator;
import com.lxj.xpopup.enums.PopupAnimation;
import com.lxj.xpopup.util.XPopupUtils;

public class TranslateAlphaAnimator
extends PopupAnimator {
    private float startTranslationX;
    private float startTranslationY;
    private float defTranslationX;
    private float defTranslationY;

    public TranslateAlphaAnimator(View target, PopupAnimation popupAnimation) {
        super(target, popupAnimation);
    }

    @Override
    public void initAnimator() {
        this.defTranslationX = this.targetView.getTranslationX();
        this.defTranslationY = this.targetView.getTranslationY();
        this.targetView.setAlpha(0.0f);
        this.applyTranslation();
        this.startTranslationX = this.targetView.getTranslationX();
        this.startTranslationY = this.targetView.getTranslationY();
    }

    private void applyTranslation() {
        int halfWidthOffset = XPopupUtils.getWindowWidth(this.targetView.getContext()) / 2 - this.targetView.getMeasuredWidth() / 2;
        int halfHeightOffset = XPopupUtils.getWindowHeight(this.targetView.getContext()) / 2 - this.targetView.getMeasuredHeight() / 2;
        switch (this.popupAnimation) {
            case TranslateAlphaFromLeft: {
                this.targetView.setTranslationX((float)(-this.targetView.getMeasuredWidth()));
                break;
            }
            case TranslateAlphaFromTop: {
                this.targetView.setTranslationY((float)(-this.targetView.getMeasuredHeight()));
                break;
            }
            case TranslateAlphaFromRight: {
                this.targetView.setTranslationX((float)this.targetView.getMeasuredWidth());
                break;
            }
            case TranslateAlphaFromBottom: {
                this.targetView.setTranslationY((float)this.targetView.getMeasuredHeight());
            }
        }
    }

    @Override
    public void animateShow() {
        this.targetView.animate().translationX(this.defTranslationX).translationY(this.defTranslationY).alpha(1.0f).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).setDuration((long)XPopup.getAnimationDuration()).start();
    }

    @Override
    public void animateDismiss() {
        this.targetView.animate().translationX(this.startTranslationX).translationY(this.startTranslationY).alpha(0.0f).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).setDuration((long)XPopup.getAnimationDuration()).start();
    }
}

