/*
 * Decompiled with CFR 0.152.
 */
package com.github.library.bubbleview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.TextView;
import com.github.bubbleview.R;
import com.github.library.bubbleview.BubbleDrawable;

public class BubbleTextView
extends TextView {
    private BubbleDrawable bubbleDrawable;
    private float mArrowWidth;
    private float mAngle;
    private float mArrowHeight;
    private float mArrowPosition;
    private int bubbleColor;
    private BubbleDrawable.ArrowLocation mArrowLocation;
    private boolean mArrowCenter;

    public BubbleTextView(Context context) {
        super(context);
        this.initView(null);
    }

    public BubbleTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(attrs);
    }

    public BubbleTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(attrs);
    }

    private void initView(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.BubbleView);
            this.mArrowWidth = array.getDimension(R.styleable.BubbleView_arrowWidth, BubbleDrawable.Builder.DEFAULT_ARROW_WITH);
            this.mArrowHeight = array.getDimension(R.styleable.BubbleView_arrowHeight, BubbleDrawable.Builder.DEFAULT_ARROW_HEIGHT);
            this.mAngle = array.getDimension(R.styleable.BubbleView_angle, BubbleDrawable.Builder.DEFAULT_ANGLE);
            this.mArrowPosition = array.getDimension(R.styleable.BubbleView_arrowPosition, BubbleDrawable.Builder.DEFAULT_ARROW_POSITION);
            this.bubbleColor = array.getColor(R.styleable.BubbleView_bubbleColor, BubbleDrawable.Builder.DEFAULT_BUBBLE_COLOR);
            int location = array.getInt(R.styleable.BubbleView_arrowLocation, 0);
            this.mArrowLocation = BubbleDrawable.ArrowLocation.mapIntToValue(location);
            this.mArrowCenter = array.getBoolean(R.styleable.BubbleView_arrowCenter, false);
            array.recycle();
        }
        this.setUpPadding();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.setUp(w, h);
        }
    }

    public void layout(int l, int t, int r, int b) {
        super.layout(l, t, r, b);
        this.setUp();
    }

    protected void onDraw(Canvas canvas) {
        if (this.bubbleDrawable != null) {
            this.bubbleDrawable.draw(canvas);
        }
        super.onDraw(canvas);
    }

    private void setUp(int width, int height) {
        this.setUp(0, width, 0, height);
    }

    private void setUp() {
        this.setUp(this.getWidth(), this.getHeight());
    }

    private void setUp(int left, int right, int top, int bottom) {
        RectF rectF = new RectF((float)left, (float)top, (float)right, (float)bottom);
        this.bubbleDrawable = new BubbleDrawable.Builder().rect(rectF).arrowLocation(this.mArrowLocation).bubbleType(BubbleDrawable.BubbleType.COLOR).angle(this.mAngle).arrowHeight(this.mArrowHeight).arrowWidth(this.mArrowWidth).bubbleColor(this.bubbleColor).arrowPosition(this.mArrowPosition).arrowCenter(this.mArrowCenter).build();
    }

    private void setUpPadding() {
        int left = this.getPaddingLeft();
        int right = this.getPaddingRight();
        int top = this.getPaddingTop();
        int bottom = this.getPaddingBottom();
        switch (this.mArrowLocation) {
            case LEFT: {
                left = (int)((float)left + this.mArrowWidth);
                break;
            }
            case RIGHT: {
                right = (int)((float)right + this.mArrowWidth);
                break;
            }
            case TOP: {
                top = (int)((float)top + this.mArrowHeight);
                break;
            }
            case BOTTOM: {
                bottom = (int)((float)bottom + this.mArrowHeight);
            }
        }
        this.setPadding(left, top, right, bottom);
    }
}

