/*
 * Decompiled with CFR 0.152.
 */
package com.testautomationguru.ocular.sample;

import com.testautomationguru.ocular.comparator.ImageUtil;
import com.testautomationguru.ocular.comparator.OcularComparator;
import com.testautomationguru.ocular.comparator.OcularResult;
import com.testautomationguru.ocular.exception.OcularException;
import com.testautomationguru.ocular.sample.SampleBuilder;
import com.testautomationguru.ocular.snapshot.SnapshotAttributes;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SampleBuilderImpl
implements SampleBuilder {
    private WebDriver driver;
    private BufferedImage sample;
    private List<WebElement> exclusionList = new LinkedList<WebElement>();
    private SnapshotAttributes snapshotAttributes;

    public SampleBuilderImpl(SnapshotAttributes snapshotAttributes) {
        this.snapshotAttributes = snapshotAttributes;
    }

    @Override
    public SampleBuilder using(WebDriver driver) {
        this.driver = driver;
        return this;
    }

    @Override
    public SampleBuilder using(Path path) {
        try {
            this.sample = ImageIO.read(path.toFile());
        }
        catch (IOException e) {
            throw new OcularException(e.getMessage() + " " + path.toString());
        }
        return this;
    }

    @Override
    public SampleBuilder element(WebElement element) {
        this.sample = ImageUtil.getElementSnapshot(this.driver, element);
        return this;
    }

    @Override
    public SampleBuilder excluding(WebElement element) {
        this.exclusionList.add(element);
        return this;
    }

    @Override
    public SampleBuilder excluding(List<WebElement> list) {
        this.exclusionList.addAll(list);
        return this;
    }

    @Override
    public SampleBuilder similarity(int cutoff) {
        this.snapshotAttributes.setSimilarity(cutoff);
        return this;
    }

    @Override
    public OcularResult compare() {
        if (null == this.sample) {
            this.sample = ImageUtil.getPageSnapshot(this.driver);
        }
        return OcularComparator.compare(this.snapshotAttributes, this.sample, this.exclusionList);
    }
}

