/*
 * Decompiled with CFR 0.152.
 */
package com.testautomationguru.ocular;

import com.testautomationguru.ocular.OcularConfiguration;
import com.testautomationguru.ocular.snapshot.SnapshotBuilder;
import com.testautomationguru.ocular.snapshot.SnapshotBuilderImpl;
import java.nio.file.Path;

public class Ocular {
    public static SnapshotBuilder snapshot() {
        return new SnapshotBuilderImpl();
    }

    public static OcularConfiguration config() {
        return OcularConfigImpl.get();
    }

    private static class OcularConfigImpl
    implements OcularConfiguration {
        private static final OcularConfiguration config = new OcularConfigImpl();
        private Path snapshotpath;
        private Path resultpath;
        private int similarity = 100;
        private boolean savesnapshot = true;

        private OcularConfigImpl() {
        }

        public static OcularConfiguration get() {
            return config;
        }

        @Override
        public OcularConfiguration snapshotPath(Path path) {
            this.snapshotpath = path;
            return this;
        }

        @Override
        public OcularConfiguration resultPath(Path path) {
            this.resultpath = path;
            return this;
        }

        @Override
        public OcularConfiguration globalSimilarity(int cutoff) {
            this.similarity = cutoff;
            return this;
        }

        @Override
        public Path getSnapshotPath() {
            return this.snapshotpath;
        }

        @Override
        public Path getResultPath() {
            return this.resultpath;
        }

        @Override
        public int getGlobalSimilarity() {
            return this.similarity;
        }

        @Override
        public OcularConfiguration saveSnapshot(boolean save) {
            this.savesnapshot = save;
            return this;
        }

        @Override
        public boolean canSaveSnapshot() {
            return this.savesnapshot;
        }

        @Override
        public void reset() {
            this.snapshotpath = null;
            this.resultpath = null;
            this.similarity = 100;
            this.savesnapshot = true;
        }
    }
}

