/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.handlers;

import android.text.SpannableStringBuilder;
import net.nightwhistler.htmlspanner.FontFamily;
import net.nightwhistler.htmlspanner.SpanStack;
import net.nightwhistler.htmlspanner.TagNodeHandler;
import net.nightwhistler.htmlspanner.TextUtil;
import net.nightwhistler.htmlspanner.spans.FontFamilySpan;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;

public class PreHandler
extends TagNodeHandler {
    private void getPlainText(StringBuffer buffer, Object node) {
        if (node instanceof ContentNode) {
            ContentNode contentNode = (ContentNode)node;
            String text = TextUtil.replaceHtmlEntities(contentNode.getContent().toString(), true);
            buffer.append(text);
        } else if (node instanceof TagNode) {
            TagNode tagNode = (TagNode)node;
            for (Object child : tagNode.getChildren()) {
                this.getPlainText(buffer, child);
            }
        }
    }

    @Override
    public void handleTagNode(TagNode node, SpannableStringBuilder builder, int start, int end, SpanStack spanStack) {
        StringBuffer buffer = new StringBuffer();
        this.getPlainText(buffer, node);
        builder.append((CharSequence)buffer.toString());
        FontFamily monoSpace = this.getSpanner().getFontResolver().getMonoSpaceFont();
        spanStack.pushSpan((Object)new FontFamilySpan(monoSpace), start, builder.length());
        this.appendNewLine(builder);
        this.appendNewLine(builder);
    }

    @Override
    public boolean rendersContent() {
        return true;
    }
}

