/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.handlers.attributes;

import android.text.SpannableStringBuilder;
import android.util.Log;
import net.nightwhistler.htmlspanner.SpanStack;
import net.nightwhistler.htmlspanner.css.CSSCompiler;
import net.nightwhistler.htmlspanner.handlers.StyledTextHandler;
import net.nightwhistler.htmlspanner.handlers.attributes.WrappingStyleHandler;
import net.nightwhistler.htmlspanner.style.Style;
import org.htmlcleaner.TagNode;

public class StyleAttributeHandler
extends WrappingStyleHandler {
    public StyleAttributeHandler(StyledTextHandler wrapHandler) {
        super(wrapHandler);
    }

    @Override
    public void handleTagNode(TagNode node, SpannableStringBuilder builder, int start, int end, Style useStyle, SpanStack spanStack) {
        String styleAttr = node.getAttributeByName("style");
        if (this.getSpanner().isAllowStyling() && styleAttr != null) {
            super.handleTagNode(node, builder, start, end, this.parseStyleFromAttribute(useStyle, styleAttr), spanStack);
        } else {
            super.handleTagNode(node, builder, start, end, useStyle, spanStack);
        }
    }

    private Style parseStyleFromAttribute(Style baseStyle, String attribute) {
        String[] pairs;
        Style style = baseStyle;
        for (String pair : pairs = attribute.split(";")) {
            String value;
            String[] keyVal = pair.split(":");
            if (keyVal.length != 2) {
                Log.e((String)"StyleAttributeHandler", (String)("Could not parse attribute: " + attribute));
                return baseStyle;
            }
            String key = keyVal[0].toLowerCase().trim();
            CSSCompiler.StyleUpdater updater = CSSCompiler.getStyleUpdater(key, value = keyVal[1].toLowerCase().trim());
            if (updater == null) continue;
            style = updater.updateStyle(style, this.getSpanner());
        }
        return style;
    }
}

