/*
 * Copyright (C) 2011 Alex Kuiper <http://www.nightwhistler.net>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.nightwhistler.htmlspanner.handlers;

import net.nightwhistler.htmlspanner.TagNodeHandler;
import net.nightwhistler.htmlspanner.spans.FontFamilySpan;

import org.htmlcleaner.TagNode;

import android.text.Spannable;
import android.text.SpannableStringBuilder;

/**
 * Applies italic formatting.
 * 
 * @author Alex Kuiper
 * 
 */
public class ItalicHandler extends TagNodeHandler {

	public void handleTagNode(TagNode node, SpannableStringBuilder builder,
			int start, int end) {

		FontFamilySpan originalSpan = getFontFamilySpan(builder, start, end);
		
		FontFamilySpan italicSpan;
		
		if ( originalSpan != null ) {
			italicSpan = new FontFamilySpan(originalSpan.getFontFamily());
			italicSpan.setBold(originalSpan.isBold());
		} else {
			italicSpan = new FontFamilySpan(getSpanner().getDefaultFont());				
		}
		
		italicSpan.setItalic(true);

		builder.setSpan(italicSpan, start, end,
				Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
	}
}
