/*
 * Decompiled with CFR 0.152.
 */
package org.jblas;

import org.jblas.ComplexDouble;
import org.jblas.ComplexFloat;
import org.jblas.NativeBlasLibraryLoader;

public class NativeBlas {
    private static int[] intDummy;
    private static double[] doubleDummy;
    private static float[] floatDummy;

    public static native void ccopy(int var0, float[] var1, int var2, int var3, float[] var4, int var5, int var6);

    public static native void dcopy(int var0, double[] var1, int var2, int var3, double[] var4, int var5, int var6);

    public static native void scopy(int var0, float[] var1, int var2, int var3, float[] var4, int var5, int var6);

    public static native void zcopy(int var0, double[] var1, int var2, int var3, double[] var4, int var5, int var6);

    public static native void cswap(int var0, float[] var1, int var2, int var3, float[] var4, int var5, int var6);

    public static native void dswap(int var0, double[] var1, int var2, int var3, double[] var4, int var5, int var6);

    public static native void sswap(int var0, float[] var1, int var2, int var3, float[] var4, int var5, int var6);

    public static native void zswap(int var0, double[] var1, int var2, int var3, double[] var4, int var5, int var6);

    public static native void caxpy(int var0, ComplexFloat var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7);

    public static native void daxpy(int var0, double var1, double[] var3, int var4, int var5, double[] var6, int var7, int var8);

    public static native void saxpy(int var0, float var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7);

    public static native void zaxpy(int var0, ComplexDouble var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7);

    public static native void cscal(int var0, ComplexFloat var1, float[] var2, int var3, int var4);

    public static native void dscal(int var0, double var1, double[] var3, int var4, int var5);

    public static native void sscal(int var0, float var1, float[] var2, int var3, int var4);

    public static native void zscal(int var0, ComplexDouble var1, double[] var2, int var3, int var4);

    public static native void csscal(int var0, float var1, float[] var2, int var3, int var4);

    public static native void zdscal(int var0, double var1, double[] var3, int var4, int var5);

    public static native ComplexFloat cdotc(int var0, float[] var1, int var2, int var3, float[] var4, int var5, int var6);

    public static native ComplexFloat cdotu(int var0, float[] var1, int var2, int var3, float[] var4, int var5, int var6);

    public static native double ddot(int var0, double[] var1, int var2, int var3, double[] var4, int var5, int var6);

    public static native float sdot(int var0, float[] var1, int var2, int var3, float[] var4, int var5, int var6);

    public static native ComplexDouble zdotc(int var0, double[] var1, int var2, int var3, double[] var4, int var5, int var6);

    public static native ComplexDouble zdotu(int var0, double[] var1, int var2, int var3, double[] var4, int var5, int var6);

    public static native double dnrm2(int var0, double[] var1, int var2, int var3);

    public static native double dznrm2(int var0, double[] var1, int var2, int var3);

    public static native float scnrm2(int var0, float[] var1, int var2, int var3);

    public static native float snrm2(int var0, float[] var1, int var2, int var3);

    public static native double dasum(int var0, double[] var1, int var2, int var3);

    public static native double dzasum(int var0, double[] var1, int var2, int var3);

    public static native float sasum(int var0, float[] var1, int var2, int var3);

    public static native float scasum(int var0, float[] var1, int var2, int var3);

    public static native int icamax(int var0, float[] var1, int var2, int var3);

    public static native int idamax(int var0, double[] var1, int var2, int var3);

    public static native int isamax(int var0, float[] var1, int var2, int var3);

    public static native int izamax(int var0, double[] var1, int var2, int var3);

    public static native void cgemv(char var0, int var1, int var2, ComplexFloat var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, ComplexFloat var10, float[] var11, int var12, int var13);

    public static native void dgemv(char var0, int var1, int var2, double var3, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double var11, double[] var13, int var14, int var15);

    public static native void sgemv(char var0, int var1, int var2, float var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float var10, float[] var11, int var12, int var13);

    public static native void zgemv(char var0, int var1, int var2, ComplexDouble var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, ComplexDouble var10, double[] var11, int var12, int var13);

    public static native void cgerc(int var0, int var1, ComplexFloat var2, float[] var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11);

    public static native void cgeru(int var0, int var1, ComplexFloat var2, float[] var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11);

    public static native void dger(int var0, int var1, double var2, double[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12);

    public static native void sger(int var0, int var1, float var2, float[] var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11);

    public static native void zgerc(int var0, int var1, ComplexDouble var2, double[] var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11);

    public static native void zgeru(int var0, int var1, ComplexDouble var2, double[] var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11);

    public static native void cgemm(char var0, char var1, int var2, int var3, int var4, ComplexFloat var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, ComplexFloat var12, float[] var13, int var14, int var15);

    public static native void dgemm(char var0, char var1, int var2, int var3, int var4, double var5, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double var13, double[] var15, int var16, int var17);

    public static native void sgemm(char var0, char var1, int var2, int var3, int var4, float var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float var12, float[] var13, int var14, int var15);

    public static native void zgemm(char var0, char var1, int var2, int var3, int var4, ComplexDouble var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, ComplexDouble var12, double[] var13, int var14, int var15);

    public static native int dgesv(int var0, int var1, double[] var2, int var3, int var4, int[] var5, int var6, double[] var7, int var8, int var9);

    public static native int sgesv(int var0, int var1, float[] var2, int var3, int var4, int[] var5, int var6, float[] var7, int var8, int var9);

    public static native int dsysv(char var0, int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13);

    public static int dsysv(char uplo, int n, int nrhs, double[] a, int aIdx, int lda, int[] ipiv, int ipivIdx, double[] b, int bIdx, int ldb) {
        double[] work = new double[1];
        int info = NativeBlas.dsysv(uplo, n, nrhs, doubleDummy, 0, lda, intDummy, 0, doubleDummy, 0, ldb, work, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork];
        info = NativeBlas.dsysv(uplo, n, nrhs, a, aIdx, lda, ipiv, ipivIdx, b, bIdx, ldb, work, 0, lwork);
        return info;
    }

    public static native int ssysv(char var0, int var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13);

    public static int ssysv(char uplo, int n, int nrhs, float[] a, int aIdx, int lda, int[] ipiv, int ipivIdx, float[] b, int bIdx, int ldb) {
        float[] work = new float[1];
        int info = NativeBlas.ssysv(uplo, n, nrhs, floatDummy, 0, lda, intDummy, 0, floatDummy, 0, ldb, work, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork];
        info = NativeBlas.ssysv(uplo, n, nrhs, a, aIdx, lda, ipiv, ipivIdx, b, bIdx, ldb, work, 0, lwork);
        return info;
    }

    public static native int dsyev(char var0, char var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10);

    public static int dsyev(char jobz, char uplo, int n, double[] a, int aIdx, int lda, double[] w, int wIdx) {
        double[] work = new double[1];
        int info = NativeBlas.dsyev(jobz, uplo, n, doubleDummy, 0, lda, doubleDummy, 0, work, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork];
        info = NativeBlas.dsyev(jobz, uplo, n, a, aIdx, lda, w, wIdx, work, 0, lwork);
        return info;
    }

    public static native int ssyev(char var0, char var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10);

    public static int ssyev(char jobz, char uplo, int n, float[] a, int aIdx, int lda, float[] w, int wIdx) {
        float[] work = new float[1];
        int info = NativeBlas.ssyev(jobz, uplo, n, floatDummy, 0, lda, floatDummy, 0, work, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork];
        info = NativeBlas.ssyev(jobz, uplo, n, a, aIdx, lda, w, wIdx, work, 0, lwork);
        return info;
    }

    public static native int dsyevd(char var0, char var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, int[] var11, int var12, int var13);

    public static int dsyevd(char jobz, char uplo, int n, double[] a, int aIdx, int lda, double[] w, int wIdx) {
        double[] work = new double[1];
        int[] iwork = new int[1];
        int info = NativeBlas.dsyevd(jobz, uplo, n, doubleDummy, 0, lda, doubleDummy, 0, work, 0, -1, iwork, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork];
        int liwork = iwork[0];
        iwork = new int[liwork];
        info = NativeBlas.dsyevd(jobz, uplo, n, a, aIdx, lda, w, wIdx, work, 0, lwork, iwork, 0, liwork);
        return info;
    }

    public static native int dsyevr(char var0, char var1, char var2, int var3, double[] var4, int var5, int var6, double var7, double var9, int var11, int var12, double var13, int[] var15, int var16, double[] var17, int var18, double[] var19, int var20, int var21, int[] var22, int var23, double[] var24, int var25, int var26, int[] var27, int var28, int var29);

    public static int dsyevr(char jobz, char range, char uplo, int n, double[] a, int aIdx, int lda, double vl, double vu, int il, int iu, double abstol, int[] m, int mIdx, double[] w, int wIdx, double[] z, int zIdx, int ldz, int[] isuppz, int isuppzIdx) {
        double[] work = new double[1];
        int[] iwork = new int[1];
        int info = NativeBlas.dsyevr(jobz, range, uplo, n, doubleDummy, 0, lda, vl, vu, il, iu, abstol, intDummy, 0, doubleDummy, 0, doubleDummy, 0, ldz, intDummy, 0, work, 0, -1, iwork, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork];
        int liwork = iwork[0];
        iwork = new int[liwork];
        info = NativeBlas.dsyevr(jobz, range, uplo, n, a, aIdx, lda, vl, vu, il, iu, abstol, m, mIdx, w, wIdx, z, zIdx, ldz, isuppz, isuppzIdx, work, 0, lwork, iwork, 0, liwork);
        return info;
    }

    public static native int dsyevx(char var0, char var1, char var2, int var3, double[] var4, int var5, int var6, double var7, double var9, int var11, int var12, double var13, int[] var15, int var16, double[] var17, int var18, double[] var19, int var20, int var21, double[] var22, int var23, int var24, int[] var25, int var26, int[] var27, int var28);

    public static int dsyevx(char jobz, char range, char uplo, int n, double[] a, int aIdx, int lda, double vl, double vu, int il, int iu, double abstol, int[] m, int mIdx, double[] w, int wIdx, double[] z, int zIdx, int ldz, int[] iwork, int iworkIdx, int[] ifail, int ifailIdx) {
        double[] work = new double[1];
        int info = NativeBlas.dsyevx(jobz, range, uplo, n, doubleDummy, 0, lda, vl, vu, il, iu, abstol, intDummy, 0, doubleDummy, 0, doubleDummy, 0, ldz, work, 0, -1, intDummy, 0, intDummy, 0);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork];
        info = NativeBlas.dsyevx(jobz, range, uplo, n, a, aIdx, lda, vl, vu, il, iu, abstol, m, mIdx, w, wIdx, z, zIdx, ldz, work, 0, lwork, iwork, iworkIdx, ifail, ifailIdx);
        return info;
    }

    public static native int ssyevd(char var0, char var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, int[] var11, int var12, int var13);

    public static int ssyevd(char jobz, char uplo, int n, float[] a, int aIdx, int lda, float[] w, int wIdx) {
        float[] work = new float[1];
        int[] iwork = new int[1];
        int info = NativeBlas.ssyevd(jobz, uplo, n, floatDummy, 0, lda, floatDummy, 0, work, 0, -1, iwork, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork];
        int liwork = iwork[0];
        iwork = new int[liwork];
        info = NativeBlas.ssyevd(jobz, uplo, n, a, aIdx, lda, w, wIdx, work, 0, lwork, iwork, 0, liwork);
        return info;
    }

    public static native int ssyevr(char var0, char var1, char var2, int var3, float[] var4, int var5, int var6, float var7, float var8, int var9, int var10, float var11, int[] var12, int var13, float[] var14, int var15, float[] var16, int var17, int var18, int[] var19, int var20, float[] var21, int var22, int var23, int[] var24, int var25, int var26);

    public static int ssyevr(char jobz, char range, char uplo, int n, float[] a, int aIdx, int lda, float vl, float vu, int il, int iu, float abstol, int[] m, int mIdx, float[] w, int wIdx, float[] z, int zIdx, int ldz, int[] isuppz, int isuppzIdx) {
        float[] work = new float[1];
        int[] iwork = new int[1];
        int info = NativeBlas.ssyevr(jobz, range, uplo, n, floatDummy, 0, lda, vl, vu, il, iu, abstol, intDummy, 0, floatDummy, 0, floatDummy, 0, ldz, intDummy, 0, work, 0, -1, iwork, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork];
        int liwork = iwork[0];
        iwork = new int[liwork];
        info = NativeBlas.ssyevr(jobz, range, uplo, n, a, aIdx, lda, vl, vu, il, iu, abstol, m, mIdx, w, wIdx, z, zIdx, ldz, isuppz, isuppzIdx, work, 0, lwork, iwork, 0, liwork);
        return info;
    }

    public static native int ssyevx(char var0, char var1, char var2, int var3, float[] var4, int var5, int var6, float var7, float var8, int var9, int var10, float var11, int[] var12, int var13, float[] var14, int var15, float[] var16, int var17, int var18, float[] var19, int var20, int var21, int[] var22, int var23, int[] var24, int var25);

    public static int ssyevx(char jobz, char range, char uplo, int n, float[] a, int aIdx, int lda, float vl, float vu, int il, int iu, float abstol, int[] m, int mIdx, float[] w, int wIdx, float[] z, int zIdx, int ldz, int[] iwork, int iworkIdx, int[] ifail, int ifailIdx) {
        float[] work = new float[1];
        int info = NativeBlas.ssyevx(jobz, range, uplo, n, floatDummy, 0, lda, vl, vu, il, iu, abstol, intDummy, 0, floatDummy, 0, floatDummy, 0, ldz, work, 0, -1, intDummy, 0, intDummy, 0);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork];
        info = NativeBlas.ssyevx(jobz, range, uplo, n, a, aIdx, lda, vl, vu, il, iu, abstol, m, mIdx, w, wIdx, z, zIdx, ldz, work, 0, lwork, iwork, iworkIdx, ifail, ifailIdx);
        return info;
    }

    public static native int dposv(char var0, int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, int var8);

    public static native int sposv(char var0, int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, int var8);

    public static native int cgeev(char var0, char var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18);

    public static int cgeev(char jobvl, char jobvr, int n, float[] a, int aIdx, int lda, float[] w, int wIdx, float[] vl, int vlIdx, int ldvl, float[] vr, int vrIdx, int ldvr, float[] rwork, int rworkIdx) {
        float[] work = new float[2];
        int info = NativeBlas.cgeev(jobvl, jobvr, n, floatDummy, 0, lda, floatDummy, 0, floatDummy, 0, ldvl, floatDummy, 0, ldvr, work, 0, -1, floatDummy, 0);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork * 2];
        info = NativeBlas.cgeev(jobvl, jobvr, n, a, aIdx, lda, w, wIdx, vl, vlIdx, ldvl, vr, vrIdx, ldvr, work, 0, lwork, rwork, rworkIdx);
        return info;
    }

    public static native int dgeev(char var0, char var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15, double[] var16, int var17, int var18);

    public static int dgeev(char jobvl, char jobvr, int n, double[] a, int aIdx, int lda, double[] wr, int wrIdx, double[] wi, int wiIdx, double[] vl, int vlIdx, int ldvl, double[] vr, int vrIdx, int ldvr) {
        double[] work = new double[1];
        int info = NativeBlas.dgeev(jobvl, jobvr, n, doubleDummy, 0, lda, doubleDummy, 0, doubleDummy, 0, doubleDummy, 0, ldvl, doubleDummy, 0, ldvr, work, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork];
        info = NativeBlas.dgeev(jobvl, jobvr, n, a, aIdx, lda, wr, wrIdx, wi, wiIdx, vl, vlIdx, ldvl, vr, vrIdx, ldvr, work, 0, lwork);
        return info;
    }

    public static native int sgeev(char var0, char var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, int var18);

    public static int sgeev(char jobvl, char jobvr, int n, float[] a, int aIdx, int lda, float[] wr, int wrIdx, float[] wi, int wiIdx, float[] vl, int vlIdx, int ldvl, float[] vr, int vrIdx, int ldvr) {
        float[] work = new float[1];
        int info = NativeBlas.sgeev(jobvl, jobvr, n, floatDummy, 0, lda, floatDummy, 0, floatDummy, 0, floatDummy, 0, ldvl, floatDummy, 0, ldvr, work, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork];
        info = NativeBlas.sgeev(jobvl, jobvr, n, a, aIdx, lda, wr, wrIdx, wi, wiIdx, vl, vlIdx, ldvl, vr, vrIdx, ldvr, work, 0, lwork);
        return info;
    }

    public static native int zgeev(char var0, char var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18);

    public static int zgeev(char jobvl, char jobvr, int n, double[] a, int aIdx, int lda, double[] w, int wIdx, double[] vl, int vlIdx, int ldvl, double[] vr, int vrIdx, int ldvr, double[] rwork, int rworkIdx) {
        double[] work = new double[2];
        int info = NativeBlas.zgeev(jobvl, jobvr, n, doubleDummy, 0, lda, doubleDummy, 0, doubleDummy, 0, ldvl, doubleDummy, 0, ldvr, work, 0, -1, doubleDummy, 0);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork * 2];
        info = NativeBlas.zgeev(jobvl, jobvr, n, a, aIdx, lda, w, wIdx, vl, vlIdx, ldvl, vr, vrIdx, ldvr, work, 0, lwork, rwork, rworkIdx);
        return info;
    }

    public static native int dgetrf(int var0, int var1, double[] var2, int var3, int var4, int[] var5, int var6);

    public static native int sgetrf(int var0, int var1, float[] var2, int var3, int var4, int[] var5, int var6);

    public static native int dpotrf(char var0, int var1, double[] var2, int var3, int var4);

    public static native int spotrf(char var0, int var1, float[] var2, int var3, int var4);

    public static native int cgesvd(char var0, char var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, float[] var18, int var19);

    public static int cgesvd(char jobu, char jobvt, int m, int n, float[] a, int aIdx, int lda, float[] s, int sIdx, float[] u, int uIdx, int ldu, float[] vt, int vtIdx, int ldvt, float[] rwork, int rworkIdx) {
        float[] work = new float[2];
        int info = NativeBlas.cgesvd(jobu, jobvt, m, n, floatDummy, 0, lda, floatDummy, 0, floatDummy, 0, ldu, floatDummy, 0, ldvt, work, 0, -1, floatDummy, 0);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork * 2];
        info = NativeBlas.cgesvd(jobu, jobvt, m, n, a, aIdx, lda, s, sIdx, u, uIdx, ldu, vt, vtIdx, ldvt, work, 0, lwork, rwork, rworkIdx);
        return info;
    }

    public static native int dgesvd(char var0, char var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17);

    public static int dgesvd(char jobu, char jobvt, int m, int n, double[] a, int aIdx, int lda, double[] s, int sIdx, double[] u, int uIdx, int ldu, double[] vt, int vtIdx, int ldvt) {
        double[] work = new double[1];
        int info = NativeBlas.dgesvd(jobu, jobvt, m, n, doubleDummy, 0, lda, doubleDummy, 0, doubleDummy, 0, ldu, doubleDummy, 0, ldvt, work, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork];
        info = NativeBlas.dgesvd(jobu, jobvt, m, n, a, aIdx, lda, s, sIdx, u, uIdx, ldu, vt, vtIdx, ldvt, work, 0, lwork);
        return info;
    }

    public static native int sgesvd(char var0, char var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17);

    public static int sgesvd(char jobu, char jobvt, int m, int n, float[] a, int aIdx, int lda, float[] s, int sIdx, float[] u, int uIdx, int ldu, float[] vt, int vtIdx, int ldvt) {
        float[] work = new float[1];
        int info = NativeBlas.sgesvd(jobu, jobvt, m, n, floatDummy, 0, lda, floatDummy, 0, floatDummy, 0, ldu, floatDummy, 0, ldvt, work, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork];
        info = NativeBlas.sgesvd(jobu, jobvt, m, n, a, aIdx, lda, s, sIdx, u, uIdx, ldu, vt, vtIdx, ldvt, work, 0, lwork);
        return info;
    }

    public static native int zgesvd(char var0, char var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, double[] var18, int var19);

    public static int zgesvd(char jobu, char jobvt, int m, int n, double[] a, int aIdx, int lda, double[] s, int sIdx, double[] u, int uIdx, int ldu, double[] vt, int vtIdx, int ldvt, double[] rwork, int rworkIdx) {
        double[] work = new double[2];
        int info = NativeBlas.zgesvd(jobu, jobvt, m, n, doubleDummy, 0, lda, doubleDummy, 0, doubleDummy, 0, ldu, doubleDummy, 0, ldvt, work, 0, -1, doubleDummy, 0);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork * 2];
        info = NativeBlas.zgesvd(jobu, jobvt, m, n, a, aIdx, lda, s, sIdx, u, uIdx, ldu, vt, vtIdx, ldvt, work, 0, lwork, rwork, rworkIdx);
        return info;
    }

    public static native int dsygvd(int var0, char var1, char var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, int[] var15, int var16, int var17);

    public static int dsygvd(int itype, char jobz, char uplo, int n, double[] a, int aIdx, int lda, double[] b, int bIdx, int ldb, double[] w, int wIdx) {
        double[] work = new double[1];
        int[] iwork = new int[1];
        int info = NativeBlas.dsygvd(itype, jobz, uplo, n, doubleDummy, 0, lda, doubleDummy, 0, ldb, doubleDummy, 0, work, 0, -1, iwork, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork];
        int liwork = iwork[0];
        iwork = new int[liwork];
        info = NativeBlas.dsygvd(itype, jobz, uplo, n, a, aIdx, lda, b, bIdx, ldb, w, wIdx, work, 0, lwork, iwork, 0, liwork);
        return info;
    }

    public static native int ssygvd(int var0, char var1, char var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, int var14, int[] var15, int var16, int var17);

    public static int ssygvd(int itype, char jobz, char uplo, int n, float[] a, int aIdx, int lda, float[] b, int bIdx, int ldb, float[] w, int wIdx) {
        float[] work = new float[1];
        int[] iwork = new int[1];
        int info = NativeBlas.ssygvd(itype, jobz, uplo, n, floatDummy, 0, lda, floatDummy, 0, ldb, floatDummy, 0, work, 0, -1, iwork, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork];
        int liwork = iwork[0];
        iwork = new int[liwork];
        info = NativeBlas.ssygvd(itype, jobz, uplo, n, a, aIdx, lda, b, bIdx, ldb, w, wIdx, work, 0, lwork, iwork, 0, liwork);
        return info;
    }

    public static native int dgelsd(int var0, int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double var11, int[] var13, int var14, double[] var15, int var16, int var17, int[] var18, int var19);

    public static int dgelsd(int m, int n, int nrhs, double[] a, int aIdx, int lda, double[] b, int bIdx, int ldb, double[] s, int sIdx, double rcond, int[] rank, int rankIdx, int[] iwork, int iworkIdx) {
        double[] work = new double[1];
        int info = NativeBlas.dgelsd(m, n, nrhs, doubleDummy, 0, lda, doubleDummy, 0, ldb, doubleDummy, 0, rcond, intDummy, 0, work, 0, -1, intDummy, 0);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork];
        info = NativeBlas.dgelsd(m, n, nrhs, a, aIdx, lda, b, bIdx, ldb, s, sIdx, rcond, rank, rankIdx, work, 0, lwork, iwork, iworkIdx);
        return info;
    }

    public static native int sgelsd(int var0, int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float var11, int[] var12, int var13, float[] var14, int var15, int var16, int[] var17, int var18);

    public static int sgelsd(int m, int n, int nrhs, float[] a, int aIdx, int lda, float[] b, int bIdx, int ldb, float[] s, int sIdx, float rcond, int[] rank, int rankIdx, int[] iwork, int iworkIdx) {
        float[] work = new float[1];
        int info = NativeBlas.sgelsd(m, n, nrhs, floatDummy, 0, lda, floatDummy, 0, ldb, floatDummy, 0, rcond, intDummy, 0, work, 0, -1, intDummy, 0);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork];
        info = NativeBlas.sgelsd(m, n, nrhs, a, aIdx, lda, b, bIdx, ldb, s, sIdx, rcond, rank, rankIdx, work, 0, lwork, iwork, iworkIdx);
        return info;
    }

    public static native int ilaenv(int var0, String var1, String var2, int var3, int var4, int var5, int var6);

    public static native int dgeqrf(int var0, int var1, double[] var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9);

    public static int dgeqrf(int m, int n, double[] a, int aIdx, int lda, double[] tau, int tauIdx) {
        double[] work = new double[1];
        int info = NativeBlas.dgeqrf(m, n, doubleDummy, 0, lda, doubleDummy, 0, work, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork];
        info = NativeBlas.dgeqrf(m, n, a, aIdx, lda, tau, tauIdx, work, 0, lwork);
        return info;
    }

    public static native int sgeqrf(int var0, int var1, float[] var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9);

    public static int sgeqrf(int m, int n, float[] a, int aIdx, int lda, float[] tau, int tauIdx) {
        float[] work = new float[1];
        int info = NativeBlas.sgeqrf(m, n, floatDummy, 0, lda, floatDummy, 0, work, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork];
        info = NativeBlas.sgeqrf(m, n, a, aIdx, lda, tau, tauIdx, work, 0, lwork);
        return info;
    }

    public static native int dormqr(char var0, char var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15);

    public static int dormqr(char side, char trans, int m, int n, int k, double[] a, int aIdx, int lda, double[] tau, int tauIdx, double[] c, int cIdx, int ldc) {
        double[] work = new double[1];
        int info = NativeBlas.dormqr(side, trans, m, n, k, doubleDummy, 0, lda, doubleDummy, 0, doubleDummy, 0, ldc, work, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new double[lwork];
        info = NativeBlas.dormqr(side, trans, m, n, k, a, aIdx, lda, tau, tauIdx, c, cIdx, ldc, work, 0, lwork);
        return info;
    }

    public static native int sormqr(char var0, char var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, int var15);

    public static int sormqr(char side, char trans, int m, int n, int k, float[] a, int aIdx, int lda, float[] tau, int tauIdx, float[] c, int cIdx, int ldc) {
        float[] work = new float[1];
        int info = NativeBlas.sormqr(side, trans, m, n, k, floatDummy, 0, lda, floatDummy, 0, floatDummy, 0, ldc, work, 0, -1);
        if (info != 0) {
            return info;
        }
        int lwork = (int)work[0];
        work = new float[lwork];
        info = NativeBlas.sormqr(side, trans, m, n, k, a, aIdx, lda, tau, tauIdx, c, cIdx, ldc, work, 0, lwork);
        return info;
    }

    static {
        NativeBlasLibraryLoader.loadLibraryAndCheckErrors();
        intDummy = new int[1];
        doubleDummy = new double[1];
        floatDummy = new float[1];
    }
}

