/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.tsne.barneshut;

import com.jujutsu.tsne.barneshut.VpTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TreePrinter {
    AdditionalInfoProvider provider;

    public TreePrinter() {
    }

    public TreePrinter(AdditionalInfoProvider additionalInfoProvider) {
        this.provider = additionalInfoProvider;
    }

    public <T extends Comparable<?>> void printNode(VpTree.Node root) {
        int maxLevel = this.maxLevel(root);
        this.printNodeInternal(Collections.singletonList(root), 1, maxLevel);
    }

    private <T extends Comparable<?>> void printNodeInternal(List<VpTree.Node> nodes, int level, int maxLevel) {
        if (nodes.isEmpty() || this.isAllElementsNull(nodes)) {
            return;
        }
        int floor = maxLevel - level;
        int endgeLines = (int)Math.pow(2.0, Math.max(floor - 1, 0));
        int firstSpaces = (int)Math.pow(2.0, floor) - 1;
        int betweenSpaces = (int)Math.pow(2.0, floor + 1) - 1;
        this.printWhitespaces(firstSpaces);
        ArrayList<VpTree.Node> newNodes = new ArrayList<VpTree.Node>();
        for (VpTree.Node node : nodes) {
            if (node != null) {
                System.out.print(node.index);
                if (this.provider != null) {
                    System.out.print("(" + this.provider.provideInfo(node) + ")");
                }
                newNodes.add(node.getLeft());
                newNodes.add(node.getRight());
            } else {
                newNodes.add(null);
                newNodes.add(null);
                System.out.print(" ");
            }
            this.printWhitespaces(betweenSpaces);
        }
        System.out.println("");
        for (int i = 1; i <= endgeLines; ++i) {
            for (int j = 0; j < nodes.size(); ++j) {
                this.printWhitespaces(firstSpaces - i);
                if (nodes.get(j) == null) {
                    this.printWhitespaces(endgeLines + endgeLines + i + 1);
                    continue;
                }
                if (nodes.get(j).getLeft() != null) {
                    System.out.print("/");
                } else {
                    this.printWhitespaces(1);
                }
                this.printWhitespaces(i + i - 1);
                if (nodes.get(j).getRight() != null) {
                    System.out.print("\\");
                } else {
                    this.printWhitespaces(1);
                }
                this.printWhitespaces(endgeLines + endgeLines - i);
            }
            System.out.println("");
        }
        this.printNodeInternal(newNodes, level + 1, maxLevel);
    }

    private void printWhitespaces(int count) {
        for (int i = 0; i < count; ++i) {
            System.out.print(" ");
        }
    }

    private <T extends Comparable<?>> int maxLevel(VpTree.Node node) {
        if (node == null) {
            return 0;
        }
        return Math.max(this.maxLevel(node.getLeft()), this.maxLevel(node.getRight())) + 1;
    }

    private <T> boolean isAllElementsNull(List<T> list) {
        for (T object : list) {
            if (object == null) continue;
            return false;
        }
        return true;
    }

    public void printTreeHorizontal(VpTree.Node node) {
        if (node.getRight() != null) {
            this.printTree(node.getRight(), true, "");
        }
        this.printNodeValue(node);
        if (node.getLeft() != null) {
            this.printTree(node.getLeft(), false, "");
        }
    }

    private void printNodeValue(VpTree.Node node) {
        if (node == null) {
            System.out.print("<null>");
        } else {
            System.out.print(node.index);
            if (this.provider != null) {
                System.out.print("(" + this.provider.provideInfo(node) + ")");
            }
        }
        System.out.print('\n');
    }

    private void printTree(VpTree.Node node, boolean isRight, String indent) {
        if (node.getRight() != null) {
            this.printTree(node.getRight(), true, indent + (isRight ? "        " : " |      "));
        }
        System.out.print(indent);
        if (isRight) {
            System.out.print(" /");
        } else {
            System.out.print(" \\");
        }
        System.out.print("----- ");
        this.printNodeValue(node);
        if (node.getLeft() != null) {
            this.printTree(node.getLeft(), false, indent + (isRight ? " |      " : "        "));
        }
    }

    public static interface AdditionalInfoProvider {
        public String provideInfo(VpTree.Node var1);
    }
}

