/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.tsne.barneshut;

import com.jujutsu.utils.MatrixOps;

public class SPTree {
    static final int QT_NODE_CAPACITY = 1;
    protected SPTree parent;
    protected int dimension;
    protected boolean is_leaf;
    protected int size;
    protected int cum_size;
    Cell boundary;
    double[] data;
    double[] center_of_mass;
    int[] index = new int[1];
    SPTree[] children;
    int no_children;

    public SPTree(int D, double[] inp_data, int N) {
        int d;
        int d2;
        int nD = 0;
        double[] mean_Y = new double[D];
        double[] min_Y = new double[D];
        double[] max_Y = new double[D];
        for (d2 = 0; d2 < D; ++d2) {
            min_Y[d2] = Double.POSITIVE_INFINITY;
            max_Y[d2] = Double.NEGATIVE_INFINITY;
        }
        for (int n = 0; n < N; ++n) {
            for (d = 0; d < D; ++d) {
                int n2 = d;
                mean_Y[n2] = mean_Y[n2] + inp_data[n * D + d];
                if (inp_data[nD + d] < min_Y[d]) {
                    min_Y[d] = inp_data[nD + d];
                }
                if (!(inp_data[nD + d] > max_Y[d])) continue;
                max_Y[d] = inp_data[nD + d];
            }
            nD += D;
        }
        d2 = 0;
        while (d2 < D) {
            int n = d2++;
            mean_Y[n] = mean_Y[n] / (double)N;
        }
        double[] width = new double[D];
        for (d = 0; d < D; ++d) {
            width[d] = Math.max(max_Y[d] - mean_Y[d], mean_Y[d] - min_Y[d]) + 1.0E-5;
        }
        this.init(null, D, inp_data, mean_Y, width);
        this.fill(N);
    }

    void init(SPTree inp_parent, int D, double[] inp_data, double[] inp_corner, double[] inp_width) {
        int d;
        this.parent = inp_parent;
        this.dimension = D;
        this.no_children = 2;
        for (d = 1; d < D; ++d) {
            this.no_children *= 2;
        }
        this.data = inp_data;
        this.is_leaf = true;
        this.size = 0;
        this.cum_size = 0;
        this.center_of_mass = new double[D];
        this.boundary = new Cell(this.dimension);
        for (d = 0; d < D; ++d) {
            this.boundary.setCorner(d, inp_corner[d]);
            this.boundary.setWidth(d, inp_width[d]);
            this.center_of_mass[d] = 0.0;
        }
        this.children = this.getTreeArray(this.no_children);
        for (int i = 0; i < this.no_children; ++i) {
            this.children[i] = null;
        }
    }

    SPTree(int D, double[] inp_data, int N, double[] inp_corner, double[] inp_width) {
        this.init(null, D, inp_data, inp_corner, inp_width);
        this.fill(N);
    }

    SPTree(int D, double[] inp_data, double[] inp_corner, double[] inp_width) {
        this.init(null, D, inp_data, inp_corner, inp_width);
    }

    SPTree(SPTree inp_parent, int D, double[] inp_data, double[] inp_corner, double[] inp_width) {
        this.init(inp_parent, D, inp_data, inp_corner, inp_width);
    }

    SPTree(SPTree inp_parent, int D, double[] inp_data, int N, double[] inp_corner, double[] inp_width) {
        this.init(inp_parent, D, inp_data, inp_corner, inp_width);
        this.fill(N);
    }

    void setData(double[] inp_data) {
        this.data = inp_data;
    }

    SPTree getParent() {
        return this.parent;
    }

    SPTree[] getTreeArray(int no_children) {
        return new SPTree[no_children];
    }

    boolean insert(int new_index) {
        double[] point = MatrixOps.extractRowFromFlatMatrix(this.data, new_index, this.dimension);
        if (!this.boundary.containsPoint(point)) {
            return false;
        }
        ++this.cum_size;
        double mult1 = (double)(this.cum_size - 1) / (double)this.cum_size;
        double mult2 = 1.0 / (double)this.cum_size;
        for (int d = 0; d < this.dimension; ++d) {
            int n = d;
            this.center_of_mass[n] = this.center_of_mass[n] * mult1;
            int n2 = d;
            this.center_of_mass[n2] = this.center_of_mass[n2] + mult2 * point[d];
        }
        if (this.is_leaf && this.size < 1) {
            this.index[this.size] = new_index;
            ++this.size;
            return true;
        }
        boolean any_duplicate = false;
        for (int n = 0; n < this.size; ++n) {
            boolean duplicate = true;
            for (int d = 0; d < this.dimension; ++d) {
                if (point[d] == this.data[this.index[n] * this.dimension + d]) continue;
                duplicate = false;
                break;
            }
            any_duplicate = any_duplicate || duplicate;
        }
        if (any_duplicate) {
            return true;
        }
        if (this.is_leaf) {
            this.subdivide();
        }
        for (int i = 0; i < this.no_children; ++i) {
            if (!this.children[i].insert(new_index)) continue;
            return true;
        }
        assert (false);
        return false;
    }

    void subdivide() {
        int i;
        double[] new_corner = new double[this.dimension];
        double[] new_width = new double[this.dimension];
        for (i = 0; i < this.no_children; ++i) {
            int div = 1;
            for (int d = 0; d < this.dimension; ++d) {
                new_width[d] = 0.5 * this.boundary.getWidth(d);
                new_corner[d] = i / div % 2 == 1 ? this.boundary.getCorner(d) - 0.5 * this.boundary.getWidth(d) : this.boundary.getCorner(d) + 0.5 * this.boundary.getWidth(d);
                div *= 2;
            }
            this.children[i] = this.getNewTree(this, new_corner, new_width);
        }
        for (i = 0; i < this.size; ++i) {
            boolean success = false;
            for (int j = 0; j < this.no_children; ++j) {
                if (success) continue;
                success = this.children[j].insert(this.index[i]);
            }
            this.index[i] = -1;
        }
        this.size = 0;
        this.is_leaf = false;
    }

    SPTree getNewTree(SPTree root, double[] new_corner, double[] new_width) {
        return new SPTree(root, this.dimension, this.data, new_corner, new_width);
    }

    void fill(int N) {
        for (int i = 0; i < N; ++i) {
            this.insert(i);
        }
    }

    boolean isCorrect() {
        for (int n = 0; n < this.size; ++n) {
            double[] point = MatrixOps.extractRowFromFlatMatrix(this.data, this.index[n], this.dimension);
            if (this.boundary.containsPoint(point)) continue;
            return false;
        }
        if (!this.is_leaf) {
            boolean correct = true;
            for (int i = 0; i < this.no_children; ++i) {
                correct = correct && this.children[i].isCorrect();
            }
            return correct;
        }
        return true;
    }

    void getAllIndices(int[] indices) {
        this.getAllIndices(indices, 0);
    }

    int getAllIndices(int[] indices, int loc) {
        int i;
        for (i = 0; i < this.size; ++i) {
            indices[loc + i] = this.index[i];
        }
        loc += this.size;
        if (!this.is_leaf) {
            for (i = 0; i < this.no_children; ++i) {
                loc = this.children[i].getAllIndices(indices, loc);
            }
        }
        return loc;
    }

    int getDepth() {
        if (this.is_leaf) {
            return 1;
        }
        int depth = 0;
        for (int i = 0; i < this.no_children; ++i) {
            depth = Math.max(depth, this.children[i].getDepth());
        }
        return 1 + depth;
    }

    double computeNonEdgeForces(int point_index, double theta, double[] neg_f, Object accumulator) {
        double[] sum_Q = (double[])accumulator;
        double[] buff = new double[this.dimension];
        if (this.cum_size == 0 || this.is_leaf && this.size == 1 && this.index[0] == point_index) {
            return 0.0;
        }
        double D = 0.0;
        int ind = point_index * this.dimension;
        double max_width = 0.0;
        for (int d = 0; d < this.dimension; ++d) {
            buff[d] = this.data[ind + d] - this.center_of_mass[d];
            D += buff[d] * buff[d];
            double cur_width = this.boundary.getWidth(d);
            max_width = max_width > cur_width ? max_width : cur_width;
        }
        if (this.is_leaf || max_width / Math.sqrt(D) < theta) {
            D = 1.0 / (1.0 + D);
            double mult = (double)this.cum_size * D;
            sum_Q[0] = sum_Q[0] + mult;
            mult *= D;
            for (int d = 0; d < this.dimension; ++d) {
                int n = d;
                neg_f[n] = neg_f[n] + mult * buff[d];
            }
        } else {
            for (int i = 0; i < this.no_children; ++i) {
                this.children[i].computeNonEdgeForces(point_index, theta, neg_f, sum_Q);
            }
        }
        return sum_Q[0];
    }

    void computeEdgeForces(int[] row_P, int[] col_P, double[] val_P, int N, double[] pos_f) {
        double[] buff = new double[this.dimension];
        int ind1 = 0;
        int ind2 = 0;
        for (int n = 0; n < N; ++n) {
            for (int i = row_P[n]; i < row_P[n + 1]; ++i) {
                int d;
                double D = 1.0;
                ind2 = col_P[i] * this.dimension;
                for (d = 0; d < this.dimension; ++d) {
                    buff[d] = this.data[ind1 + d] - this.data[ind2 + d];
                    D += buff[d] * buff[d];
                }
                D = val_P[i] / D;
                for (d = 0; d < this.dimension; ++d) {
                    int n2 = ind1 + d;
                    pos_f[n2] = pos_f[n2] + D * buff[d];
                }
            }
            ind1 += this.dimension;
        }
    }

    void print() {
        if (this.cum_size == 0) {
            System.out.printf("Empty node\n", new Object[0]);
            return;
        }
        if (this.is_leaf) {
            System.out.printf("Leaf node; data = [", new Object[0]);
            for (int i = 0; i < this.size; ++i) {
                double[] point = MatrixOps.extractRowFromFlatMatrix(this.data, this.index[i], this.dimension);
                for (int d = 0; d < this.dimension; ++d) {
                    System.out.printf("%f, ", point[d]);
                }
                System.out.printf(" (index = %d)", this.index[i]);
                if (i < this.size - 1) {
                    System.out.printf("\n", new Object[0]);
                    continue;
                }
                System.out.printf("]\n", new Object[0]);
            }
        } else {
            System.out.printf("Intersection node with center-of-mass = [", new Object[0]);
            for (int d = 0; d < this.dimension; ++d) {
                System.out.printf("%f, ", this.center_of_mass[d]);
            }
            System.out.printf("]; children are:\n", new Object[0]);
            for (int i = 0; i < this.no_children; ++i) {
                this.children[i].print();
            }
        }
    }

    class Cell {
        int dimension;
        double[] corner;
        double[] width;

        Cell(int inp_dimension) {
            this.dimension = inp_dimension;
            this.corner = new double[this.dimension];
            this.width = new double[this.dimension];
        }

        Cell(int inp_dimension, double[] inp_corner, double[] inp_width) {
            int d;
            this.dimension = inp_dimension;
            this.corner = new double[this.dimension];
            this.width = new double[this.dimension];
            for (d = 0; d < this.dimension; ++d) {
                this.setCorner(d, inp_corner[d]);
            }
            for (d = 0; d < this.dimension; ++d) {
                this.setWidth(d, inp_width[d]);
            }
        }

        double getCorner(int d) {
            return this.corner[d];
        }

        double getWidth(int d) {
            return this.width[d];
        }

        void setCorner(int d, double val) {
            this.corner[d] = val;
        }

        void setWidth(int d, double val) {
            this.width[d] = val;
        }

        boolean containsPoint(double[] point) {
            for (int d = 0; d < this.dimension; ++d) {
                if (this.corner[d] - this.width[d] > point[d]) {
                    return false;
                }
                if (!(this.corner[d] + this.width[d] < point[d])) continue;
                return false;
            }
            return true;
        }
    }
}

