/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.tsne.barneshut;

import com.jujutsu.tsne.barneshut.DataPoint;
import com.jujutsu.tsne.barneshut.Distance;
import com.jujutsu.tsne.barneshut.ParallelVpTree;
import com.jujutsu.tsne.barneshut.VpTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;

public class ParallelVpTree<StorageType>
extends VpTree<StorageType> {
    private ForkJoinPool searcherPool;

    public ParallelVpTree(ForkJoinPool pool, Distance distance) {
        super(distance);
        this.searcherPool = pool;
    }

    public ParallelVpTree(ForkJoinPool pool) {
        this.searcherPool = pool;
    }

    public List<Future<TreeSearchResult>> searchMultiple(ParallelVpTree<StorageType> tree, DataPoint[] targets, int k) {
        ArrayList<ParallelTreeNode.ParallelTreeSearcher> searchers = new ArrayList<ParallelTreeNode.ParallelTreeSearcher>();
        for (int n = 0; n < targets.length; ++n) {
            ParallelTreeNode node;
            ParallelTreeNode parallelTreeNode = node = (ParallelTreeNode)tree.getRoot();
            parallelTreeNode.getClass();
            searchers.add(parallelTreeNode.new ParallelTreeNode.ParallelTreeSearcher(node, this._items, targets[n], k, n));
        }
        List<Future<TreeSearchResult>> results = this.searcherPool.invokeAll(searchers);
        return results;
    }

    @Override
    protected VpTree.Node createNode() {
        return new ParallelTreeNode();
    }

    class ParallelTreeNode
    extends VpTree.Node {
        ParallelTreeNode() {
        }

        class ParallelTreeSearcher
        implements Callable<com.jujutsu.tsne.barneshut.ParallelVpTree$ParallelTreeNode.TreeSearchResult> {
            VpTree.Node node;
            Queue<VpTree.HeapItem> heap;
            DataPoint target;
            int k;
            int n;
            DataPoint[] items;

            public ParallelTreeSearcher(VpTree.Node tree, DataPoint[] items, DataPoint target, int k, int n) {
                this.node = tree;
                this.target = target;
                this.k = k;
                this.items = items;
                this.n = n;
            }

            @Override
            public com.jujutsu.tsne.barneshut.ParallelVpTree$ParallelTreeNode.TreeSearchResult call() {
                ArrayList<DataPoint> indices = new ArrayList<DataPoint>();
                ArrayList<Double> distances = new ArrayList<Double>();
                PriorityQueue<VpTree.HeapItem> heap = new PriorityQueue<VpTree.HeapItem>(this.k, new Comparator<VpTree.HeapItem>(){

                    @Override
                    public int compare(VpTree.HeapItem o1, VpTree.HeapItem o2) {
                        return -1 * o1.compareTo(o2);
                    }
                });
                double tau = Double.MAX_VALUE;
                this.node.search(this.node, this.target, this.k, heap, tau);
                while (!heap.isEmpty()) {
                    indices.add(this.items[heap.peek().index]);
                    distances.add(heap.peek().dist);
                    heap.remove();
                }
                Collections.reverse(indices);
                Collections.reverse(distances);
                return new TreeSearchResult(indices, distances, this.n);
            }
        }

        class TreeSearchResult {
            int n;
            List<Double> distances;
            List<DataPoint> indices;

            public TreeSearchResult(List<DataPoint> indices, List<Double> distances, int n) {
                this.indices = indices;
                this.distances = distances;
                this.n = n;
            }

            public List<DataPoint> getIndices() {
                return this.indices;
            }

            public List<Double> getDistances() {
                return this.distances;
            }

            public int getIndex() {
                return this.n;
            }
        }
    }
}

