/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.tsne.barneshut;

import com.jujutsu.tsne.barneshut.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class BTreePrinter {
    BTreePrinter() {
    }

    public static <T extends Comparable<?>> void printNode(Node<T> root) {
        int maxLevel = BTreePrinter.maxLevel(root);
        BTreePrinter.printNodeInternal(Collections.singletonList(root), 1, maxLevel);
    }

    private static <T extends Comparable<?>> void printNodeInternal(List<Node<T>> nodes, int level, int maxLevel) {
        if (nodes.isEmpty() || BTreePrinter.isAllElementsNull(nodes)) {
            return;
        }
        int floor = maxLevel - level;
        int endgeLines = (int)Math.pow(2.0, Math.max(floor - 1, 0));
        int firstSpaces = (int)Math.pow(2.0, floor) - 1;
        int betweenSpaces = (int)Math.pow(2.0, floor + 1) - 1;
        BTreePrinter.printWhitespaces(firstSpaces);
        ArrayList<Node<T>> newNodes = new ArrayList<Node<T>>();
        for (Node<T> node : nodes) {
            if (node != null) {
                System.out.print(node.data);
                newNodes.add(node.left);
                newNodes.add(node.right);
            } else {
                newNodes.add(null);
                newNodes.add(null);
                System.out.print(" ");
            }
            BTreePrinter.printWhitespaces(betweenSpaces);
        }
        System.out.println("");
        for (int i = 1; i <= endgeLines; ++i) {
            for (int j = 0; j < nodes.size(); ++j) {
                BTreePrinter.printWhitespaces(firstSpaces - i);
                if (nodes.get(j) == null) {
                    BTreePrinter.printWhitespaces(endgeLines + endgeLines + i + 1);
                    continue;
                }
                if (nodes.get((int)j).left != null) {
                    System.out.print("/");
                } else {
                    BTreePrinter.printWhitespaces(1);
                }
                BTreePrinter.printWhitespaces(i + i - 1);
                if (nodes.get((int)j).right != null) {
                    System.out.print("\\");
                } else {
                    BTreePrinter.printWhitespaces(1);
                }
                BTreePrinter.printWhitespaces(endgeLines + endgeLines - i);
            }
            System.out.println("");
        }
        BTreePrinter.printNodeInternal(newNodes, level + 1, maxLevel);
    }

    private static void printWhitespaces(int count) {
        for (int i = 0; i < count; ++i) {
            System.out.print(" ");
        }
    }

    private static <T extends Comparable<?>> int maxLevel(Node<T> node) {
        if (node == null) {
            return 0;
        }
        return Math.max(BTreePrinter.maxLevel(node.left), BTreePrinter.maxLevel(node.right)) + 1;
    }

    private static <T> boolean isAllElementsNull(List<T> list) {
        for (T object : list) {
            if (object == null) continue;
            return false;
        }
        return true;
    }
}

