/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.executable;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.revelc.code.formatter.exception.MavenGitCodeFormatException;
import net.revelc.code.formatter.executable.CommandRunException;
import net.revelc.code.formatter.executable.CommandRunner;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class DefaultCommandRunner
implements CommandRunner {
    private final Supplier<Log> log;

    public DefaultCommandRunner(Supplier<Log> log) {
        this.log = log;
    }

    @Override
    public String run(Path workingDir, String ... command) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            if (workingDir != null) {
                processBuilder.directory(workingDir.toFile());
            }
            processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            this.log.get().debug((CharSequence)("Executing '" + StringUtils.join((Object[])command, (String)" ") + "'"));
            Process process = processBuilder.start();
            String output = IOUtils.toString((InputStream)process.getInputStream(), (Charset)StandardCharsets.UTF_8).trim() + IOUtils.toString((InputStream)process.getErrorStream(), (Charset)StandardCharsets.UTF_8).trim();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new CommandRunException(exitCode, output, command);
            }
            this.log.get().debug((CharSequence)output);
            return (String)StringUtils.defaultIfBlank((CharSequence)output, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MavenGitCodeFormatException(e);
        }
        catch (IOException e) {
            throw new MavenGitCodeFormatException(e);
        }
    }
}

