/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.revelc.code.formatter.AbstractMavenGitCodeFormatMojo;
import net.revelc.code.formatter.executable.Executable;
import net.revelc.code.formatter.executable.ExecutableManager;
import net.revelc.code.formatter.maven.MavenEnvironment;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="install-hooks", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class InstallHooksMojo
extends AbstractMavenGitCodeFormatMojo {
    private static final String LEGACY_BASE_PLUGIN_PRE_COMMIT_HOOK = "maven-git-code-format.pre-commit.sh";
    private static final String BASE_PLUGIN_PRE_COMMIT_HOOK = "git-code-format.pre-commit.sh";
    private static final String PRE_COMMIT_HOOK_BASE_SCRIPT = "pre-commit";
    private final ExecutableManager executableManager = new ExecutableManager(() -> ((InstallHooksMojo)this).getLog());
    private final MavenEnvironment mavenEnvironment = new MavenEnvironment(() -> ((InstallHooksMojo)this).getLog());
    @Parameter(property="gcf.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="gcf.skipInstallHooks", defaultValue="false")
    private boolean skipInstallHooks;
    @Parameter(property="gcf.truncateHooksBaseScripts", defaultValue="false")
    private boolean truncateHooksBaseScripts;
    @Parameter(property="gcf.propertiesToPropagate")
    private String[] propertiesToPropagate;
    @Parameter(property="gcf.propertiesToAdd")
    private String[] propertiesToAdd;
    @Parameter(property="gcf.debug", defaultValue="false")
    private boolean debug;
    @Parameter(property="gcf.preCommitHookPipeline", defaultValue="")
    private String preCommitHookPipeline;

    public void execute() throws MojoExecutionException {
        if (!this.isExecutionRoot()) {
            this.getLog().debug((CharSequence)"Not in execution root. Do not execute.");
            return;
        }
        if (this.skip || this.skipInstallHooks) {
            Log log = this.getLog();
            if (log.isInfoEnabled()) {
                log.info((CharSequence)"skipped");
            }
            return;
        }
        try {
            this.getLog().info((CharSequence)"Installing git hooks");
            this.doExecute();
            this.getLog().info((CharSequence)"Installed git hooks");
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void doExecute() throws IOException {
        Path hooksDirectory = this.prepareHooksDirectory();
        this.writePluginHooks(hooksDirectory);
        this.configureHookBaseScripts(hooksDirectory);
    }

    private void writePluginHooks(Path hooksDirectory) throws IOException {
        this.getLog().debug((CharSequence)"Removing legacy pre commit hook file");
        Files.deleteIfExists(hooksDirectory.resolve(this.legacyPluginPreCommitHookFileName()));
        this.getLog().debug((CharSequence)"Rmeoved legacy pre commit hook file");
        this.getLog().debug((CharSequence)"Writing plugin pre commit hook file");
        this.executableManager.getOrCreateExecutableScript(hooksDirectory.resolve(this.pluginPreCommitHookFileName())).truncateWithTemplate(() -> ((Object)((Object)this)).getClass().getResourceAsStream(BASE_PLUGIN_PRE_COMMIT_HOOK), StandardCharsets.UTF_8.toString(), this.mavenEnvironment.getMavenExecutable(this.debug).toAbsolutePath(), this.pomFile().toAbsolutePath(), this.mavenCliArguments());
        this.getLog().debug((CharSequence)"Written plugin pre commit hook file");
    }

    private void configureHookBaseScripts(Path hooksDirectory) throws IOException {
        Executable basePreCommitHook = this.executableManager.getOrCreateExecutableScript(hooksDirectory.resolve(PRE_COMMIT_HOOK_BASE_SCRIPT));
        this.getLog().debug((CharSequence)("Configuring '" + basePreCommitHook + "'"));
        if (this.truncateHooksBaseScripts) {
            basePreCommitHook.truncate();
        } else {
            this.legacyPreCommitHookBaseScriptCalls().forEach(basePreCommitHook::removeCommandCall);
        }
        basePreCommitHook.appendCommandCall(this.preCommitHookBaseScriptCall());
    }

    private String mavenCliArguments() {
        Stream<String> propagatedProperties = Optional.ofNullable(this.propertiesToPropagate).map(Arrays::asList).orElse(Collections.emptyList()).stream().filter(prop -> System.getProperty(prop) != null).map(prop -> "-D" + prop + "=" + System.getProperty(prop));
        Stream<String> properties = Stream.concat(propagatedProperties, Stream.of(this.propertiesToAdd));
        if (this.preCommitHookPipeline != null && !this.preCommitHookPipeline.isEmpty()) {
            properties = Stream.concat(properties, Stream.of(this.preCommitHookPipeline));
        }
        return properties.collect(Collectors.joining(" "));
    }

    private Path prepareHooksDirectory() {
        this.getLog().debug((CharSequence)"Preparing git hook directory");
        Path hooksDirectory = this.getOrCreateHooksDirectory();
        this.getLog().debug((CharSequence)"Prepared git hook directory");
        return hooksDirectory;
    }

    private String preCommitHookBaseScriptCall() {
        return "$(git rev-parse --git-dir)/hooks/" + this.pluginPreCommitHookFileName();
    }

    private List<String> legacyPreCommitHookBaseScriptCalls() {
        ArrayList<String> calls = new ArrayList<String>();
        calls.add("./" + this.gitBaseDir().relativize(this.getOrCreateHooksDirectory()) + "/" + this.legacyPluginPreCommitHookFileName());
        calls.add("./" + this.gitBaseDir().relativize(this.getOrCreateHooksDirectory()) + "/" + this.pluginPreCommitHookFileName());
        return calls;
    }

    private String pluginPreCommitHookFileName() {
        return this.artifactId() + "." + BASE_PLUGIN_PRE_COMMIT_HOOK;
    }

    private String legacyPluginPreCommitHookFileName() {
        return this.artifactId() + "." + LEGACY_BASE_PLUGIN_PRE_COMMIT_HOOK;
    }
}

