/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.model;

import java.util.Arrays;
import lecho.lib.hellocharts.util.ChartUtils;

public class SliceValue {
    private static final int DEFAULT_SLICE_SPACING_DP = 2;
    private float value;
    private float originValue;
    private float diff;
    private int color = ChartUtils.DEFAULT_COLOR;
    private int darkenColor = ChartUtils.DEFAULT_DARKEN_COLOR;
    private int sliceSpacing = 2;
    private char[] label;

    public SliceValue() {
        this.setValue(0.0f);
    }

    public SliceValue(float value) {
        this.setValue(value);
    }

    public SliceValue(float value, int color) {
        this.setValue(value);
        this.setColor(color);
    }

    public SliceValue(float value, int color, int sliceSpacing) {
        this.setValue(value);
        this.setColor(color);
        this.sliceSpacing = sliceSpacing;
    }

    public SliceValue(SliceValue sliceValue) {
        this.setValue(sliceValue.value);
        this.setColor(sliceValue.color);
        this.sliceSpacing = sliceValue.sliceSpacing;
        this.label = sliceValue.label;
    }

    public void update(float scale) {
        this.value = this.originValue + this.diff * scale;
    }

    public void finish() {
        this.setValue(this.originValue + this.diff);
    }

    public float getValue() {
        return this.value;
    }

    public SliceValue setValue(float value) {
        this.value = value;
        this.originValue = value;
        this.diff = 0.0f;
        return this;
    }

    public SliceValue setTarget(float target) {
        this.setValue(this.value);
        this.diff = target - this.originValue;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public SliceValue setColor(int color) {
        this.color = color;
        this.darkenColor = ChartUtils.darkenColor(color);
        return this;
    }

    public int getDarkenColor() {
        return this.darkenColor;
    }

    public int getSliceSpacing() {
        return this.sliceSpacing;
    }

    public SliceValue setSliceSpacing(int sliceSpacing) {
        this.sliceSpacing = sliceSpacing;
        return this;
    }

    public char[] getLabel() {
        return this.label;
    }

    public SliceValue setLabel(char[] label) {
        this.label = label;
        return this;
    }

    public String toString() {
        return "SliceValue [value=" + this.value + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SliceValue that = (SliceValue)o;
        if (this.color != that.color) {
            return false;
        }
        if (this.darkenColor != that.darkenColor) {
            return false;
        }
        if (Float.compare(that.diff, this.diff) != 0) {
            return false;
        }
        if (Float.compare(that.originValue, this.originValue) != 0) {
            return false;
        }
        if (this.sliceSpacing != that.sliceSpacing) {
            return false;
        }
        if (Float.compare(that.value, this.value) != 0) {
            return false;
        }
        return Arrays.equals(this.label, that.label);
    }

    public int hashCode() {
        int result = this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
        result = 31 * result + (this.originValue != 0.0f ? Float.floatToIntBits(this.originValue) : 0);
        result = 31 * result + (this.diff != 0.0f ? Float.floatToIntBits(this.diff) : 0);
        result = 31 * result + this.color;
        result = 31 * result + this.darkenColor;
        result = 31 * result + this.sliceSpacing;
        result = 31 * result + (this.label != null ? Arrays.hashCode(this.label) : 0);
        return result;
    }
}

