/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.formatter;

import lecho.lib.hellocharts.formatter.AxisValueFormatter;
import lecho.lib.hellocharts.formatter.ValueFormatterHelper;
import lecho.lib.hellocharts.model.AxisValue;

public class SimpleAxisValueFormatter
implements AxisValueFormatter {
    private ValueFormatterHelper valueFormatterHelper = new ValueFormatterHelper();

    public SimpleAxisValueFormatter() {
        this.valueFormatterHelper.determineDecimalSeparator();
    }

    public SimpleAxisValueFormatter(int decimalDigitsNumber) {
        this();
        this.valueFormatterHelper.setDecimalDigitsNumber(decimalDigitsNumber);
    }

    @Override
    public int formatValueForManualAxis(char[] formattedValue, AxisValue axisValue) {
        int charsNumber = this.valueFormatterHelper.formatFloatValueWithPrependedAndAppendedText(formattedValue, axisValue.getValue(), axisValue.getLabel());
        return charsNumber;
    }

    @Override
    public int formatValueForAutoGeneratedAxis(char[] formattedValue, float value, int autoDecimalDigits) {
        int charsNumber = this.valueFormatterHelper.formatFloatValueWithPrependedAndAppendedText(formattedValue, value, autoDecimalDigits);
        return charsNumber;
    }

    public int getDecimalDigitsNumber() {
        return this.valueFormatterHelper.getDecimalDigitsNumber();
    }

    public SimpleAxisValueFormatter setDecimalDigitsNumber(int decimalDigitsNumber) {
        this.valueFormatterHelper.setDecimalDigitsNumber(decimalDigitsNumber);
        return this;
    }

    public char[] getAppendedText() {
        return this.valueFormatterHelper.getAppendedText();
    }

    public SimpleAxisValueFormatter setAppendedText(char[] appendedText) {
        this.valueFormatterHelper.setAppendedText(appendedText);
        return this;
    }

    public char[] getPrependedText() {
        return this.valueFormatterHelper.getPrependedText();
    }

    public SimpleAxisValueFormatter setPrependedText(char[] prependedText) {
        this.valueFormatterHelper.setPrependedText(prependedText);
        return this;
    }

    public char getDecimalSeparator() {
        return this.valueFormatterHelper.getDecimalSeparator();
    }

    public SimpleAxisValueFormatter setDecimalSeparator(char decimalSeparator) {
        this.valueFormatterHelper.setDecimalSeparator(decimalSeparator);
        return this;
    }
}

