/*
 * Decompiled with CFR 0.152.
 */
package com.github.leanframeworks.minibus.base.filter;

import com.github.leanframeworks.minibus.api.Event;
import com.github.leanframeworks.minibus.api.EventFilter;
import com.github.leanframeworks.minibus.api.Topic;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TopicFilter<C>
implements EventFilter<C> {
    private final boolean accept;
    private final Set<Topic<? extends C>> topics;

    public TopicFilter(Topic<? extends C> topic) {
        this(Collections.singleton(topic));
    }

    @SafeVarargs
    public TopicFilter(Topic<? extends C> ... topics) {
        this(Arrays.asList(topics));
    }

    public TopicFilter(Collection<Topic<? extends C>> topics) {
        this(true, topics);
    }

    @SafeVarargs
    public TopicFilter(boolean accept, Topic<? extends C> ... topics) {
        this(accept, Arrays.asList(topics));
    }

    public TopicFilter(boolean accept, Collection<Topic<? extends C>> topics) {
        this.accept = accept;
        this.topics = new HashSet<Topic<C>>(topics);
    }

    public void addTopic(Topic<? extends C> topic) {
        this.topics.add(topic);
    }

    public void removeTopic(Topic<? extends C> topic) {
        this.topics.remove(topic);
    }

    @Override
    public boolean accept(Event<C> event) {
        boolean result;
        if (this.accept) {
            result = false;
            for (Topic<C> topic : this.topics) {
                if (!topic.covers(event.getTopic())) continue;
                result = true;
                break;
            }
        } else {
            result = true;
            for (Topic<C> topic : this.topics) {
                if (!topic.covers(event.getTopic())) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

