/*
 * Decompiled with CFR 0.152.
 */
package com.github.leanframeworks.minibus.base.filter;

import com.github.leanframeworks.minibus.api.Channel;
import com.github.leanframeworks.minibus.api.Event;
import com.github.leanframeworks.minibus.api.EventFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ChannelFilter<C>
implements EventFilter<C> {
    private final boolean accept;
    private final Set<Channel> channels;

    public ChannelFilter(Channel channel) {
        this(Collections.singleton(channel));
    }

    public ChannelFilter(Channel ... channels) {
        this(Arrays.asList(channels));
    }

    public ChannelFilter(Collection<? extends Channel> channels) {
        this(true, channels);
    }

    public ChannelFilter(boolean accept, Channel ... channels) {
        this(accept, Arrays.asList(channels));
    }

    public ChannelFilter(boolean accept, Collection<? extends Channel> channels) {
        this.accept = accept;
        this.channels = new HashSet<Channel>(channels);
    }

    public void addChannel(Channel channel) {
        this.channels.add(channel);
    }

    public void removeChannel(Channel channel) {
        this.channels.remove(channel);
    }

    @Override
    public boolean accept(Event<C> event) {
        boolean result;
        if (this.accept) {
            result = false;
            for (Channel channel : this.channels) {
                if (!event.getChannel().flowsInto(channel)) continue;
                result = true;
                break;
            }
        } else {
            result = true;
            for (Channel channel : this.channels) {
                if (event.getChannel().flowsInto(channel)) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

