/*
 * Decompiled with CFR 0.152.
 */
package com.github.leanframeworks.minibus.base.filter;

import com.github.leanframeworks.minibus.api.EventFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractClassFilter<C>
implements EventFilter<C> {
    private final Set<Class<?>> classes = new HashSet();
    private final boolean acceptSubClasses;
    private final boolean acceptNull;

    public AbstractClassFilter(Class<?> ... classes) {
        this(false, classes);
    }

    public AbstractClassFilter(boolean acceptSubClasses, Class<?> ... classes) {
        this(acceptSubClasses, false, classes);
    }

    public AbstractClassFilter(boolean acceptSubClasses, boolean acceptNull, Class<?> ... classes) {
        this.acceptSubClasses = acceptSubClasses;
        this.acceptNull = acceptNull;
        Collections.addAll(this.classes, classes);
    }

    public void addClass(Class<?> clazz) {
        this.classes.add(clazz);
    }

    public void removeClass(Class<?> clazz) {
        this.classes.remove(clazz);
    }

    @Override
    protected boolean accept(Class<?> testedClass) {
        boolean accept;
        if (testedClass == null) {
            accept = this.acceptNull;
        } else if (this.acceptSubClasses) {
            accept = false;
            for (Class<?> clazz : this.classes) {
                if (!clazz.isAssignableFrom(testedClass)) continue;
                accept = true;
                break;
            }
        } else {
            accept = this.classes.contains(testedClass);
        }
        return accept;
    }
}

