/*
 * Decompiled with CFR 0.152.
 */
package com.github.leanframeworks.minibus.base.dispatcher;

import com.github.leanframeworks.minibus.api.Dispatcher;
import com.github.leanframeworks.minibus.api.Event;
import com.github.leanframeworks.minibus.api.EventFilter;
import com.github.leanframeworks.minibus.api.EventHandler;
import com.github.leanframeworks.minibus.api.ExceptionHandler;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDispatcher
implements Dispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDispatcher.class);

    protected final boolean processEventThroughFilterAndHandler(Event<Object> event, EventFilter<Object> filter, EventHandler<Object> handler, Collection<ExceptionHandler> exceptionHandlers) {
        boolean delivered = false;
        try {
            if (filter == null || filter.accept(event)) {
                LOGGER.debug("Handling event '{}' with handler '{}'", event, handler);
                handler.handleEvent(event);
                delivered = true;
            }
        }
        catch (Throwable t) {
            this.processUncheckedException(t, exceptionHandlers, event);
        }
        return delivered;
    }

    protected final void processUndeliveredEvent(Event<Object> event, Collection<EventHandler<Object>> undeliveredEventHandlers, Collection<ExceptionHandler> exceptionHandlers) {
        for (EventHandler<Object> handler : undeliveredEventHandlers) {
            try {
                LOGGER.debug("Processing undelivered event '{}' with undelivered event handler '{}'", event, handler);
                handler.handleEvent(event);
            }
            catch (Throwable t) {
                this.processUncheckedException(t, exceptionHandlers, event);
            }
        }
    }

    protected final void processUncheckedException(Throwable t, Collection<ExceptionHandler> exceptionHandlers, Event<?> event) {
        if (exceptionHandlers == null || exceptionHandlers.isEmpty()) {
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        exceptionHandlers.forEach(h -> h.handleException(t, event));
    }
}

