/*
 * Decompiled with CFR 0.152.
 */
package com.github.leanframeworks.minibus.base.bus;

import com.github.leanframeworks.minibus.api.Channel;
import com.github.leanframeworks.minibus.api.Dispatcher;
import com.github.leanframeworks.minibus.api.Event;
import com.github.leanframeworks.minibus.api.EventFilter;
import com.github.leanframeworks.minibus.api.EventHandler;
import com.github.leanframeworks.minibus.api.Topic;
import com.github.leanframeworks.minibus.base.bus.AbstractEventBus;
import com.github.leanframeworks.minibus.base.bus.SimpleEventBus;
import com.github.leanframeworks.minibus.base.dispatcher.SingleThreadDispatcher;

public final class StaticEventBus {
    private static SimpleEventBus eventBus = new SimpleEventBus(new SingleThreadDispatcher(SingleThreadDispatcher.NestedDispatchStrategy.QUEUE));

    private StaticEventBus() {
    }

    public static void init(Dispatcher dispatcher) {
        eventBus = new SimpleEventBus(dispatcher);
    }

    public static void addUndeliveredEventHandler(EventHandler<Object> handler) {
        eventBus.addUndeliveredEventHandler(handler);
    }

    public static void removeUndeliveredEventHandler(EventHandler<Object> handler) {
        eventBus.removeUndeliveredEventHandler(handler);
    }

    public static <C> int subscribe(Topic<C> topic, EventHandler<? super C> handler) {
        return eventBus.subscribe(topic, handler);
    }

    public static <C> int subscribe(Topic<C> topic, EventFilter<? super C> filter, EventHandler<? super C> handler) {
        return eventBus.subscribe(topic, filter, handler);
    }

    public static <C> int subscribe(Topic<C> topic, Channel channel, EventHandler<? super C> handler) {
        return eventBus.subscribe(topic, channel, handler);
    }

    public static <C> int subscribe(Topic<C> topic, Channel channel, EventFilter<? super C> filter, EventHandler<? super C> handler) {
        return eventBus.subscribe(topic, channel, filter, handler);
    }

    public static void unsubscribe(int id) {
        eventBus.unsubscribe(id);
    }

    public static void unsubscribe(EventHandler<?> handler) {
    }

    public static void unsubscribe(Topic<?> topic) {
    }

    public static void publish(Topic<Void> topic) {
        ((AbstractEventBus)eventBus).publish(topic);
    }

    public static <C> void publish(Topic<C> topic, C content) {
        eventBus.publish(topic, content);
    }

    public static <C> void publish(Topic<C> topic, Channel channel, C content) {
        eventBus.publish(topic, channel, content);
    }

    public static void publish(Event<?> event) {
        eventBus.publish(event);
    }

    public static void dispose() {
        eventBus.dispose();
    }
}

