/*
 * Decompiled with CFR 0.152.
 */
package com.github.leanframeworks.minibus.api;

import com.github.leanframeworks.minibus.api.Channel;
import com.github.leanframeworks.minibus.api.Topic;

public class Event<C> {
    private final Topic<? extends C> topic;
    private final Channel channel;
    private final C content;

    public Event(Topic<? extends C> topic) {
        this(topic, null);
    }

    public Event(Topic<? extends C> topic, C content) {
        this(topic, null, (C)content);
    }

    public Event(Topic<? extends C> topic, Channel channel, C content) {
        this.topic = topic;
        this.channel = channel;
        this.content = content;
    }

    public Topic<? extends C> getTopic() {
        return this.topic;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public C getContent() {
        return this.content;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Event@");
        sb.append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append(this.topic).append('/').append(this.channel);
        if (this.content != null) {
            sb.append(':').append(this.content);
        }
        sb.append(']');
        return sb.toString();
    }
}

