/*
 * Decompiled with CFR 0.152.
 */
package com.github.leandroborgesferreira.loadingbutton.presentation;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Handler;
import com.github.leandroborgesferreira.loadingbutton.customViews.ProgressButton;
import com.github.leandroborgesferreira.loadingbutton.presentation.State;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\fJ\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\fJ\u0006\u0010\u0019\u001a\u00020\fJ\u0006\u0010\u001a\u001a\u00020\fJ\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/github/leandroborgesferreira/loadingbutton/presentation/ProgressButtonPresenter;", "", "view", "Lcom/github/leandroborgesferreira/loadingbutton/customViews/ProgressButton;", "(Lcom/github/leandroborgesferreira/loadingbutton/customViews/ProgressButton;)V", "state", "Lcom/github/leandroborgesferreira/loadingbutton/presentation/State;", "getState", "()Lcom/github/leandroborgesferreira/loadingbutton/presentation/State;", "setState", "(Lcom/github/leandroborgesferreira/loadingbutton/presentation/State;)V", "doneLoadingAnimation", "", "fillColor", "", "bitmap", "Landroid/graphics/Bitmap;", "morphEnd", "morphRevertEnd", "morphRevertStart", "morphStart", "onDraw", "canvas", "Landroid/graphics/Canvas;", "revertAnimation", "startAnimation", "stopAnimation", "validateSetProgress", "", "validateSetProgress$loading_button_android_release", "loading-button-android_release"})
public final class ProgressButtonPresenter {
    @NotNull
    private final ProgressButton view;
    @NotNull
    private State state;

    public ProgressButtonPresenter(@NotNull ProgressButton view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.view = view;
        this.state = State.BEFORE_DRAW;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    public final void morphStart() {
        ProgressButton $this$morphStart_u24lambda_u240 = this.view;
        boolean bl = false;
        $this$morphStart_u24lambda_u240.hideInitialState();
        $this$morphStart_u24lambda_u240.setClickable(false);
        $this$morphStart_u24lambda_u240.setCompoundDrawables(null, null, null, null);
        this.state = State.MORPHING;
    }

    public final void morphEnd() {
        State state;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                new Handler().postDelayed(() -> ProgressButtonPresenter.morphEnd$lambda$1(this), 50L);
                state = State.DONE;
                break;
            }
            case 2: {
                state = State.STOPPED;
                break;
            }
            default: {
                state = State.PROGRESS;
            }
        }
        this.state = state;
    }

    public final void morphRevertStart() {
        this.view.setClickable(false);
        this.state = State.MORPHING;
    }

    public final void morphRevertEnd() {
        this.view.setClickable(true);
        this.view.recoverInitialState();
        this.state = State.IDLE;
    }

    public final void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 3: {
                this.state = State.IDLE;
                this.view.saveInitialState();
                break;
            }
            case 4: {
                this.view.saveInitialState();
                this.view.startMorphAnimation();
                break;
            }
            case 5: {
                this.view.drawProgress(canvas);
                break;
            }
            case 6: {
                this.view.drawDoneAnimation(canvas);
                break;
            }
            default: {
                return;
            }
        }
    }

    public final void startAnimation() {
        if (this.state == State.BEFORE_DRAW) {
            this.state = State.WAITING_PROGRESS;
            return;
        }
        if (this.state != State.IDLE) {
            return;
        }
        this.view.startMorphAnimation();
    }

    public final void stopAnimation() {
        State state;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 5: {
                this.view.stopProgressAnimation();
                state = State.STOPPED;
                break;
            }
            case 4: 
            case 7: {
                state = State.WAITING_TO_STOP;
                break;
            }
            default: {
                state = State.STOPPED;
            }
        }
        this.state = state;
    }

    public final void revertAnimation() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 7: {
                this.view.stopMorphAnimation();
                this.view.startMorphRevertAnimation();
                break;
            }
            case 5: {
                this.view.stopProgressAnimation();
                this.view.startMorphRevertAnimation();
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                this.view.startMorphRevertAnimation();
                break;
            }
            default: {
                return;
            }
        }
    }

    public final void doneLoadingAnimation(int fillColor, @NotNull Bitmap bitmap) {
        State state;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.view.initRevealAnimation(fillColor, bitmap);
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 5: {
                this.view.stopProgressAnimation();
                this.view.startRevealAnimation();
                state = State.DONE;
                break;
            }
            case 7: {
                state = State.WAITING_DONE;
                break;
            }
            case 8: {
                this.view.startRevealAnimation();
                state = State.DONE;
                break;
            }
            default: {
                state = State.DONE;
            }
        }
        this.state = state;
    }

    public final boolean validateSetProgress$loading_button_android_release() {
        return this.state == State.PROGRESS || this.state == State.MORPHING || this.state == State.WAITING_PROGRESS;
    }

    private static final void morphEnd$lambda$1(ProgressButtonPresenter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.view.startRevealAnimation();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.WAITING_DONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.WAITING_TO_STOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.BEFORE_DRAW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.WAITING_PROGRESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.PROGRESS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.DONE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.MORPHING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.STOPPED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

