/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util.event;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;

public class IntEventRegistry {
    private List<IntConsumer> listeners;

    public boolean register(IntConsumer listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IntConsumer>(2);
        } else if (this.listeners.contains(listener)) {
            return false;
        }
        this.listeners.add(listener);
        return true;
    }

    public boolean unregister(IntConsumer listener) {
        return this.listeners != null && this.listeners.remove(listener);
    }

    public void dispatch(int obj) {
        if (this.listeners == null) {
            return;
        }
        for (IntConsumer listener : this.listeners) {
            listener.accept(obj);
        }
    }
}

