/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util.event;

import com.lapissea.util.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class EventRegistry<ObjType> {
    private List<Consumer<ObjType>> listeners;

    public boolean register(@NotNull Consumer<ObjType> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Consumer<ObjType>>(2);
        } else if (this.listeners.contains(listener)) {
            return false;
        }
        this.listeners.add(listener);
        return true;
    }

    public boolean unregister(@NotNull Consumer<ObjType> listener) {
        return this.listeners != null && this.listeners.remove(listener);
    }

    public void dispatch(ObjType obj) {
        if (this.listeners == null) {
            return;
        }
        for (Consumer<ObjType> listener : this.listeners) {
            listener.accept(obj);
        }
    }
}

