/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.DeletingValueHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;

public class WeakValueHashMap<K, V>
extends DeletingValueHashMap<K, V, WeakValueHashMap<K, V>> {
    public WeakValueHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public WeakValueHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public WeakValueHashMap() {
    }

    public WeakValueHashMap(Map<? extends K, ? extends V> m) {
        super(m);
    }

    @Override
    protected DeletingValueHashMap.DeletingValueEntry<K, V> newNode(K key, V value, ReferenceQueue<V> gcQueue) {
        return new WeakEntry(key, value, gcQueue);
    }

    @Override
    public WeakValueHashMap<K, V> copy() {
        return new WeakValueHashMap<K, V>(this);
    }

    private final class WeakEntry<T>
    extends WeakReference<T>
    implements DeletingValueHashMap.DeletingValueEntry<K, T> {
        private final K key;

        private WeakEntry(K key, T value, ReferenceQueue<T> queue) {
            super(value, queue);
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }
    }
}

