/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.LogUtil;
import com.lapissea.util.NotNull;
import com.lapissea.util.Nullable;
import com.lapissea.util.TextUtil;
import com.lapissea.util.function.IntIntConsumer;
import com.lapissea.util.function.UnsafeConsumer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class UtilL {
    public static final double SQRT2D = Math.sqrt(2.0);
    public static final float SQRT2F = (float)SQRT2D;
    public static final byte[] NO_BYTES = new byte[0];
    public static final int MS = 1000;
    public static final int NS = 1000000;
    private static OS OS;
    private static final Pattern NUMERIC_PATTERN;

    public static boolean isArray(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof Class ? ((Class)object).isArray() : object.getClass().isArray();
    }

    public static boolean TRUE() {
        return true;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleep(long millis, float nanoUnit) {
        UtilL.sleep(millis, (int)(1000000.0f * nanoUnit));
    }

    public static void sleep(float millis) {
        UtilL.sleep((long)millis, millis % 1.0f);
    }

    public static void sleep(double millis) {
        UtilL.sleep((long)millis, (float)(millis % 1.0));
    }

    public static void sleep(long millis, int nanos) {
        try {
            Thread.sleep(millis, nanos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> Stream<T> stream(final @NotNull Enumeration<T> e) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(@NotNull Consumer<? super T> action) {
                if (e.hasMoreElements()) {
                    action.accept(e.nextElement());
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(@NotNull Consumer<? super T> action) {
                while (e.hasMoreElements()) {
                    action.accept(e.nextElement());
                }
            }
        }, false);
    }

    @Deprecated
    public static <T> T[] array(@NotNull List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        ?[] a = UtilL.array(list.get(0).getClass(), 1);
        return list.toArray(a);
    }

    @Deprecated
    public static <T> T[] array(@NotNull List<T> list, @NotNull T[] arr) {
        if (list.isEmpty()) {
            return null;
        }
        Object[] a = arr.length == list.size() ? arr : UtilL.array(list.get(0).getClass(), list.size());
        return list.toArray(a);
    }

    public static <K, V> void doAndClear(@NotNull Map<K, V> collection, @NotNull BiConsumer<K, V> toDo) {
        if (collection.isEmpty()) {
            return;
        }
        collection.forEach(toDo);
        collection.clear();
    }

    public static <T> void doAndClear(@NotNull Collection<T> collection, @NotNull Consumer<T> toDo) {
        if (collection.isEmpty()) {
            return;
        }
        for (T t : collection) {
            toDo.accept(t);
        }
        collection.clear();
    }

    public static void startDaemonThread(@NotNull Runnable run, @NotNull String name) {
        Thread t = new Thread(run, name);
        t.setDaemon(true);
        t.start();
    }

    @NotNull
    public static <T> T[] array(Class<T> componentType, int length) {
        return (Object[])Array.newInstance(componentType, length);
    }

    @NotNull
    public static <T> T[] array(T[] arr, int newLength) {
        return UtilL.array(arr.getClass().getComponentType(), newLength);
    }

    public static boolean instanceOf(@NotNull Class<?> left, @NotNull Class<?> right) {
        if (left == right) {
            return true;
        }
        return right.isAssignableFrom(left);
    }

    public static boolean instanceOf(@Nullable Object left, @NotNull Class<?> right) {
        return left != null && UtilL.instanceOf(left.getClass(), right);
    }

    public static boolean instanceOf(@NotNull Class<?> left, @NotNull Object right) {
        return UtilL.instanceOf(left, right.getClass());
    }

    public static boolean instanceOf(@NotNull Object left, @NotNull Object right) {
        return UtilL.instanceOf(left.getClass(), right.getClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <T> T fromString(@NotNull String s) {
        byte[] data = s.getBytes();
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));){
            Object object = ois.readObject();
            return (T)object;
        }
        catch (Exception e) {
            throw UtilL.uncheckedThrow(e);
        }
    }

    @NotNull
    public static String toString(@NotNull Serializable o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        oos.close();
        return new String(baos.toByteArray());
    }

    public static void closeSilenty(@NotNull Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    public static List<Field> getAllFields(@NotNull Class<?> type) {
        return UtilL.getAllFields(new ArrayList<Field>(), type);
    }

    @NotNull
    public static List<Field> getAllFields(@NotNull List<Field> fields, @NotNull Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            UtilL.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    @NotNull
    public static Field getField(@NotNull Class<?> type, String name) throws NoSuchFieldException {
        try {
            return type.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            if (type == Object.class) {
                throw e;
            }
            return UtilL.getField(type.getSuperclass(), name);
        }
    }

    @NotNull
    public static String compress(@NotNull String data) {
        try {
            return new String(UtilL.compress(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static byte[] compress(@Nullable byte[] data) {
        try {
            if (data == null || data.length == 0) {
                return NO_BYTES;
            }
            ByteArrayOutputStream obj = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(obj);
            gzip.write(data);
            gzip.close();
            return obj.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static String decompress(@Nullable byte[] compressed) {
        try {
            StringBuilder outStr = new StringBuilder();
            if (compressed == null || compressed.length == 0) {
                return "";
            }
            if (UtilL.isCompressed(compressed)) {
                String line;
                GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(compressed));
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8));
                while ((line = bufferedReader.readLine()) != null) {
                    outStr.append(line);
                }
                return outStr.toString();
            }
            return new String(compressed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isCompressed(byte[] compressed) {
        return compressed[0] == 31 && compressed[1] == -117;
    }

    public static Class<?> findObjectClosestCommonSuper(@NotNull Collection<?> objects) {
        return UtilL.findObjectClosestCommonSuper(objects.stream());
    }

    public static Class<?> findObjectClosestCommonSuper(@NotNull Stream<?> objects) {
        return UtilL.findClosestCommonSuper(objects.filter(Objects::nonNull).map(Object::getClass));
    }

    public static Class<?> findClosestCommonSuper(@NotNull Collection<Class<?>> classes) {
        return UtilL.findClosestCommonSuper(classes.stream());
    }

    public static Class<?> findClosestCommonSuper(@NotNull Stream<Class<?>> classes) {
        return classes.reduce(UtilL::findClosestCommonSuper).orElse(Object.class);
    }

    @NotNull
    public static Class<?> findClosestCommonSuper(@NotNull Class<?> a, @NotNull Class<?> b) {
        if (a == b) {
            return a;
        }
        if (a == Object.class || b == Object.class) {
            return Object.class;
        }
        Class<?> s = a;
        while (!s.isAssignableFrom(b)) {
            s = s.getSuperclass();
        }
        return s;
    }

    public static void iterate(Object data, @NotNull Consumer<Object> consumer) {
        UtilL.iterate(data, Object.class, consumer);
    }

    public static <T> void iterate(@Nullable Object data, @NotNull Class<T> type, @NotNull Consumer<T> consumer) {
        Class<?> typeTx;
        if (data == null) {
            return;
        }
        if (UtilL.instanceOf(data, type)) {
            consumer.accept(data);
        } else if (data instanceof Iterable) {
            ((Iterable)data).forEach(mat -> consumer.accept(mat));
        } else if (data.getClass().isArray() && UtilL.instanceOf(typeTx = data.getClass().getComponentType(), type)) {
            for (Object tx : (Object[])data) {
                consumer.accept(tx);
            }
        }
    }

    @NotNull
    public static byte[] readAll(@NotNull InputStream is) {
        ByteArrayOutputStream buffer;
        try {
            int nRead;
            buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return buffer.toByteArray();
    }

    public static boolean emptyOrNull(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static void runWhile(@NotNull BooleanSupplier when, @NotNull Runnable what) {
        while (when.getAsBoolean()) {
            what.run();
        }
    }

    public static void runWhileThread(@NotNull String threadName, @NotNull BooleanSupplier when, @NotNull Runnable what) {
        new Thread(() -> UtilL.runWhile(when, what), threadName).start();
    }

    public static void fileLines(@NotNull InputStream stream, @NotNull UnsafeConsumer<String, IOException> cons) throws IOException {
        String line;
        BufferedReader b = new BufferedReader(new InputStreamReader(stream, StandardCharsets.ISO_8859_1));
        while ((line = b.readLine()) != null) {
            cons.accept(line);
        }
    }

    public static <T> void forEach(@NotNull T[] ts, @NotNull Consumer<T> consumer) {
        for (T t : ts) {
            consumer.accept(t);
        }
    }

    public static void sleepUntil(@NotNull BooleanSupplier checkUntil) {
        UtilL.sleepUntil(checkUntil, 1L);
    }

    public static void sleepUntil(@NotNull BooleanSupplier checkUntil, long ms) {
        while (!checkUntil.getAsBoolean()) {
            UtilL.sleep(ms);
        }
    }

    public static void sleepUntil(@NotNull BooleanSupplier checkUntil, long ms, int ns) {
        while (!checkUntil.getAsBoolean()) {
            UtilL.sleep(ms, ns);
        }
    }

    public static void sleepUntil(@NotNull BooleanSupplier checkUntil, long ms, float nsUnit) {
        while (!checkUntil.getAsBoolean()) {
            UtilL.sleep(ms, (int)(1000000.0f * nsUnit));
        }
    }

    public static void sleepWhile(@NotNull BooleanSupplier checkWhile) {
        UtilL.sleepWhile(checkWhile, 1L);
    }

    public static void sleepWhile(@NotNull BooleanSupplier checkWhile, long ms) {
        while (checkWhile.getAsBoolean()) {
            UtilL.sleep(ms);
        }
    }

    public static void sleepWhile(@NotNull BooleanSupplier checkWhile, long ms, int ns) {
        while (checkWhile.getAsBoolean()) {
            UtilL.sleep(ms, ns);
        }
    }

    public static void sleepWhile(@NotNull BooleanSupplier checkWhile, long ms, float nsUnit) {
        while (checkWhile.getAsBoolean()) {
            UtilL.sleep(ms, (int)(1000000.0f * nsUnit));
        }
    }

    public static <T> T waitForNotNull(@NotNull Supplier<T> getter, long ms, float nsUnit) {
        T val;
        while ((val = getter.get()) == null) {
            UtilL.sleep(ms, (int)(1000000.0f * nsUnit));
        }
        return val;
    }

    public static <T> T waitForNotNull(@NotNull Supplier<T> getter, long ms) {
        T val;
        while ((val = getter.get()) == null) {
            UtilL.sleep(ms);
        }
        return val;
    }

    public static <T> T waitForNotNull(@NotNull Supplier<T> getter) {
        return UtilL.waitForNotNull(getter, 1L);
    }

    public static InputStreamSilent silentClose(InputStream resource) {
        return new InputStreamSilent(resource);
    }

    public static String before(@NotNull String toSubstring, char marker) {
        int pos = toSubstring.lastIndexOf(marker);
        if (pos == -1) {
            return null;
        }
        return toSubstring.substring(0, pos);
    }

    public static String after(@NotNull String toSubstring, char marker) {
        int pos = toSubstring.lastIndexOf(marker);
        if (pos == -1) {
            return null;
        }
        return toSubstring.substring(pos + 1);
    }

    @NotNull
    public static <T extends Throwable> RuntimeException uncheckedThrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static <T> Stream<T> stream(@NotNull Iterable<T> it) {
        return UtilL.stream(it, false);
    }

    public static <T> Stream<T> stream(@NotNull Iterable<T> it, boolean parallel) {
        return StreamSupport.stream(it.spliterator(), false);
    }

    public static <T> Stream<T> stream(@NotNull Iterator<T> it) {
        return UtilL.stream(it, false);
    }

    public static <T> Stream<T> stream(@NotNull Iterator<T> it, boolean parallel) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 256), parallel);
    }

    @NotNull
    public static <In, Out> Out[] convert(@NotNull Collection<In> in, Class<Out> outType, @NotNull Function<In, Out> converter) {
        Out[] out = UtilL.array(outType, in.size());
        int i = 0;
        for (In anIn : in) {
            out[i++] = converter.apply(anIn);
        }
        return out;
    }

    @NotNull
    public static <In, Out> Out[] convert(@NotNull Collection<In> in, IntFunction<Out[]> newArray, @NotNull Function<In, Out> converter) {
        Out[] out = newArray.apply(in.size());
        int i = 0;
        for (In anIn : in) {
            out[i++] = converter.apply(anIn);
        }
        return out;
    }

    @NotNull
    public static <Out> Out[] convert(@NotNull int[] in, Class<Out> outType, @NotNull IntFunction<Out> converter) {
        Out[] out = UtilL.array(outType, in.length);
        for (int i = 0; i < in.length; ++i) {
            out[i] = converter.apply(in[i]);
        }
        return out;
    }

    @NotNull
    public static <In, Out> Out[] convert(@NotNull In[] in, Class<Out> outType, @NotNull Function<In, Out> converter) {
        Out[] out = UtilL.array(outType, in.length);
        for (int i = 0; i < in.length; ++i) {
            out[i] = converter.apply(in[i]);
        }
        return out;
    }

    public static <In, Out> Out[] convert(@NotNull In[] in, @NotNull IntFunction<Out[]> array, @NotNull Function<In, Out> converter) {
        Out[] out = array.apply(in.length);
        for (int i = 0; i < in.length; ++i) {
            out[i] = converter.apply(in[i]);
        }
        return out;
    }

    public static <In, Out> Out[] convert(@NotNull In[] in, @NotNull Out[] dest, @NotNull Function<In, Out> converter) {
        for (int i = 0; i < in.length; ++i) {
            dest[i] = converter.apply(in[i]);
        }
        return dest;
    }

    public static <Out> Out[] convert(@NotNull int[] in, @NotNull IntFunction<Out[]> array, @NotNull IntFunction<Out> converter) {
        Out[] out = array.apply(in.length);
        for (int i = 0; i < in.length; ++i) {
            out[i] = converter.apply(in[i]);
        }
        return out;
    }

    public static <T> boolean contains(@NotNull T[] array, @Nullable T what) {
        if (what == null) {
            for (T t : array) {
                if (t != null) continue;
                return true;
            }
            return false;
        }
        for (T t : array) {
            if (t == null || !t.equals(what)) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(@NotNull int[] array, int what) {
        return UtilL.indexOf(array, 0, what);
    }

    public static int indexOf(@NotNull int[] array, int start, int what) {
        while (start < array.length) {
            if (array[start] == what) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    public static boolean contains(@NotNull int[] array, int what) {
        for (int t : array) {
            if (t != what) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static RuntimeException exitWithErrorMsg(Object ... msg) {
        String msg0 = TextUtil.toString(msg);
        LogUtil.printlnEr((Object)msg0);
        System.exit(-1);
        return new RuntimeException(msg0);
    }

    @NotNull
    public static byte[] longToBytes(long l) {
        byte[] dest = new byte[8];
        return UtilL.longToBytes(dest, l);
    }

    @NotNull
    public static byte[] longToBytes(@NotNull byte[] dest, long l) {
        return UtilL.longToBytes(dest, 0, l);
    }

    @NotNull
    public static byte[] longToBytes(@NotNull byte[] dest, int destStart, long l) {
        for (int i = 7; i >= 0; --i) {
            dest[destStart + i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return dest;
    }

    public static long bytesToLong(@NotNull byte[] b) {
        return UtilL.bytesToLong(0, b);
    }

    public static long bytesToLong(int start, @NotNull byte[] b) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[start + i] & 0xFF);
        }
        return result;
    }

    @NotNull
    public static <In1, In2, Out> List<Out> combine(@NotNull List<In1> in1, @NotNull List<In2> in2, @NotNull BiFunction<In1, In2, Out> converter) {
        int size = Math.min(in1.size(), in2.size());
        ArrayList<Out> out = new ArrayList<Out>(size);
        for (int i = 0; i < size; ++i) {
            out.add(converter.apply(in1.get(i), in2.get(i)));
        }
        return out;
    }

    @NotNull
    public static <In1, In2, Out> Out[] combine(@NotNull In1[] in1, @NotNull In2[] in2, @NotNull IntFunction<Out[]> array, @NotNull BiFunction<In1, In2, Out> converter) {
        int size = Math.min(in1.length, in2.length);
        Out[] out = array.apply(size);
        for (int i = 0; i < size; ++i) {
            out[i] = converter.apply(in1[i], in2[i]);
        }
        return out;
    }

    @NotNull
    public static <T> T[] concatenate(@NotNull T[] a, @NotNull T[] b) {
        int aLen = a.length;
        int bLen = b.length;
        ?[] c = UtilL.array(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static void parallelFor(@NotNull int[] array, int threads, @NotNull IntIntConsumer consumer) {
        if (threads <= 1) {
            for (int i = 0; i < array.length; ++i) {
                consumer.accept(i, array[i]);
            }
            return;
        }
        int chunkSize = array.length / threads;
        IntStream.range(0, threads).parallel().forEach(chunkId -> {
            int i;
            int j = Math.min(i + chunkSize, array.length);
            for (i = chunkId * chunkSize; i < j; ++i) {
                consumer.accept(i, array[i]);
            }
        });
    }

    public static boolean checkFlag(byte flags, byte flag) {
        return (flags & flag) == flag;
    }

    public static boolean checkFlag(short flags, short flag) {
        return (flags & flag) == flag;
    }

    public static boolean checkFlag(int flags, int flag) {
        return (flags & flag) == flag;
    }

    public static boolean checkFlag(long flags, long flag) {
        return (flags & flag) == flag;
    }

    @NotNull
    public static UUID hashMD5(@NotNull ByteBuffer input) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(input);
            return UUID.nameUUIDFromBytes(md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw UtilL.uncheckedThrow(e);
        }
    }

    @NotNull
    public static UUID hashMD5(@NotNull String input) {
        return UtilL.hashMD5(input.getBytes());
    }

    @NotNull
    public static UUID hashMD5(@NotNull byte[] input) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            return UUID.nameUUIDFromBytes(md5.digest(input));
        }
        catch (NoSuchAlgorithmException e) {
            throw UtilL.uncheckedThrow(e);
        }
    }

    @NotNull
    public static String getAppData() {
        String path;
        String OS2 = System.getProperty("os.name").toUpperCase();
        switch (UtilL.getOS()) {
            case WINDOWS: {
                path = System.getenv("APPDATA");
                break;
            }
            case LINUX: {
                path = System.getProperty("user.home");
                break;
            }
            case MACOS: {
                path = System.getProperty("user.home") + "/Library/";
                break;
            }
            default: {
                path = System.getProperty("user.dir");
            }
        }
        return path + "/";
    }

    public static <T> T any(T t1, T t2) {
        return t1 != null ? t1 : t2;
    }

    @NotNull
    public static String fileExtension(@NotNull String fileName) {
        int p;
        int i = fileName.lastIndexOf(46);
        if (i > (p = Math.max(fileName.lastIndexOf(47), fileName.lastIndexOf(92)))) {
            return fileName.substring(i + 1);
        }
        return "";
    }

    public static int bytesToInt(byte[] bytes, int offset) {
        int ret = 0;
        for (int i = 0; i < 4 && i + offset < bytes.length; ++i) {
            ret <<= 8;
            ret |= bytes[i + offset] & 0xFF;
        }
        return ret;
    }

    public static synchronized OS getOS() {
        if (OS == null) {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("win")) {
                OS = com.lapissea.util.UtilL$OS.WINDOWS;
            } else if (os.contains("linux")) {
                OS = com.lapissea.util.UtilL$OS.LINUX;
            } else if (os.contains("mac")) {
                OS = com.lapissea.util.UtilL$OS.MACOS;
            }
        }
        return OS;
    }

    public static boolean isInJar(Class<?> clazz) {
        return new File(clazz.getProtectionDomain().getCodeSource().getLocation().getPath()).getName().endsWith(".jar");
    }

    public static <T extends Comparable<T>> int addRemainSorted(List<T> list, T value) {
        if (list.isEmpty()) {
            list.add(value);
            return 0;
        }
        if (value.compareTo((Comparable)((Comparable)list.get(0))) < 0) {
            list.add(0, value);
            return 0;
        }
        if (value.compareTo((Comparable)((Comparable)list.get(list.size() - 1))) > 0) {
            list.add(value);
            return list.size();
        }
        int lo = 0;
        int hi = list.size() - 1;
        while (lo <= hi) {
            int mid = (hi + lo) / 2;
            int comp = value.compareTo((Comparable)((Comparable)list.get(mid)));
            if (comp < 0) {
                hi = mid - 1;
                continue;
            }
            if (comp > 0) {
                lo = mid + 1;
                continue;
            }
            list.add(mid, value);
            return mid;
        }
        list.add(lo, value);
        return lo;
    }

    public static void Assert(boolean condition) {
        if (!condition) {
            throw new AssertionError();
        }
    }

    public static void Assert(boolean condition, Object ... message) {
        if (!condition) {
            throw new AssertionError((Object)TextUtil.toString(message));
        }
    }

    public static void Assert(boolean condition, String message) {
        if (!condition) {
            throw new AssertionError((Object)message);
        }
    }

    public static RuntimeException sysExit(int exitCode) throws RuntimeException {
        System.exit(0);
        throw new RuntimeException();
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> generateEnumMap(@NotNull Class<K> enumType, @NotNull Function<K, V> generator) {
        EnumMap<Enum, V> map = new EnumMap<Enum, V>(enumType);
        for (Enum k : (Enum[])enumType.getEnumConstants()) {
            map.put(k, generator.apply(k));
        }
        return map;
    }

    public static boolean isNumeric(CharSequence str) {
        return NUMERIC_PATTERN.matcher(str).matches();
    }

    public static <T extends Annotation> Class<T> getAnnotationInterface(T annotation) {
        return UtilL.getAnnotationInterface(annotation.getClass());
    }

    public static <T extends Annotation> Class<T> getAnnotationInterface(Class<? extends T> proxyClass) {
        return Arrays.stream(proxyClass.getInterfaces()).filter(c -> UtilL.instanceOf(proxyClass, Annotation.class)).findAny().orElseThrow(() -> new IllegalArgumentException(proxyClass + " not an annotation"));
    }

    public static <T> T sysPropertyByClass(Class<?> targetClass, String varName, T defaultValue, Function<String, T> map) {
        return UtilL.sysPropertyByClass(targetClass, varName).map(map).orElse(defaultValue);
    }

    public static Optional<String> sysPropertyByClass(Class<?> targetClass, String varName) {
        return Optional.ofNullable(System.getProperty(targetClass.getName() + (varName == null || varName.isEmpty() ? "" : "." + varName)));
    }

    static {
        NUMERIC_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");
    }

    public static class InputStreamSilent
    extends InputStream {
        public final InputStream parent;

        public InputStreamSilent(InputStream parent) {
            this.parent = parent;
        }

        @Override
        public void close() {
            UtilL.closeSilenty(this.parent);
        }

        @Override
        public int read() throws IOException {
            return this.parent.read();
        }

        @Override
        public int read(@NotNull byte[] b) throws IOException {
            return this.parent.read(b);
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            return this.parent.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.parent.available();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.parent.skip(n);
        }

        @Override
        public boolean markSupported() {
            return this.parent.markSupported();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.parent.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.parent.reset();
        }

        public String toString() {
            return this.parent.toString();
        }
    }

    public static enum OS {
        WINDOWS("dll"),
        LINUX("so"),
        MACOS("jnilib");

        public final String nativeLibExtension;

        private OS(String nativeLibExtension) {
            this.nativeLibExtension = nativeLibExtension;
        }
    }
}

