/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.ArrayViewList;
import com.lapissea.util.NotNull;
import com.lapissea.util.Nullable;
import com.lapissea.util.UtilL;
import com.lapissea.util.ZeroArrays;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class TextUtil {
    public static final String NEW_LINE = System.lineSeparator();
    public static boolean JSON_NULL_PRINT = false;
    public static boolean USE_SHORT_IN_COLLECTIONS = true;
    public static boolean IMPLY_TO_STRINGS = true;
    public static boolean TABLE_BOOLEAN_TO_CHECK = true;
    public static final CustomToString CUSTOM_TO_STRINGS = new CustomToString(TextUtil::enhancedToString);
    public static final CustomToString SHORT_TO_STRINGS = new CustomToString(CUSTOM_TO_STRINGS::toString);
    public static final CustomToString IN_TABLE_TO_STRINGS = new CustomToString(SHORT_TO_STRINGS::toString);
    private static final Predicate<Object> IS_RECORD;
    private static final ThreadLocal<Deque<Object>> JSON_CALL_STACK;
    private static final ThreadLocal<Deque<Object>> PRETTY_JSON_CALL_STACK;
    private static final String TAB = "    ";
    private static final int MAX_SINGLE_LINE_ARRAY = 150;
    private static final Map<Class<?>, List<String>> OVERRIDE_FUNCTION_CACHE;
    private static final char[] HEX_ARRAY;

    @Deprecated
    public static <T> void registerCustomToString(@NotNull Class<T> type, @NotNull Function<T, String> toString) {
        CUSTOM_TO_STRINGS.register(type, toString);
    }

    @Deprecated
    public static <T> void registerCustomToString(@NotNull Predicate<Class<T>> canStringify, @NotNull Function<T, String> toString) {
        CUSTOM_TO_STRINGS.register(canStringify, toString);
    }

    @NotNull
    public static String toStringArray(@Nullable Object[] arr) {
        if (arr == null) {
            return "null";
        }
        StringBuilder print = new StringBuilder("[");
        for (int i = 0; i < arr.length; ++i) {
            Object a = arr[i];
            if (UtilL.isArray(a)) {
                print.append(TextUtil.unknownArrayToString(a));
            } else {
                print.append(TextUtil.toString(a));
            }
            if (i == arr.length - 1) continue;
            print.append(", ");
        }
        return print.append("]").toString();
    }

    public static Map<String, Object> mapObjectValues(Object o) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        TextUtil.mapObjectValues(o, map::put);
        return map;
    }

    private static boolean isRecord(Object obj) {
        return IS_RECORD.test(obj);
    }

    public static void mapObjectValues(Object o, @NotNull BiConsumer<String, Object> push) {
        String name;
        if (o == null) {
            return;
        }
        Class<?> c = o.getClass();
        boolean isAnnotation = o instanceof Annotation;
        if (isAnnotation || TextUtil.isRecord(o)) {
            for (Method method : (isAnnotation ? ((Annotation)o).annotationType() : c).getMethods()) {
                if (method.getParameterCount() != 0 || Modifier.isStatic(method.getModifiers()) || (isAnnotation ? method.getName().equals("annotationType") : method.getDeclaringClass() != c)) continue;
                try {
                    c.getSuperclass().getMethod(method.getName(), new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method.setAccessible(true);
                        push.accept(method.getName(), method.invoke(o, new Object[0]));
                    }
                    catch (Throwable e) {
                        push.accept(method.getName(), "<read error>");
                    }
                }
            }
            return;
        }
        for (Method method : c.getMethods()) {
            int prefix;
            if (method.getParameterCount() != 0 || Modifier.isPrivate(method.getModifiers()) || Modifier.isProtected(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getReturnType() == Void.TYPE || (name = method.getName()).length() <= 4 || method.getDeclaringClass() == Object.class) continue;
            if ((method.getReturnType() == Boolean.class || method.getReturnType() == Boolean.TYPE) && name.startsWith("is")) {
                prefix = 2;
            } else {
                if (!name.startsWith("get")) continue;
                prefix = 3;
            }
            char ch = name.charAt(prefix);
            if (!Character.isAlphabetic(ch) || !Character.isUpperCase(ch)) continue;
            name = TextUtil.firstToLowerCase(name.substring(prefix));
            try {
                method.setAccessible(true);
                push.accept(name, method.invoke(o, new Object[0]));
            }
            catch (Throwable e) {
                push.accept(name, "<read error>");
            }
        }
        for (AccessibleObject accessibleObject : c.getFields()) {
            if (Modifier.isPrivate(((Field)accessibleObject).getModifiers()) || Modifier.isProtected(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers()) || Modifier.isTransient(((Field)accessibleObject).getModifiers())) continue;
            name = ((Field)accessibleObject).getName();
            try {
                ((Field)accessibleObject).setAccessible(true);
                push.accept(name, ((Field)accessibleObject).get(o));
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public static String unknownArrayToString(@Nullable Object arr) {
        if (arr == null) {
            return "null";
        }
        if (arr instanceof boolean[]) {
            return Arrays.toString((boolean[])arr);
        }
        if (arr instanceof float[]) {
            return Arrays.toString((float[])arr);
        }
        if (arr instanceof byte[]) {
            byte[] ba = (byte[])arr;
            if (ba.length == 0) {
                return "[]";
            }
            int iMax = ba.length - 1;
            StringBuilder b = new StringBuilder();
            b.append('[');
            int i = 0;
            while (true) {
                b.append(ba[i] & 0xFF);
                if (i == iMax) {
                    return b.append(']').toString();
                }
                b.append(", ");
                ++i;
            }
        }
        if (arr instanceof int[]) {
            return Arrays.toString((int[])arr);
        }
        if (arr instanceof long[]) {
            return Arrays.toString((long[])arr);
        }
        if (arr instanceof short[]) {
            return Arrays.toString((short[])arr);
        }
        if (arr instanceof char[]) {
            return Arrays.toString((char[])arr);
        }
        if (arr instanceof double[]) {
            return Arrays.toString((double[])arr);
        }
        int len = Array.getLength(arr);
        if (len == 0) {
            return "[]";
        }
        int iMax = len - 1;
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(TextUtil.toString(Array.get(arr, i)));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    @NotNull
    public static String toString(Object ... objs) {
        if (objs == null) {
            return "null";
        }
        StringBuilder print = new StringBuilder();
        for (int i = 0; i < objs.length; ++i) {
            Object a = objs[i];
            if (UtilL.isArray(a)) {
                print.append(TextUtil.unknownArrayToString(a));
            } else {
                print.append(TextUtil.toString(a));
            }
            if (i == objs.length - 1) continue;
            print.append(' ');
        }
        return print.toString();
    }

    @NotNull
    public static String toString(@Nullable Object obj) {
        return CUSTOM_TO_STRINGS.toString(obj);
    }

    @NotNull
    public static String toShortString(@Nullable Object obj) {
        return SHORT_TO_STRINGS.toString(obj);
    }

    @NotNull
    public static String toTableString(@Nullable Object obj) {
        return IN_TABLE_TO_STRINGS.toString(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toNamedJson(Object o) {
        Deque<Object> callStack = JSON_CALL_STACK.get();
        callStack.push(o);
        try {
            if (o == null) {
                String string = "null";
                return string;
            }
            if (o instanceof Number) {
                String string = o.toString();
                return string;
            }
            Class<?> c = o.getClass();
            if (c == Boolean.class) {
                String string = o.toString();
                return string;
            }
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            TextUtil.mapObjectValues(o, (name, obj) -> {
                if (!JSON_NULL_PRINT && obj == null) {
                    return;
                }
                if (callStack.contains(obj)) {
                    obj = "<circular reference of " + obj.getClass().getSimpleName() + ">";
                }
                if (obj instanceof String) {
                    obj = "\"" + ((String)obj).replace("\n", "\\n").replace("\r", "\\r") + '\"';
                }
                data.put((String)name, TextUtil.toString(obj));
            });
            if (data.isEmpty()) {
                data.put("hash", o.hashCode() + "");
            }
            String string = c.getSimpleName() + "{" + data.entrySet().stream().map(e -> TextUtil.toString(e.getKey()) + ": " + TextUtil.toString(e.getValue())).collect(Collectors.joining(", ")) + "}";
            return string;
        }
        finally {
            callStack.pop();
        }
    }

    public static String toNamedPrettyJson(Object o) {
        return TextUtil.toNamedPrettyJson(o, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toNamedPrettyJson(Object o, boolean tryTabulatingArrays) {
        if (o == null) {
            return "null";
        }
        Deque<Object> callStack = PRETTY_JSON_CALL_STACK.get();
        if (callStack.contains(o)) {
            return "<circular reference of " + o.getClass().getSimpleName() + ">";
        }
        if (o instanceof CharSequence || o instanceof Number) {
            return TextUtil.toString((Object)o);
        }
        if (o instanceof Class) {
            return ((Class)((Object)o)).getSimpleName();
        }
        Class<?> c = o.getClass();
        if (c == Boolean.class) {
            return ((Object)o).toString();
        }
        callStack.push(o);
        try {
            Object l;
            Object data2;
            Object iter;
            Predicate<Object> shouldStringify = o1 -> TextUtil.overridesToString(o1.getClass()) && !(o1 instanceof Collection) && !(o1 instanceof BaseStream) && !(o1 instanceof Map) && !TextUtil.isRecord(o1);
            Function<String, String> tabulate = s -> s.replace("\n", "\n    ");
            Function<Object, String> lazyTabbedPrettyJson = o1 -> (String)tabulate.apply(shouldStringify.test(o1) ? TextUtil.toString(o1) : TextUtil.toNamedPrettyJson(o1, tryTabulatingArrays));
            Function<Object, String> lazyTabbedJson = o1 -> (String)tabulate.apply(shouldStringify.test(o1) ? TextUtil.toString(o1) : TextUtil.toNamedJson(o1));
            if (c.isArray()) {
                final LinkedList oarr = o;
                o = new AbstractList<Object>(){

                    @Override
                    public int size() {
                        return Array.getLength(oarr);
                    }

                    @Override
                    public Object get(int index) {
                        return Array.get(oarr, index);
                    }
                };
            }
            if (o instanceof BaseStream) {
                try (BaseStream stream = (BaseStream)((Object)o);){
                    try {
                        iter = stream.iterator();
                        data2 = new LinkedList();
                        iter.forEachRemaining(arg_0 -> data2.add(arg_0));
                        o = data2;
                    }
                    catch (IllegalStateException data2) {
                        // empty catch block
                    }
                }
            }
            if (o instanceof Collection) {
                Class<?> unifyingClass;
                l = o;
                if (l.isEmpty()) {
                    iter = "[]";
                    return iter;
                }
                if (tryTabulatingArrays && (unifyingClass = UtilL.findObjectClosestCommonSuper(l)) != Object.class && !TextUtil.overridesToString(unifyingClass)) {
                    data2 = "{{\n" + TextUtil.toTable(" " + unifyingClass.getSimpleName() + " ", l.stream().map(TextUtil::mapObjectValues).collect(Collectors.toList())) + "}}";
                    return data2;
                }
                Function<Function, String> arrayToString = arg_0 -> TextUtil.lambda$toNamedPrettyJson$35((Collection)l, arg_0);
                String contents = arrayToString.apply(lazyTabbedPrettyJson);
                if (!contents.isEmpty() && contents.length() < 150) {
                    contents = arrayToString.apply(lazyTabbedJson);
                }
                String string = "[\n    " + contents + "\n]";
                return string;
            }
            if (o instanceof Map) {
                l = (Map)((Object)o);
                StringBuilder sb = new StringBuilder("[\n");
                for (Map.Entry o12 : l.entrySet()) {
                    sb.append(TAB).append(TextUtil.toString(o12.getKey())).append(": ").append(lazyTabbedPrettyJson.apply(o12.getValue())).append(",\n");
                }
                String string = sb.append(']').toString();
                return string;
            }
            LinkedHashMap<String, String> data3 = new LinkedHashMap<String, String>();
            TextUtil.mapObjectValues(o, (name, obj) -> {
                if (!JSON_NULL_PRINT && obj == null) {
                    return;
                }
                if (callStack.contains(obj)) {
                    obj = "<circular reference of " + obj.getClass().getSimpleName() + ">";
                }
                if (obj instanceof String) {
                    obj = "\"" + ((String)obj).replace("\n", "\\n").replace("\r", "\\r") + '\"';
                }
                data3.put((String)name, (String)lazyTabbedPrettyJson.apply(obj));
            });
            if (data3.isEmpty()) {
                data3.put("hash", ((Object)o).hashCode() + "");
            }
            String string = c.getSimpleName() + "{\n" + TAB + data3.entrySet().stream().map(e -> TextUtil.toString(e.getKey()) + ": " + (String)lazyTabbedPrettyJson.apply(e.getValue())).collect(Collectors.joining(",\n    ")) + "\n}";
            return string;
        }
        finally {
            callStack.pop();
        }
    }

    public static String toTable(String title, Object ... rows) {
        return TextUtil.toTable(title, Arrays.asList(rows));
    }

    public static String toTable(Object ... rows) {
        return TextUtil.toTable(Arrays.asList(rows));
    }

    public static String toTable(Stream<?> rows) {
        return TextUtil.toTable(rows.toArray());
    }

    public static String toTable(Iterable<?> rows) {
        Class<?> type = UtilL.findObjectClosestCommonSuper(StreamSupport.stream(rows.spliterator(), false));
        return TextUtil.toTable(type == Object.class ? "" : type.getSimpleName(), rows);
    }

    public static String toTable(String title, Iterable<?> rows) {
        ArrayList<Map<String, Object>> rowsExplicit = new ArrayList<Map<String, Object>>(rows instanceof Collection ? ((Collection)rows).size() : 16);
        for (Object obj : rows) {
            rowsExplicit.add(TextUtil.mapObjectValues(obj));
        }
        return TextUtil.toTable(title, rowsExplicit);
    }

    public static String toTable(Collection<? extends Map<?, ?>> rows) {
        return TextUtil.toTable("", rows);
    }

    public static String toTable(String title, Collection<? extends Map<?, ?>> rows) {
        Function<Object, String> toSingleLineString = o -> {
            if ("null".equals(o)) {
                return "";
            }
            String nonTabbed = IN_TABLE_TO_STRINGS.toString(o);
            StringBuilder tabbed = new StringBuilder(nonTabbed.length() + 4);
            block5: for (int i = 0; i < nonTabbed.length(); ++i) {
                char c = nonTabbed.charAt(i);
                switch (c) {
                    case '\n': {
                        tabbed.append("\\n");
                        continue block5;
                    }
                    case '\r': {
                        tabbed.append("\\r");
                        continue block5;
                    }
                    case '\t': {
                        tabbed.append(TextUtil.stringFill((tabbed.length() + 1) % 4, ' '));
                        continue block5;
                    }
                    default: {
                        tabbed.append(c);
                    }
                }
            }
            return tabbed.toString();
        };
        List safe = rows.stream().map(row -> {
            LinkedHashMap map = new LinkedHashMap();
            if (row != null) {
                row.forEach((k, v) -> {
                    if (v == null || "null".equals(v)) {
                        return;
                    }
                    String s = (String)toSingleLineString.apply(k);
                    if (k instanceof CharSequence && s.startsWith("\"") && s.endsWith("\"")) {
                        s = s.substring(1, s.length() - 1);
                    }
                    map.put(s, (String)toSingleLineString.apply(v));
                });
            }
            return map;
        }).collect(Collectors.toList());
        if (TABLE_BOOLEAN_TO_CHECK) {
            HashMap booleanColumns = new HashMap();
            for (Map row2 : safe) {
                row2.forEach((k, v) -> {
                    if (!booleanColumns.getOrDefault(k, Boolean.TRUE).booleanValue()) {
                        return;
                    }
                    booleanColumns.put(k, v.isEmpty() || v.equals("true") || v.equals("false"));
                });
            }
            for (Map row2 : safe) {
                row2.entrySet().forEach(e -> {
                    if (((Boolean)booleanColumns.get(e.getKey())).booleanValue()) {
                        switch ((String)e.getValue()) {
                            case "true": {
                                e.setValue("\u221a");
                                break;
                            }
                            case "false": {
                                e.setValue("x");
                            }
                        }
                    }
                });
            }
        }
        LinkedHashMap<String, Integer> columnWidths = new LinkedHashMap<String, Integer>();
        for (Map row2 : safe) {
            row2.forEach((k, v) -> {
                Integer max = (Integer)columnWidths.get(k);
                int newLen = Math.max(k.length(), v.length()) + 2;
                if (max == null || max < newLen) {
                    columnWidths.put((String)k, newLen);
                }
            });
        }
        if (columnWidths.isEmpty()) {
            columnWidths.put("", 0);
        }
        int width = columnWidths.values().stream().mapToInt(i -> i + 1).sum() + 1;
        int titleRequiredWidth = title.length() + 4;
        while (titleRequiredWidth > width) {
            int diff = titleRequiredWidth - width;
            int columnCount = columnWidths.size();
            if (diff > columnCount) {
                int toAdd = diff / columnCount;
                for (Map.Entry entry : columnWidths.entrySet()) {
                    entry.setValue((Integer)entry.getValue() + toAdd);
                }
                width += toAdd * columnCount;
                continue;
            }
            columnWidths.entrySet().stream().limit(diff).forEach(e -> e.setValue((Integer)e.getValue() + 1));
            width += diff;
        }
        if (titleRequiredWidth + 2 <= width) {
            title = " " + title + " ";
        }
        BiFunction<Integer, String, String> printCell = (len, val) -> {
            if (val == null || val.equals("null")) {
                return TextUtil.stringFill(len, ' ');
            }
            int diff = len - val.length();
            if (diff == 0) {
                return val;
            }
            int l = UtilL.isNumeric(val) ? (diff > 1 ? diff - 1 : diff) : (val.startsWith("[") && val.endsWith("]") ? Math.min(diff, 1) : diff / 2);
            int r = diff - l;
            return TextUtil.stringFill(l, ' ') + val + TextUtil.stringFill(r, ' ');
        };
        char lineChar = '=';
        String line = TextUtil.stringFill(width, lineChar);
        int size = (line.length() + 1) * safe.size();
        StringBuilder stringBuilder = new StringBuilder(size);
        int titleFreeSpace = width - title.length();
        int l = titleFreeSpace / 2;
        int r = titleFreeSpace - l;
        for (int i2 = 0; i2 < l; ++i2) {
            stringBuilder.append(lineChar);
        }
        stringBuilder.append(title);
        for (int i2 = 0; i2 < r; ++i2) {
            stringBuilder.append(lineChar);
        }
        stringBuilder.append('\n');
        columnWidths.forEach((name, len) -> result.append('|').append((String)printCell.apply((Integer)len, (String)name)));
        stringBuilder.append("|\n");
        stringBuilder.append(line).append('\n');
        for (Map row3 : safe) {
            columnWidths.forEach((name, len) -> result.append('|').append((String)printCell.apply((Integer)len, (String)row3.get(name))));
            stringBuilder.append("|\n");
        }
        stringBuilder.append(line);
        return stringBuilder.toString();
    }

    private static synchronized List<String> getOverrides(Class<?> cl) {
        return OVERRIDE_FUNCTION_CACHE.computeIfAbsent(cl, c -> {
            ArrayList result = new ArrayList(3);
            Consumer<String> addExisting = name -> {
                try {
                    Method m = c.getMethod((String)name, new Class[0]);
                    int mods = m.getModifiers();
                    if (Modifier.isPublic(mods) && !Modifier.isStatic(mods) && m.getReturnType() == String.class && m.getParameterCount() == 0) {
                        result.add(name);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            };
            BiConsumer<String, Class> addOverriding = (name, base) -> {
                try {
                    if (c.getMethod((String)name, new Class[0]).getDeclaringClass() != base) {
                        result.add(name);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            };
            addOverriding.accept("toString", Object.class);
            addExisting.accept("toShortString");
            addExisting.accept("toTableString");
            return ArrayViewList.create(result.toArray(ZeroArrays.ZERO_STRING), null);
        });
    }

    public static synchronized boolean overridesToString(Class<?> cl) {
        return TextUtil.getOverrides(cl).contains("toString");
    }

    public static String enhancedToString(Object o) {
        if (o == null) {
            return "null";
        }
        if (TextUtil.overridesToString(o.getClass())) {
            return o.toString();
        }
        return TextUtil.toNamedJson(o);
    }

    @NotNull
    public static String plural(@NotNull String word, int count) {
        return count == 1 ? word : TextUtil.plural(word);
    }

    public static String plural(@NotNull String word) {
        switch (word.charAt(word.length() - 1)) {
            case 's': 
            case 'x': {
                return word + "es";
            }
            case 'h': {
                switch (word.charAt(word.length() - 2)) {
                    case 'c': 
                    case 's': {
                        return word + "es";
                    }
                }
            }
        }
        return word + "s";
    }

    @NotNull
    public static String stringFill(int length, char c) {
        if (length == 0) {
            return "";
        }
        char[] ch = new char[length];
        Arrays.fill(ch, c);
        return new String(ch);
    }

    public static String wrappedString(Object obj) {
        return TextUtil.wrappedString(TextUtil.splitByChar(TextUtil.toString(obj), '\n'));
    }

    public static String wrappedString(String ... lines) {
        if (lines == null || lines.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringBuilder padding = new StringBuilder();
        int width = Arrays.stream(lines).mapToInt(String::length).max().orElse(0) + 2;
        result.append('/');
        for (int i = 0; i < width; ++i) {
            result.append('-');
        }
        result.append("\\\n");
        for (String line : lines) {
            int diff = width - line.length();
            int l = diff / 2;
            int r = diff - l;
            result.append('|');
            if (padding.length() > l) {
                padding.setLength(l);
            } else {
                while (padding.length() < l) {
                    padding.append(' ');
                }
            }
            result.append((CharSequence)padding);
            result.append(line);
            if (padding.length() > r) {
                padding.setLength(l);
            } else {
                while (padding.length() < r) {
                    padding.append(' ');
                }
            }
            result.append((CharSequence)padding);
            result.append("|\n");
        }
        result.append('\\');
        for (int i = 0; i < width; ++i) {
            result.append('-');
        }
        result.append('/');
        return result.toString();
    }

    @NotNull
    public static List<String> wrapLongString(@NotNull String str, int width) {
        ArrayList<String> result = new ArrayList<String>(2);
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (line.length() >= width) {
                int lastSpace;
                for (lastSpace = line.length() - 1; lastSpace > 0 && Character.isWhitespace(line.charAt(lastSpace - 1)); --lastSpace) {
                }
                while (lastSpace > 0 && !Character.isWhitespace(line.charAt(lastSpace - 1))) {
                    --lastSpace;
                }
                if (lastSpace != 0) {
                    if (Character.isWhitespace(c)) {
                        int possibleSplit = line.length() - lastSpace;
                        if (possibleSplit > width) {
                            return TextUtil.wrapLongString(str, possibleSplit);
                        }
                        String lastWord = line.substring(lastSpace);
                        line.setLength(lastSpace);
                        result.add(line.toString());
                        line.setLength(0);
                        line.append(lastWord);
                    } else {
                        String overflowLine = line.toString();
                        result.add(overflowLine.substring(0, lastSpace).trim());
                        line.setLength(0);
                        line.append(overflowLine.substring(lastSpace));
                    }
                }
            }
            if (c == '\n') {
                result.add(line.toString());
                line.setLength(0);
                continue;
            }
            line.append(c);
        }
        String lastLine = line.toString();
        if (lastLine.length() > width) {
            return TextUtil.wrapLongString(str, lastLine.length());
        }
        result.add(lastLine);
        return result;
    }

    public static String join(@NotNull Collection<?> data, String s) {
        Iterator<?> i = data.iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        while (true) {
            result.append(i.next());
            if (!i.hasNext()) break;
            result.append(s);
        }
        return result.toString();
    }

    @Nullable
    public static String firstToLowerCase(@Nullable String string) {
        if (string == null || string.isEmpty() || Character.isLowerCase(string.charAt(0))) {
            return string;
        }
        char[] c = string.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    @Nullable
    public static String firstToUpperCase(@Nullable String string) {
        if (string == null || string.isEmpty() || Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        char[] c = string.toCharArray();
        c[0] = Character.toUpperCase(c[0]);
        return new String(c);
    }

    public static String bytesToHex(@NotNull byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    @NotNull
    public static byte[] hexStringToByteArray(@NotNull String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    @NotNull
    public static String[] splitByChar(@NotNull String src, char toSplit) {
        return TextUtil.splitByChar(src, toSplit, 0, src.length());
    }

    @NotNull
    public static String[] splitByChar(@NotNull String src, char toSplit, int start) {
        return TextUtil.splitByChar(src, toSplit, start, src.length());
    }

    @NotNull
    public static String[] splitByChar(@NotNull String src, char toSplit, int start, int end) {
        int count = 1;
        for (int i = start; i < end; ++i) {
            if (src.charAt(i) != toSplit) continue;
            ++count;
        }
        String[] result = new String[count];
        int pos = start;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            char c;
            sb.setLength(0);
            while (pos < end && (c = src.charAt(pos++)) != toSplit) {
                sb.append(c);
            }
            result[i] = sb.toString();
        }
        return result;
    }

    public static boolean containsIgnoreCase(String src, String what) {
        int length = what.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(what.charAt(0));
        char firstUp = Character.toUpperCase(what.charAt(0));
        for (int i = src.length() - length; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, what, 0, length)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ String lambda$toNamedPrettyJson$35(Collection l, Function fun) {
        return l.stream().map(fun).collect(Collectors.joining(",\n    "));
    }

    static {
        CUSTOM_TO_STRINGS.register(CharSequence.class, CharSequence::toString);
        IN_TABLE_TO_STRINGS.register(CharSequence.class, CharSequence::toString);
        CUSTOM_TO_STRINGS.register(UtilL::isArray, TextUtil::unknownArrayToString);
        CUSTOM_TO_STRINGS.register(Integer.class, Object::toString);
        CUSTOM_TO_STRINGS.register(FloatBuffer.class, buffer -> {
            StringBuilder print = new StringBuilder("FloatBuffer[");
            int i = 0;
            while (i < buffer.limit()) {
                print.append(buffer.get(i));
                if (++i >= buffer.limit()) continue;
                print.append(", ");
            }
            print.append(']');
            return print.toString();
        });
        CUSTOM_TO_STRINGS.register(IntBuffer.class, buffer -> {
            StringBuilder print = new StringBuilder("IntBuffer[");
            int i = 0;
            while (i < buffer.limit()) {
                print.append(buffer.get(i));
                if (++i >= buffer.limit()) continue;
                print.append(", ");
            }
            print.append(']');
            return print.toString();
        });
        CUSTOM_TO_STRINGS.register(ByteBuffer.class, buffer -> {
            StringBuilder print = new StringBuilder("ByteBuffer[");
            int i = 0;
            while (i < buffer.limit()) {
                print.append(buffer.get(i) & 0xFF);
                if (++i >= buffer.limit()) continue;
                print.append(", ");
            }
            print.append(']');
            return print.toString();
        });
        CUSTOM_TO_STRINGS.register(LongBuffer.class, buffer -> {
            StringBuilder print = new StringBuilder("LongBuffer[");
            int i = 0;
            while (i < buffer.limit()) {
                print.append(buffer.get(i));
                if (++i >= buffer.limit()) continue;
                print.append(", ");
            }
            print.append(']');
            return print.toString();
        });
        CUSTOM_TO_STRINGS.register(ShortBuffer.class, buffer -> {
            StringBuilder print = new StringBuilder("ShortBuffer[");
            int i = 0;
            while (i < buffer.limit()) {
                print.append(buffer.get(i));
                if (++i >= buffer.limit()) continue;
                print.append(", ");
            }
            print.append(']');
            return print.toString();
        });
        Supplier<CustomToString> collectionTS = () -> USE_SHORT_IN_COLLECTIONS ? SHORT_TO_STRINGS : CUSTOM_TO_STRINGS;
        CUSTOM_TO_STRINGS.register(Stream.class, stream -> {
            try {
                String string = Arrays.toString(stream.map(((CustomToString)collectionTS.get())::toString).toArray());
                return string;
            }
            finally {
                stream.close();
            }
        });
        CUSTOM_TO_STRINGS.register(IntStream.class, stream -> {
            try {
                String string = TextUtil.toString((Object)stream.toArray());
                return string;
            }
            finally {
                stream.close();
            }
        });
        CUSTOM_TO_STRINGS.register(DoubleStream.class, stream -> {
            try {
                String string = TextUtil.toString((Object)stream.toArray());
                return string;
            }
            finally {
                stream.close();
            }
        });
        CUSTOM_TO_STRINGS.register(LongStream.class, stream -> {
            try {
                String string = TextUtil.toString((Object)stream.toArray());
                return string;
            }
            finally {
                stream.close();
            }
        });
        CUSTOM_TO_STRINGS.register(Collection.class, col -> {
            Iterator it = col.iterator();
            if (!it.hasNext()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            while (true) {
                Object e;
                sb.append((e = it.next()) == col ? "(this Collection)" : ((CustomToString)collectionTS.get()).toString(e));
                if (!it.hasNext()) {
                    return sb.append(']').toString();
                }
                sb.append(',').append(' ');
            }
        });
        CUSTOM_TO_STRINGS.register(Map.class, map -> {
            Iterator i = map.entrySet().iterator();
            if (!i.hasNext()) {
                return "{}";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            while (true) {
                Map.Entry e = i.next();
                Object key = e.getKey();
                Object value = e.getValue();
                sb.append(key == map ? "(this Map)" : ((CustomToString)collectionTS.get()).toString(key));
                sb.append('=');
                sb.append(value == map ? "(this Map)" : ((CustomToString)collectionTS.get()).toString(value));
                if (!i.hasNext()) {
                    return sb.append('}').toString();
                }
                sb.append(',').append(' ');
            }
        });
        BiPredicate<Class, String> checkImply = (c, name) -> IMPLY_TO_STRINGS && TextUtil.getOverrides(c).contains(name);
        BiFunction<Object, String, String> doImply = (obj, name) -> {
            try {
                String val = (String)obj.getClass().getMethod((String)name, new Class[0]).invoke(obj, new Object[0]);
                if (val == null) {
                    return "null";
                }
                return val;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        };
        SHORT_TO_STRINGS.register(c -> checkImply.test((Class)c, "toShortString"), obj -> (String)doImply.apply(obj, "toShortString"));
        IN_TABLE_TO_STRINGS.register(c -> checkImply.test((Class)c, "toTableString"), obj -> (String)doImply.apply(obj, "toTableString"));
        Function<Class, StringBuilder> nestedSimpleClass = clazz -> {
            StringBuilder result = new StringBuilder();
            LinkedList stack = new LinkedList();
            for (Class<?> typ = clazz; typ != null; typ = typ.getDeclaringClass()) {
                stack.add(0, typ);
            }
            for (int i = 0; i < stack.size(); ++i) {
                result.append(((Class)stack.get(i)).getSimpleName());
                if (i + 1 >= stack.size()) continue;
                result.append('.');
            }
            return result;
        };
        CUSTOM_TO_STRINGS.register(c -> UtilL.instanceOf(c, Annotation.class), an -> {
            Annotation ann = (Annotation)an;
            StringBuilder result = (StringBuilder)nestedSimpleClass.apply(ann.annotationType());
            result.append('{');
            result.append(TextUtil.mapObjectValues(an).entrySet().stream().map(e -> TextUtil.toString(e.getKey()) + ": " + TextUtil.toString(e.getValue())).collect(Collectors.joining(", ")));
            result.append('}');
            return result.toString();
        });
        BiFunction<Class, Function, String> classString = (clazz, toString) -> {
            if (UtilL.instanceOf(clazz, Annotation.class) && Proxy.isProxyClass(clazz)) {
                return (String)toString.apply(UtilL.getAnnotationInterface(clazz));
            }
            return clazz.toString();
        };
        CUSTOM_TO_STRINGS.register(Class.class, clazz -> (String)classString.apply((Class)clazz, c -> "@interface " + c.getName()));
        SHORT_TO_STRINGS.register(Class.class, clazz -> (String)classString.apply((Class)clazz, c -> ((StringBuilder)nestedSimpleClass.apply((Class)c)).toString()));
        Predicate<Object> isRecordTmp = o -> false;
        try {
            Method isRecord = Class.class.getMethod("isRecord", new Class[0]);
            isRecordTmp = obj -> {
                try {
                    return (Boolean)isRecord.invoke(obj.getClass(), new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    return false;
                }
            };
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        IS_RECORD = isRecordTmp;
        JSON_CALL_STACK = ThreadLocal.withInitial(LinkedList::new);
        PRETTY_JSON_CALL_STACK = ThreadLocal.withInitial(LinkedList::new);
        OVERRIDE_FUNCTION_CACHE = new HashMap();
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    }

    public static final class CustomToString {
        private final List<ToStringNode<?>> overrides = new ArrayList();
        private final Function<Object, String> fallback;

        private CustomToString(Function<Object, String> fallback) {
            this.fallback = fallback;
        }

        public <T> void register(@NotNull Class<T> type, @NotNull Function<? extends T, String> toString) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(toString);
            this.register(t -> t == type, t -> UtilL.instanceOf(t, type), toString);
        }

        public <T> void register(@NotNull Predicate<Class<?>> canStringify, @NotNull Function<?, String> toString) {
            Objects.requireNonNull(canStringify);
            Objects.requireNonNull(toString);
            this.register(t -> false, canStringify, toString);
        }

        public void register(@NotNull Predicate<Class<?>> checkExact, @NotNull Predicate<Class<?>> check, @NotNull Function<?, String> toString) {
            Objects.requireNonNull(checkExact);
            Objects.requireNonNull(check);
            Objects.requireNonNull(toString);
            this.overrides.add(new ToStringNode(checkExact, check, toString));
        }

        public <T> String toString(T obj) {
            if (obj == null) {
                return "null";
            }
            Class<?> type = obj.getClass();
            for (ToStringNode<?> e : this.overrides) {
                if (!((ToStringNode)e).checkExact(type)) continue;
                return ((ToStringNode)e).toString(obj);
            }
            for (ToStringNode<?> e : this.overrides) {
                if (!((ToStringNode)e).check(type)) continue;
                return ((ToStringNode)e).toString(obj);
            }
            return this.fallback.apply(obj);
        }

        private static class ToStringNode<T> {
            private final Predicate<Class<?>> checkExact;
            private final Predicate<Class<?>> check;
            private final Function<T, String> toString;

            private ToStringNode(Predicate<Class<?>> checkExact, Predicate<Class<?>> check, Function<T, String> toString) {
                this.checkExact = checkExact;
                this.check = check;
                this.toString = toString;
            }

            private String toString(T t) {
                return this.toString.apply(t);
            }

            private boolean checkExact(Class<?> o) {
                return this.checkExact.test(o);
            }

            private boolean check(Class<?> o) {
                return this.check.test(o);
            }
        }
    }
}

