/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.NotNull;
import com.lapissea.util.Nullable;
import com.lapissea.util.TextUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class StringTree<T> {
    private static final int PUT_FAIL = 0;
    private static final int PUT_SUCCESS = 1;
    private static final int PUT_SUCCESS_OPTIMIZE = 2;
    @NotNull
    PartRoot root = new PartRoot();
    @Nullable
    private LinkedList<Part> unoptimized;

    public void clear() {
        this.root.clear();
        this.root.obj = null;
    }

    @Nullable
    public T get(@NotNull String key) {
        this.optimize();
        Part part = this.root.find(key, 0);
        return part == null ? null : (T)part.obj;
    }

    public void put(@NotNull String key, T value) {
        this.root.put(key, 0, value);
    }

    @NotNull
    public String displayTree() {
        this.optimize();
        StringBuilder sb = new StringBuilder();
        this.root.displayTree(sb, 0);
        sb.setLength(Math.max(sb.length() - 1, 0));
        return sb.toString();
    }

    protected void optimize() {
        if (this.unoptimized != null) {
            this.unoptimized.forEach(Part::optimize);
            this.unoptimized = null;
        }
    }

    private class PartRoot
    extends Part {
        PartRoot() {
            super("");
        }

        @Override
        @Nullable
        Part find(@NotNull String key, int pos) {
            if (key.isEmpty()) {
                return this;
            }
            for (Part child : this) {
                Part result = child.find(key, 0);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        int put(@NotNull String key, int pos, T value) {
            if (key.isEmpty()) {
                this.obj = value;
                return 1;
            }
            int code = this.childPut(key, 0, value);
            if (code == 2) {
                this.optimize();
                return 1;
            }
            return code;
        }

        @Override
        public void displayTree(@NotNull StringBuilder sb, int tabbing) {
            if (this.obj == null) {
                for (Part child : this) {
                    child.displayTree(sb, tabbing);
                }
                return;
            }
            for (int i = 0; i < tabbing; ++i) {
                sb.append(' ');
            }
            this.printSig(sb);
            for (Part child : this) {
                child.displayTree(sb, tabbing);
            }
        }
    }

    private class Part
    extends ArrayList<Part> {
        protected String signature;
        @Nullable
        T obj;

        Part(String signature, T val) {
            this(signature);
            this.obj = val;
        }

        Part(String signature) {
            super(2);
            this.signature = signature;
        }

        boolean partMatch(@NotNull String key, int pos) {
            return key.regionMatches(pos, this.signature, 0, this.signature.length());
        }

        @Nullable
        Part find(@NotNull String key, int pos) {
            int partEnd = pos + this.signature.length();
            if (key.length() < partEnd) {
                return null;
            }
            boolean endHit = key.length() == partEnd;
            boolean matched = this.partMatch(key, pos);
            if (endHit) {
                return matched ? this : null;
            }
            if (!matched) {
                return null;
            }
            for (Part child : this) {
                Part result = child.find(key, partEnd);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        int put(@NotNull String key, int pos, T value) {
            int partEnd = pos + this.signature.length();
            if (key.length() < partEnd) {
                return 0;
            }
            boolean endHit = key.length() == partEnd;
            boolean matched = this.partMatch(key, pos);
            if (endHit) {
                if (matched) {
                    this.obj = value;
                    return 1;
                }
                return 0;
            }
            if (!matched) {
                return 0;
            }
            return this.childPut(key, partEnd, value);
        }

        int childPut(@NotNull String key, int end, T value) {
            if (this.isEmpty()) {
                this.add(new Part(key.substring(end), value));
                return 2;
            }
            block5: for (Part child : this) {
                switch (child.put(key, end, value)) {
                    case 1: {
                        return 1;
                    }
                    case 0: {
                        continue block5;
                    }
                    case 2: {
                        this.optimize();
                        return 1;
                    }
                }
                throw new RuntimeException();
            }
            this.add(new Part(key.substring(end), value));
            return 2;
        }

        @Override
        public boolean equals(@NotNull Object o) {
            if (o == this) {
                return true;
            }
            if (!o.getClass().equals(Part.class)) {
                return false;
            }
            Part p = (Part)o;
            return p.signature.equals(o);
        }

        @Override
        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            StringTree.this.root.displayTree(sb, 0);
            sb.setLength(Math.max(sb.length() - 1, 0));
            return sb.toString();
        }

        void optimize() {
            Part compactPart;
            if (this.isEmpty()) {
                return;
            }
            while ((compactPart = (Part)this.stream().map(childTest -> {
                StringBuilder sb = new StringBuilder(childTest.signature);
                ArrayList<Part> build = new ArrayList<Part>();
                block0: for (Part child : this) {
                    for (int j = 0; j < sb.length(); ++j) {
                        if (sb.charAt(j) == child.signature.charAt(j)) continue;
                        if (j == 0) continue block0;
                        sb.setLength(j);
                        break;
                    }
                    build.add(child);
                }
                if (build.size() <= 1) {
                    return null;
                }
                Part p = new Part(sb.toString());
                p.addAll(build);
                return p;
            }).filter(Objects::nonNull).max(Comparator.comparingInt(List::size)).orElse(null)) != null) {
                for (Part part : compactPart) {
                    this.remove(part);
                }
                compactPart.forEach((? super E e) -> {
                    e.signature = e.signature.substring(compactPart.signature.length());
                });
                compactPart.optimize();
                this.add(compactPart);
            }
            this.sort(Comparator.comparing(a -> a.signature));
        }

        void printSig(@NotNull StringBuilder sb) {
            sb.append(this.signature);
            if (this.obj != null) {
                sb.append("=").append(TextUtil.toString(this.obj));
            }
            sb.append(TextUtil.NEW_LINE);
        }

        void displayTree(@NotNull StringBuilder sb, int tabbing) {
            for (int i = 0; i < tabbing; ++i) {
                sb.append(' ');
            }
            this.printSig(sb);
            for (Part child : this) {
                child.displayTree(sb, tabbing + this.signature.length());
            }
        }
    }
}

