/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.NotNull;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.function.Supplier;

public class PoolOwnThread
extends Thread {
    private Pool pool = new Pool(Runtime.getRuntime().availableProcessors(), pool -> {
        ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
        worker.setName(name + "-w" + worker.getPoolIndex());
        return worker;
    }, null, false);

    @NotNull
    public static <U> CompletableFuture<U> async(@NotNull Supplier<U> supplier) {
        PoolOwnThread pool = PoolOwnThread.get();
        if (pool != null) {
            return PoolOwnThread.async(supplier, (Executor)pool.getPool());
        }
        return CompletableFuture.supplyAsync(supplier);
    }

    public static <U> CompletableFuture<U> async(@NotNull Supplier<U> supplier, Executor executor) {
        return CompletableFuture.supplyAsync(supplier, executor);
    }

    public static CompletableFuture<Void> async(@NotNull Runnable runnable, Executor executor) {
        return CompletableFuture.runAsync(runnable, executor);
    }

    @NotNull
    public static <U> CompletableFuture<Void> async(@NotNull Runnable runnable) {
        PoolOwnThread pool = PoolOwnThread.get();
        if (pool != null) {
            return CompletableFuture.runAsync(runnable, pool.getPool());
        }
        return CompletableFuture.runAsync(runnable);
    }

    public static <U> U await(@NotNull CompletableFuture<U> supplier) {
        return supplier.join();
    }

    public static PoolOwnThread get() {
        ForkJoinPool pool;
        Thread th = Thread.currentThread();
        if (th instanceof PoolOwnThread) {
            return (PoolOwnThread)th;
        }
        if (th instanceof ForkJoinWorkerThread && (pool = ((ForkJoinWorkerThread)th).getPool()) instanceof Pool) {
            return ((Pool)pool).parent();
        }
        return null;
    }

    public PoolOwnThread(Runnable runnable, String name) {
        super(runnable, name);
    }

    public Pool getPool() {
        return this.pool;
    }

    public class Pool
    extends ForkJoinPool {
        public Pool(int parallelism, ForkJoinPool.ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode) {
            super(parallelism, factory, handler, asyncMode);
        }

        public PoolOwnThread parent() {
            return PoolOwnThread.this;
        }
    }
}

