/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.NotNull;
import com.lapissea.util.Nullable;
import com.lapissea.util.UtilL;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class ObjectSize {
    public static int sizeof(@Nullable Object[] obj) {
        if (obj == null) {
            return 0;
        }
        int size = 0;
        for (Object o : obj) {
            size += ObjectSize.sizeof(o.getClass());
        }
        return size;
    }

    public static int sizeof() {
        try {
            return ObjectSize.sizeof(Class.forName(Thread.currentThread().getStackTrace()[2].getClassName()));
        }
        catch (Throwable e) {
            throw UtilL.uncheckedThrow(e);
        }
    }

    public static int sizeofPrimitive(@NotNull Class type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return 8;
            }
            if (type == Byte.TYPE) {
                return 8;
            }
            if (type == Character.TYPE) {
                return 16;
            }
            if (type == Short.TYPE) {
                return 16;
            }
            if (type == Integer.TYPE) {
                return 32;
            }
            if (type == Long.TYPE) {
                return 64;
            }
            if (type == Float.TYPE) {
                return 32;
            }
            if (type == Double.TYPE) {
                return 64;
            }
        } else {
            if (type == Boolean.class) {
                return 8;
            }
            if (type == Byte.class) {
                return 8;
            }
            if (type == Character.class) {
                return 16;
            }
            if (type == Short.class) {
                return 16;
            }
            if (type == Integer.class) {
                return 32;
            }
            if (type == Long.class) {
                return 64;
            }
            if (type == Float.class) {
                return 32;
            }
            if (type == Double.class) {
                return 64;
            }
        }
        return -1;
    }

    public static int sizeof(@NotNull Class type) {
        int size = ObjectSize.sizeofPrimitive(type);
        if (size != -1) {
            return size;
        }
        size = 0;
        do {
            if (type.isInterface()) {
                for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
                    if (Modifier.isStatic(((Method)accessibleObject).getModifiers()) || !Modifier.isPublic(((Method)accessibleObject).getModifiers()) || !accessibleObject.isAnnotationPresent(Getter.class) && (!((Method)accessibleObject).getName().startsWith("get") || ((Method)accessibleObject).getName().length() <= 3 || !Character.isUpperCase(((Method)accessibleObject).getName().charAt(3)))) continue;
                    size += ObjectSize.sizeof(((Method)accessibleObject).getReturnType());
                }
            } else {
                for (AccessibleObject accessibleObject : type.getDeclaredFields()) {
                    if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
                    size += ObjectSize.sizeof(((Field)accessibleObject).getType());
                }
            }
        } while ((type = type.getSuperclass()) != null);
        return size;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Getter {
    }
}

