/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.NotNull;

public class NanoTimer {
    private long start;
    @NotNull
    private long[] data = new long[100];
    private int pos = 99;
    private int count;
    private boolean started = false;

    public void start() {
        this.started = true;
        this.start = NanoTimer.now();
    }

    public void end() {
        long t = NanoTimer.now();
        if (!this.started) {
            throw new IllegalStateException("Not started");
        }
        this.pos = (this.pos + 1) % 100;
        this.data[this.pos] = t - this.start;
        if (this.count < 100) {
            ++this.count;
        }
    }

    public long nsAvrg100() {
        if (this.count == 0) {
            return -1L;
        }
        long sum = 0L;
        for (int i = 0; i < this.count; ++i) {
            sum += this.data[i];
        }
        return sum / (long)this.count;
    }

    public double msAvrg100() {
        if (this.count == 0) {
            return -1.0;
        }
        return NanoTimer.toMs(this.nsAvrg100());
    }

    public double sAvrg100() {
        if (this.count == 0) {
            return -1.0;
        }
        return NanoTimer.toS(this.nsAvrg100());
    }

    public long ns() {
        return this.data[this.pos];
    }

    public double ms() {
        return NanoTimer.toMs(this.ns());
    }

    public double s() {
        return NanoTimer.toS(this.ns());
    }

    private static long now() {
        return System.nanoTime();
    }

    private static double toMs(long nano) {
        return (double)Math.round((double)nano / 1000.0) / 1000.0;
    }

    private static double toS(long nano) {
        return (double)Math.round((double)nano / 1.0E7) / 100.0;
    }
}

