/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.NotNull;
import com.lapissea.util.Nullable;
import com.lapissea.util.PairM;
import com.lapissea.util.TextUtil;
import com.lapissea.util.UtilL;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class LogUtil {
    private static final long START_TIME = System.currentTimeMillis();
    private static final List<TableColumn> TABLE_COLUMNS = new ArrayList<TableColumn>(1);
    private static boolean TABLE_FLAG = false;
    private static boolean TABLE_LAST_FLAG = false;
    private static final List<Function<Object, Map<String, String>>> OBJECT_SCANNERS = Arrays.asList(map -> map instanceof Map ? ((Map)map).entrySet().stream().collect(Collectors.toMap(e -> TextUtil.IN_TABLE_TO_STRINGS.toString(e.getKey()), e -> TextUtil.IN_TABLE_TO_STRINGS.toString(e.getValue()))) : null, row -> {
        Class<?> c = row.getClass();
        if (LogUtil.notKotlinData(c)) {
            return null;
        }
        Field[] fs = c.getDeclaredFields();
        LinkedHashMap<String, String> table = new LinkedHashMap<String, String>(fs.length);
        for (Field f : fs) {
            f.setAccessible(true);
            try {
                table.put(f.getName(), TextUtil.IN_TABLE_TO_STRINGS.toString(f.get(row)));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return table;
    }, o -> {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        TextUtil.mapObjectValues(o, (name, obj) -> {
            if (!TextUtil.JSON_NULL_PRINT && obj == null) {
                return;
            }
            data.put((String)name, TextUtil.IN_TABLE_TO_STRINGS.toString(obj));
        });
        if (data.isEmpty()) {
            data.put("hash", o.hashCode() + "");
        }
        return data;
    });

    public static void print() {
        LogUtil.out("");
    }

    public static void println() {
        LogUtil.out("\n");
    }

    public static void print(Object obj) {
        LogUtil.out(TextUtil.toString(obj));
    }

    public static void println(int obj) {
        LogUtil.out(obj + "\n");
    }

    public static void println(float obj) {
        LogUtil.out(obj + "\n");
    }

    public static void println(long obj) {
        LogUtil.out(obj + "\n");
    }

    public static void println(double obj) {
        LogUtil.out(obj + "\n");
    }

    public static void println(char obj) {
        LogUtil.out(obj + "\n");
    }

    public static void println(byte obj) {
        LogUtil.out(obj + "\n");
    }

    public static void println(boolean obj) {
        LogUtil.out(obj + "\n");
    }

    public static void println(short obj) {
        LogUtil.out(obj + "\n");
    }

    public static void println(String obj) {
        LogUtil.out(obj + "\n");
    }

    public static void println(Object obj) {
        LogUtil.out(TextUtil.toString(obj) + "\n");
    }

    public static void print(Object ... objs) {
        LogUtil.out(TextUtil.toString(objs));
    }

    public static void println(Object ... objs) {
        LogUtil.out(TextUtil.toString(objs) + "\n");
    }

    public static void printlnEr() {
        LogUtil.err("\n");
    }

    public static void printEr() {
        LogUtil.err("");
    }

    public static void printEr(Object obj) {
        LogUtil.err(TextUtil.toString(obj));
    }

    public static void printlnEr(Object obj) {
        LogUtil.err(TextUtil.toString(obj) + "\n");
    }

    public static void printEr(Object ... objs) {
        LogUtil.err(TextUtil.toString(objs));
    }

    public static void printlnEr(Object ... objs) {
        LogUtil.err(TextUtil.toString(objs) + "\n");
    }

    public static void printFunctionTrace(int count, CharSequence splitter) {
        LogUtil.println(LogUtil.getFunctionTrace(count, splitter));
    }

    public static String getFunctionTrace(int count, CharSequence splitter) {
        StringBuilder line = new StringBuilder();
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (count >= trace.length) {
            count = trace.length - 1;
        }
        for (int i = count + 1; i >= 2; --i) {
            line.append(trace[i].getMethodName()).append('(').append(trace[i].getLineNumber()).append(')');
            if (i == 2) continue;
            line.append(splitter);
        }
        return line.toString();
    }

    public static void printWrappedEr(Object obj) {
        LogUtil.printlnEr((Object)TextUtil.wrappedString(obj));
    }

    public static void printWrapped(Object obj) {
        LogUtil.println(TextUtil.wrappedString(obj));
    }

    public static <T> T printlnAndReturn(T obj) {
        LogUtil.println(obj);
        return obj;
    }

    public static void printStackTrace(String msg) {
        LogUtil.printStackTrace(msg, Thread.currentThread().getStackTrace());
    }

    public static void printStackTrace(@Nullable String msg, @NotNull StackTraceElement[] a1) {
        StringBuilder result = new StringBuilder();
        if (msg == null) {
            result.append("Invoke time: ").append(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date())).append("\n");
        } else {
            result.append(msg).append("\n");
        }
        int length = 0;
        for (int i = 2; i < a1.length; ++i) {
            StackTraceElement a = a1[i];
            String s = a.toString();
            result.append(s).append("\n");
            length = Math.max(s.length(), length);
        }
        for (int b = 0; b <= length / 4; ++b) {
            result.append("_/\\_");
        }
        LogUtil.printlnEr((Object)result);
    }

    private static boolean notKotlinData(Class c) {
        int compCount;
        ArrayList<Method> functs = new ArrayList<Method>(Arrays.asList(c.getDeclaredMethods()));
        Field[] fs = c.getDeclaredFields();
        if (fs.length != (compCount = (int)functs.stream().filter(m -> m.getName().matches("component[0-9]+")).count())) {
            return true;
        }
        for (Field f : fs) {
            String n = f.getName();
            if (functs.removeIf(t -> t.getName().equals("get" + TextUtil.firstToUpperCase(n)))) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> objectToMap(Object row) {
        for (Function<Object, Map<String, String>> objectScanner : OBJECT_SCANNERS) {
            Map<String, String> mapped = objectScanner.apply(row);
            if (mapped == null) continue;
            return mapped;
        }
        throw new RuntimeException();
    }

    /*
     * WARNING - void declaration
     */
    public static void printTable(Object row) {
        Class<?> c = row.getClass();
        if (c.isArray()) {
            LogUtil.printTable((Object[])row);
            return;
        }
        if (row instanceof Iterable) {
            ArrayList<Map<String, String>> collective = new ArrayList<Map<String, String>>();
            HashSet<String> names = new HashSet<String>();
            for (Object t : (Iterable)row) {
                Map<String, String> map = LogUtil.objectToMap(t);
                names.addAll(map.keySet());
                collective.add(map);
                for (Map map2 : collective) {
                    for (String name : names) {
                        map2.putIfAbsent(name, "null");
                    }
                }
            }
            if (collective.size() > 1) {
                void var8_21;
                int[] growthProtection = new int[names.size()];
                for (Map map : collective) {
                    Iterator iter = map.values().iterator();
                    for (int i = 0; i < growthProtection.length; ++i) {
                        int len = ((String)iter.next()).length();
                        if (growthProtection[i] >= len) continue;
                        growthProtection[i] = len;
                    }
                }
                Iterator iterator = ((Map)collective.get(0)).entrySet().iterator();
                int[] nArray = growthProtection;
                int n = nArray.length;
                boolean bl = false;
                while (var8_21 < n) {
                    int max = nArray[var8_21];
                    Map.Entry e = iterator.next();
                    int len = ((String)e.getValue()).length();
                    if (max > len) {
                        e.setValue((String)e.getValue() + TextUtil.stringFill(max - len, ' '));
                    }
                    ++var8_21;
                }
            }
            for (Map map : collective) {
                LogUtil.printTable(map);
            }
            return;
        }
        LogUtil.printTable(LogUtil.objectToMap(row));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTable(Object ... row) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            if (row.length % 2 != 0) {
                throw new IllegalArgumentException();
            }
            LinkedHashMap<Object, Object> table = new LinkedHashMap<Object, Object>();
            int j = row.length / 2;
            for (int i = 0; i < j; ++i) {
                table.put(row[i * 2], row[i * 2 + 1]);
            }
            LogUtil.printTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTable(@NotNull Object[] rowNames, Object ... rowValues) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            assert (rowNames.length == rowValues.length);
            LinkedHashMap<Object, Object> table = new LinkedHashMap<Object, Object>();
            int j = rowNames.length;
            for (int i = 0; i < j; ++i) {
                table.put(rowNames[i], rowValues[i]);
            }
            LogUtil.printTable(table);
        }
    }

    public static void printTable(String keyName, String valueName, Map<?, ?> data) {
        String v;
        if (data.isEmpty()) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(data.size());
        ArrayList<String> values = new ArrayList<String>(data.size());
        int[] sizes = new int[]{keyName.length(), valueName.length()};
        data.forEach((key, value) -> {
            String k = TextUtil.toString(key);
            keys.add(k);
            String v = TextUtil.toString(value);
            values.add(v);
            sizes[0] = Math.max(sizes[0], k.length());
            sizes[1] = Math.max(sizes[1], v.length());
        });
        String k = (String)keys.get(0);
        if (k.length() < sizes[0]) {
            keys.set(0, k + TextUtil.stringFill(sizes[0] - k.length(), ' '));
        }
        if ((v = (String)values.get(0)).length() < sizes[1]) {
            values.set(0, v + TextUtil.stringFill(sizes[1] - v.length(), ' '));
        }
        LinkedHashMap<String, String> row = new LinkedHashMap<String, String>(2);
        for (int i = 0; i < data.size(); ++i) {
            row.put(keyName, (String)keys.get(i));
            row.put(valueName, (String)values.get(i));
            LogUtil.printTable(row);
            row.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTable(Map<?, ?> row) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            LinkedHashMap<String, String> rowSafe = new LinkedHashMap<String, String>(row.size());
            Function<Object, String> toString = o -> TextUtil.toTableString(o).replace("\n", "\\n");
            row.forEach((k, v) -> {
                String val = (String)toString.apply(v);
                if (val.indexOf(9) != -1) {
                    StringBuilder sb = new StringBuilder(val.length() + 20);
                    int pos = 0;
                    for (char c : val.toCharArray()) {
                        if (c != '\t') {
                            sb.append(c);
                            ++pos;
                            continue;
                        }
                        int requiredPos = (pos / 4 + 1) * 4;
                        while (pos < requiredPos) {
                            sb.append(' ');
                            ++pos;
                        }
                    }
                    val = sb.toString();
                }
                rowSafe.put((String)toString.apply(k), val);
            });
            if (TABLE_COLUMNS.stream().noneMatch(s -> rowSafe.containsKey(s.name))) {
                TABLE_COLUMNS.clear();
            }
            rowSafe.forEach((k, v) -> TABLE_COLUMNS.stream().filter(c -> c.name.equals(k)).findAny().orElseGet(() -> {
                TableColumn c = new TableColumn((String)k);
                TABLE_COLUMNS.add(c);
                TABLE_LAST_FLAG = false;
                return c;
            }).gibWidth(v.length()));
            StringBuilder sb = new StringBuilder();
            if (!TABLE_LAST_FLAG) {
                String names = TABLE_COLUMNS.stream().map(TextUtil::toTableString).collect(Collectors.joining("|"));
                StringBuilder lines = new StringBuilder(names.length() + 3);
                lines.append('|');
                for (int i = 0; i < names.length(); ++i) {
                    lines.append('=');
                }
                lines.append("|\n");
                sb.append((CharSequence)lines);
                sb.append("|").append(names).append("|\n");
                sb.append((CharSequence)lines);
            }
            sb.append('|');
            for (TableColumn column : TABLE_COLUMNS) {
                int left = column.width;
                String val = (String)rowSafe.get(column.name);
                sb.append(' ');
                if (val != null) {
                    left -= val.length();
                    sb.append(val);
                }
                sb.append(' ');
                while (left-- > 0) {
                    sb.append(' ');
                }
                sb.append('|');
            }
            sb.append('\n');
            TABLE_FLAG = true;
            LogUtil.out(sb.toString());
        }
    }

    @SafeVarargs
    public static <T> void printGraph(T[] data, int height, boolean snapBottom, Val<T> ... values) {
        LogUtil.printGraph(data, height, -1, snapBottom, values);
    }

    @SafeVarargs
    public static <T> void printGraph(T[] data, int height, int width, boolean snapBottom, Val<T> ... values) {
        LogUtil.printGraph(Arrays.asList(data), height, width, snapBottom, values);
    }

    @SafeVarargs
    public static <T> void printGraph(Collection<T> data, int height, boolean snapBottom, Val<T> ... values) {
        LogUtil.printGraph(data, height, -1, snapBottom, values);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> void printGraph(Collection<T> data, int height, int width, boolean snapBottom, Val<T> ... values) {
        double d;
        int j;
        if (height <= 0) {
            throw new IllegalArgumentException("Height must be greater than 0");
        }
        if (width <= 0) {
            if (width != -1) {
                throw new IllegalArgumentException("Width must be greater than 0 or -1 for auto width");
            }
            width = data.size();
        }
        double[][] collected = new double[data.size()][values.length];
        int i2 = 0;
        for (T t : data) {
            double[] line = collected[i2];
            for (int y = 0; y < line.length; ++y) {
                line[y] = ((Val)values[y]).getter.get(t);
            }
            ++i2;
        }
        double[] min = new double[values.length];
        double[] max = new double[values.length];
        Arrays.fill(min, Double.MAX_VALUE);
        Arrays.fill(max, Double.MIN_VALUE);
        for (double[] line2 : collected) {
            for (j = 0; j < line2.length; ++j) {
                d = line2[j];
                if (d < min[j]) {
                    min[j] = d;
                }
                if (!(d > max[j])) continue;
                max[j] = d;
            }
        }
        if (!snapBottom) {
            void var8_12;
            boolean bl = false;
            while (var8_12 < min.length) {
                if (min[var8_12] > 0.0 && max[var8_12] > 0.0) {
                    min[var8_12] = 0.0;
                }
                ++var8_12;
            }
        }
        for (double[] line : collected) {
            for (j = 0; j < line.length; ++j) {
                line[j] = d = (line[j] - min[j]) / (max[j] - min[j]);
            }
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        for (int i4 = 0; i4 < collected.length - 1; ++i4) {
            double[] current = collected[i4];
            double[] next = collected[i4 + 1];
            for (int k = 0; k < current.length; ++k) {
                double yCurrent = (1.0 - current[k]) * (double)height;
                double xCurrent = (double)i4 / (double)collected.length * (double)width;
                double yNext = (1.0 - next[k]) * (double)height;
                double xNext = (double)(i4 + 1) / (double)collected.length * (double)width;
                int id = k + 1;
                g.setColor(new Color(id, id, id));
                g.draw(new Line2D.Double(xCurrent, yCurrent, xNext, yNext));
            }
        }
        g.dispose();
        StringBuilder sb = new StringBuilder(2 + (width + 2) * (height + 1) + 2);
        sb.append("A\n");
        for (int y2 = 0; y2 < height; ++y2) {
            sb.append('|');
            for (int x = 0; x < width; ++x) {
                int n = bufferedImage.getRGB(x, y2) & 0xFF;
                sb.append(n == 0 ? (char)' ' : ((Val)values[n - 1]).identifier);
            }
            sb.append('\n');
        }
        for (int i5 = 0; i5 < width + 1; ++i5) {
            sb.append('-');
        }
        sb.append(">\n");
        LogUtil.out(sb.toString());
        LogUtil.println(IntStream.range(0, values.length).mapToObj(i -> values[i].name + " '" + values[i].identifier + "' - (" + min[i] + " - " + max[i] + ")").collect(Collectors.joining(", ")));
    }

    private static void out(String s) {
        System.out.print(s);
    }

    private static void err(String s) {
        System.err.print(s);
    }

    private static class TableColumn {
        final String name;
        int width;

        public TableColumn(String name) {
            this.name = name;
            this.width = name.length();
        }

        void gibWidth(int w) {
            this.width = Math.max(this.width, w);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.width + 2);
            sb.append(' ').append(this.name);
            for (int i = 0; i < this.width - this.name.length(); ++i) {
                sb.append(' ');
            }
            sb.append(' ');
            return sb.toString();
        }
    }

    public static class Val<T> {
        private final String name;
        private final char identifier;
        private final Getter<T> getter;

        public Val(String name, char identifier, Getter<T> getter) {
            this.name = name;
            this.identifier = identifier;
            this.getter = getter;
        }

        public static interface Getter<T> {
            public double get(T var1);
        }
    }

    public static class Init {
        public static final int CREATE_OUTPUT_LOG = 1;
        public static final int CREATE_OUTPUT_CSV = 2;
        public static final int USE_CALL_POS = 4;
        public static final int USE_CALL_POS_CLICKABLE = 8;
        public static final int USE_CALL_THREAD = 16;
        public static final int DISABLED = 32;
        public static final int USE_TABULATED_HEADER = 64;
        public static PrintStream OUT = System.out;
        public static PrintStream ERR = System.err;
        private static final Pattern KOTLIN_COMPANION_ANNOTATION;

        private Init() {
        }

        public static void attach(int flags) {
            Init.attach(flags, "debug/log");
        }

        public static void attach(int flags, @NotNull String fileLog) {
            if (UtilL.checkFlag(flags, 32)) {
                return;
            }
            Function<String, FileOutputStream> create = name -> {
                File f = new File((String)name).getAbsoluteFile();
                try {
                    f.getParentFile().mkdirs();
                    return new FileOutputStream(f);
                }
                catch (Exception e) {
                    throw UtilL.uncheckedThrow(e);
                }
            };
            FileOutputStream fileRawOut = null;
            FileOutputStream fileCsvOut = null;
            if (UtilL.checkFlag(flags, 1)) {
                fileRawOut = create.apply(fileLog + ".log");
            }
            if (UtilL.checkFlag(flags, 2)) {
                try {
                    fileCsvOut = create.apply(fileLog + ".csv");
                    fileCsvOut.write("Type, Time, Thread, Class, Function, Line, Message\n".getBytes());
                }
                catch (IOException e) {
                    throw UtilL.uncheckedThrow(e);
                }
            }
            Function<StackTraceElement, String> header = Init.getHeader(flags);
            class P
            extends PrintStream {
                public P(@NotNull OutputStream out) {
                    super(out);
                }

                @Override
                public void write(@NotNull byte[] buf, int off, int len) {
                    super.write(buf, off, len);
                    this.flush();
                }

                @Override
                public void print(String s) {
                    super.print(s);
                }
            }
            System.setOut(new P(new DebugHeaderStream(System.out, "OUT", fileRawOut, fileCsvOut, header)));
            System.setErr(new P(new DebugHeaderStream(System.err, "ERR", fileRawOut, fileCsvOut, header)));
        }

        private static String filterClassName(String className) {
            String s;
            String companionMarker = "$Companion";
            int end = className.indexOf(companionMarker) + companionMarker.length();
            String string = s = className.length() >= end ? className.substring(0, end) : className;
            if (s.endsWith(companionMarker)) {
                try {
                    Class<?> comp = Class.forName(s);
                    if (Arrays.stream(comp.getAnnotations()).anyMatch(a -> a.getClass().getSimpleName().contains("$Proxy"))) {
                        s = s.substring(0, s.lastIndexOf(companionMarker));
                    }
                    return s;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return className;
        }

        private static Function<StackTraceElement, String> getHeader(int flags) {
            boolean tabulated = UtilL.checkFlag(flags, 64);
            if (UtilL.checkFlag(flags, 16)) {
                Tabulator threadTab = new Tabulator(tabulated);
                if (UtilL.checkFlag(flags, 8)) {
                    Tabulator stackTab = new Tabulator(tabulated);
                    threadTab.onGrow = stackTab::reduce;
                    return stack -> {
                        String threadSt = "[" + Thread.currentThread().getName() + "] ";
                        String stackSt = "[" + stack.toString() + "]";
                        return threadSt + threadTab.getTab(threadSt.length()) + stackSt + stackTab.getTab(stackSt.length()) + ": ";
                    };
                }
                if (UtilL.checkFlag(flags, 4)) {
                    Tabulator stackTab = new Tabulator(tabulated);
                    threadTab.onGrow = stackTab::reduce;
                    return stack -> {
                        String methodName = stack.getMethodName();
                        if (methodName.startsWith("lambda$")) {
                            methodName = methodName.substring(7);
                        }
                        String className = Init.filterClassName(stack.getClassName());
                        String threadSt = "[" + Thread.currentThread().getName() + "] ";
                        String stackSt = "[" + className.substring(className.lastIndexOf(46) + 1) + '.' + methodName + ':' + stack.getLineNumber() + "]";
                        return threadSt + threadTab.getTab(threadSt.length()) + stackSt + stackTab.getTab(stackSt.length()) + ": ";
                    };
                }
                return stack -> {
                    String threadSt = "[" + Thread.currentThread().getName() + "]";
                    return threadSt + threadTab.getTab(threadSt.length()) + ": ";
                };
            }
            if (UtilL.checkFlag(flags, 8)) {
                Tabulator stackTab = new Tabulator(tabulated);
                return stack -> {
                    String stackSt = "[" + stack.toString() + "]";
                    return stackSt + stackTab.getTab(stackSt.length()) + ": ";
                };
            }
            if (UtilL.checkFlag(flags, 4)) {
                Tabulator stackTab = new Tabulator(tabulated);
                return stack -> {
                    String methodName = stack.getMethodName();
                    if (methodName.startsWith("lambda$")) {
                        methodName = methodName.substring(7);
                    }
                    String className = Init.filterClassName(stack.getClassName());
                    String stackSt = "[" + className.substring(className.lastIndexOf(46) + 1) + '.' + methodName + ':' + stack.getLineNumber() + "]";
                    return stackSt + stackTab.getTab(stackSt.length()) + ": ";
                };
            }
            return stack -> "";
        }

        @Deprecated
        public static void destroy() {
            Init.detach();
        }

        public static void detach() {
            if (OUT == null) {
                return;
            }
            System.setOut(OUT);
            System.setErr(ERR);
            OUT = null;
            ERR = null;
        }

        static {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    PrintStream printStream2 = System.err;
                    synchronized (printStream2) {
                        Init.detach();
                        System.out.flush();
                        System.err.flush();
                    }
                }
            }, LogUtil.class.getSimpleName() + "-Flush"));
            KOTLIN_COMPANION_ANNOTATION = Pattern.compile("\\$Proxy[0-9]+]");
        }

        private static final class DebugHeaderStream
        extends OutputStream {
            private final OutputStream child;
            @NotNull
            private final byte[] prefix;
            private final StringBuilder lineBuild = new StringBuilder();
            private boolean needsHeader = true;
            private final FileOutputStream fileCsvOut;
            private final Function<StackTraceElement, String> header;

            public DebugHeaderStream(OutputStream child, @NotNull String prefix, @Nullable FileOutputStream fileRawOut, FileOutputStream fileCsvOut, Function<StackTraceElement, String> header) {
                this.header = header;
                this.child = fileRawOut != null ? new SplitStream(child, fileRawOut) : child;
                this.prefix = prefix.getBytes();
                this.fileCsvOut = fileCsvOut;
            }

            @Override
            public void flush() throws IOException {
                this.header();
                for (int i = 0; i < this.lineBuild.length(); ++i) {
                    char b = this.lineBuild.charAt(i);
                    this.put(b);
                }
                this.lineBuild.setLength(0);
                this.child.flush();
                String s = LogUtil.class.getClassLoader().getClass().toString();
                TABLE_LAST_FLAG = TABLE_FLAG;
                if (TABLE_FLAG) {
                    TABLE_FLAG = false;
                } else {
                    TABLE_COLUMNS.clear();
                }
            }

            private void header() {
                if (!this.needsHeader) {
                    return;
                }
                this.needsHeader = false;
                try {
                    this.debugHeader();
                }
                catch (Exception e) {
                    Init.detach();
                    e.printStackTrace();
                    System.exit(0);
                }
            }

            private void put(int b) throws IOException {
                this.header();
                if (b == 10) {
                    this.needsHeader = true;
                }
                this.child.write(b);
                this.child.flush();
            }

            @Override
            public void write(int b) throws IOException {
                if (b == 13) {
                    return;
                }
                if (b == 10) {
                    this.lineBuild.append(System.lineSeparator());
                } else {
                    this.lineBuild.append((char)b);
                }
                if (this.fileCsvOut != null) {
                    if (b == 34) {
                        this.fileCsvOut.write("\"\"".getBytes());
                    } else if (b == 10) {
                        this.fileCsvOut.write("\"\n".getBytes());
                    } else {
                        this.fileCsvOut.write((char)b);
                    }
                }
            }

            private void debugHeader() throws IOException {
                boolean shouldPrint;
                StackTraceElement stack = this.getCallStack();
                if (stack == null) {
                    return;
                }
                if (this.fileCsvOut != null) {
                    this.writeCvs(stack);
                }
                boolean bl = shouldPrint = !stack.getClassName().equals(Throwable.class.getName() + "$WrappedPrintStream");
                if (shouldPrint) {
                    boolean bl2 = shouldPrint = !stack.getClassName().equals(ThreadGroup.class.getName());
                }
                if (shouldPrint) {
                    this.child.write(this.header.apply(stack).getBytes());
                }
            }

            private StackTraceElement getCallStack() {
                String name;
                StackTraceElement[] trace = Thread.currentThread().getStackTrace();
                int depth = trace.length;
                while (!((name = trace[--depth].getClassName()).equals(PrintStream.class.getName()) || name.startsWith(LogUtil.class.getName()) || name.startsWith("java.util") && trace[depth].getMethodName().equals("forEach"))) {
                }
                if (++depth < 0 || depth >= trace.length) {
                    return null;
                }
                return trace[depth];
            }

            private void writeCvs(@NotNull StackTraceElement stack) throws IOException {
                long passed = System.currentTimeMillis() - START_TIME;
                int s = (int)Math.floor((double)passed / 1000.0);
                int ms = (int)(passed - (long)(s * 1000));
                int min = (int)Math.floor((double)s / 60.0);
                s -= min * 60;
                int h = (int)Math.floor((double)min / 60.0);
                this.fileCsvOut.write(this.prefix);
                this.fileCsvOut.write(",\"".getBytes());
                this.fileCsvOut.write((h + ":" + (min -= h * 60) + ":" + s + "." + ms).getBytes());
                this.fileCsvOut.write("\",\"".getBytes());
                this.fileCsvOut.write(Thread.currentThread().getName().replace("\"", "\"\"").getBytes());
                this.fileCsvOut.write("\",".getBytes());
                this.fileCsvOut.write(stack.getClassName().getBytes());
                this.fileCsvOut.write(44);
                this.fileCsvOut.write(stack.getMethodName().getBytes());
                this.fileCsvOut.write(44);
                this.fileCsvOut.write(Integer.toString(stack.getLineNumber()).getBytes());
                this.fileCsvOut.write(",\"".getBytes());
            }
        }

        private static final class Tabulator {
            private final List<PairM<Integer, Long>> sizeTimeTable = new ArrayList<PairM<Integer, Long>>();
            public IntConsumer onGrow = i -> {};
            boolean tabulated;

            public Tabulator(boolean tabulated) {
                this.tabulated = tabulated;
            }

            public synchronized String getTab(int size) {
                if (!this.tabulated) {
                    return "";
                }
                long tim = System.currentTimeMillis();
                int max = 0;
                Iterator<PairM<Integer, Long>> i = this.sizeTimeTable.iterator();
                while (i.hasNext()) {
                    PairM<Integer, Long> p = i.next();
                    if ((Long)p.obj2 + 1000L < tim) {
                        i.remove();
                        continue;
                    }
                    max = Math.max(max, (Integer)p.obj1);
                }
                if (size > max) {
                    this.onGrow.accept(size - max);
                }
                this.sizeTimeTable.add(new PairM<Integer, Long>(size, tim));
                int tabSize = Math.max(0, max - size);
                int totalSize = tabSize + size;
                return TextUtil.stringFill(tabSize, ' ');
            }

            public void reduce(int amount) {
                if (!this.tabulated) {
                    return;
                }
                String s = this.sizeTimeTable.toString();
                Iterator<PairM<Integer, Long>> i = this.sizeTimeTable.iterator();
                while (i.hasNext()) {
                    PairM<Integer, Long> p;
                    PairM<Integer, Long> pairM = p = i.next();
                    Integer.valueOf((Integer)pairM.obj1 - amount);
                    pairM.obj1 = pairM.obj1;
                    if ((Integer)p.obj1 >= 0) continue;
                    i.remove();
                }
            }
        }

        private static class SplitStream
        extends OutputStream {
            private final OutputStream s1;
            private final OutputStream s2;

            public SplitStream(OutputStream s1, OutputStream s2) {
                this.s1 = s1;
                this.s2 = s2;
            }

            @Override
            public void write(int b) throws IOException {
                this.s1.write(b);
                this.s2.write(b);
            }
        }
    }
}

