/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.TextUtil;
import com.lapissea.util.UtilL;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LateInit<T> {
    private T value;
    private boolean inited;

    public LateInit(Supplier<T> initializer) {
        this(initializer, ForkJoinPool.commonPool());
    }

    public LateInit(Supplier<T> initializer, Executor executor) {
        executor.execute(() -> {
            try {
                this.value = initializer.get();
                this.inited = true;
            }
            catch (Throwable e) {
                throw UtilL.uncheckedThrow(e);
            }
        });
    }

    public boolean isInited() {
        return this.inited;
    }

    public void block() {
        if (this.isInited()) {
            return;
        }
        UtilL.sleepUntil(this::isInited);
    }

    public T get() {
        this.block();
        return this.value;
    }

    public void ifInited(Consumer<T> action) {
        if (this.isInited()) {
            action.accept(this.value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LateInit)) {
            return false;
        }
        LateInit lateInit = (LateInit)o;
        return this.isInited() == lateInit.isInited() && Objects.equals(this.value, lateInit.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + Boolean.hashCode(this.inited);
        return result;
    }

    public String toString() {
        return this.isInited() ? "LateInit(" + TextUtil.toString(this.value) + ")" : "LateInit<...>";
    }
}

