/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.NotNull;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class DeletingValueHashMap<K, V, SELF extends DeletingValueHashMap<K, V, SELF>>
extends AbstractMap<K, V> {
    private final HashMap<K, DeletingValueEntry<K, V>> data;
    private final ReferenceQueue<V> gcQueue = new ReferenceQueue();
    private transient Executor stayAlive;
    private transient Keys keys;
    private transient Values values;
    private transient EntrySet entries;
    private transient long policy = -1L;

    public DeletingValueHashMap(int initialCapacity, float loadFactor) {
        this.data = new HashMap(initialCapacity, loadFactor);
    }

    public DeletingValueHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DeletingValueHashMap() {
        this(16);
    }

    public DeletingValueHashMap(Map<? extends K, ? extends V> m) {
        this();
        m.forEach((k, v) -> this.data.put(k, this.newNode(k, v)));
    }

    public SELF defineStayAlivePolicy(long seconds) {
        return this.defineStayAlivePolicy(seconds, TimeUnit.SECONDS);
    }

    public SELF defineStayAlivePolicy(long delay, TimeUnit unit) {
        if (delay < 0L) {
            throw new IllegalArgumentException("ms less than 0");
        }
        long newPolicy = unit.toNanos(delay);
        if (newPolicy == this.policy) {
            return (SELF)this;
        }
        this.policy = newPolicy;
        boolean triggerMassHolding = this.stayAlive == null && delay > 0L;
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
        scheduler.setKeepAliveTime(10L, TimeUnit.SECONDS);
        scheduler.allowCoreThreadTimeOut(true);
        this.stayAlive = delay > 0L ? command -> scheduler.schedule(command, delay, unit) : null;
        if (triggerMassHolding) {
            for (V value : this.values()) {
                this.holdTo(value);
            }
        }
        return (SELF)this;
    }

    private DeletingValueEntry<K, V> newNode(K key, V value) {
        return this.newNode(key, value, this.gcQueue);
    }

    protected abstract DeletingValueEntry<K, V> newNode(K var1, V var2, ReferenceQueue<V> var3);

    private void holdTo(final V value) {
        Executor stayAlive = this.stayAlive;
        if (stayAlive == null) {
            return;
        }
        stayAlive.execute(new Runnable(){
            V reference;
            {
                this.reference = value;
            }

            @Override
            public void run() {
            }
        });
    }

    public abstract SELF copy();

    @Override
    public SELF clone() {
        return this.copy();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.data.isEmpty();
    }

    private void processQueue() {
        DeletingValueEntry ref;
        while ((ref = (DeletingValueEntry)((Object)this.gcQueue.poll())) != null) {
            this.remove(ref.getKey());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (DeletingValueEntry<K, V> e : this.data.values()) {
            V v = e.get();
            if (v == null || !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        DeletingValueEntry<K, V> ref = this.data.get(key);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            return this.remove(key);
        }
        this.processQueue();
        this.holdTo(value);
        DeletingValueEntry<K, V> old = this.data.put(key, this.newNode(key, value));
        return old == null ? null : (V)old.get();
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        DeletingValueEntry<K, V> old = this.data.remove(key);
        return old == null ? null : (V)old.get();
    }

    @Override
    public void clear() {
        this.processQueue();
        this.data.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.keys == null ? (this.keys = new Keys()) : this.keys;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.values == null ? (this.values = new Values()) : this.values;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entries == null ? (this.entries = new EntrySet()) : this.entries;
    }

    public static interface DeletingValueEntry<K, T> {
        public K getKey();

        public T get();
    }

    private class Keys
    extends AbstractSet<K> {
        private Keys() {
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            final Iterator iter = DeletingValueHashMap.this.data.entrySet().iterator();
            return new Iterator<K>(){
                K next;

                @Override
                public boolean hasNext() {
                    this.getNext();
                    return this.next != null;
                }

                private void getNext() {
                    while (this.next == null && iter.hasNext()) {
                        Map.Entry ref = (Map.Entry)iter.next();
                        if (ref == null || ref.getValue() == null) continue;
                        this.next = ref.getKey();
                    }
                }

                @Override
                public K next() {
                    this.getNext();
                    Object n = this.next;
                    this.next = null;
                    return n;
                }
            };
        }

        @Override
        public int size() {
            return DeletingValueHashMap.this.data.size();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            final Iterator iter = DeletingValueHashMap.this.data.values().iterator();
            return new Iterator<V>(){
                V next;

                @Override
                public boolean hasNext() {
                    this.getNext();
                    return this.next != null;
                }

                private void getNext() {
                    while (this.next == null && iter.hasNext()) {
                        Object val;
                        DeletingValueEntry ref = (DeletingValueEntry)iter.next();
                        if (ref == null || (val = ref.get()) == null) continue;
                        this.next = val;
                    }
                }

                @Override
                public V next() {
                    this.getNext();
                    Object n = this.next;
                    this.next = null;
                    return n;
                }
            };
        }

        @Override
        public int size() {
            return DeletingValueHashMap.this.data.size();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator iter = DeletingValueHashMap.this.data.entrySet().iterator();
            return new Iterator<Map.Entry<K, V>>(){
                Map.Entry<K, DeletingValueEntry<K, V>> next;

                @Override
                public boolean hasNext() {
                    this.getNext();
                    return this.next != null;
                }

                private void getNext() {
                    while (this.next == null && iter.hasNext()) {
                        Map.Entry n = (Map.Entry)iter.next();
                        DeletingValueEntry ref = (DeletingValueEntry)n.getValue();
                        if (ref == null || ref.get() == null) {
                            iter.remove();
                            continue;
                        }
                        this.next = n;
                    }
                }

                @Override
                public Map.Entry<K, V> next() {
                    this.getNext();
                    final Map.Entry n = this.next;
                    this.next = null;
                    return new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return n.getKey();
                        }

                        @Override
                        public V getValue() {
                            return ((DeletingValueEntry)n.getValue()).get();
                        }

                        @Override
                        public V setValue(V value) {
                            DeletingValueHashMap.this.holdTo(value);
                            DeletingValueEntry old = n.setValue(DeletingValueHashMap.this.newNode(this.getKey(), value));
                            return old == null ? null : (Object)old.get();
                        }
                    };
                }
            };
        }

        @Override
        public int size() {
            return DeletingValueHashMap.this.data.size();
        }
    }
}

