/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import java.io.IOException;
import java.io.InputStream;

public class CountInputStream
extends InputStream {
    private long count = 0L;
    private long marked = -1L;
    private InputStream is;

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public int read() throws IOException {
        int r = this.is.read();
        if (r > 0) {
            ++this.count;
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.is.read(b, off, len);
        if (r > 0) {
            this.count += (long)r;
        }
        return r;
    }

    @Override
    public long skip(long skipped) throws IOException {
        long l = this.is.skip(skipped);
        if (l > 0L) {
            this.count += l;
        }
        return l;
    }

    @Override
    public void mark(int readLimit) {
        this.is.mark(readLimit);
        this.marked = this.count;
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
        this.count = this.marked;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public long getBytesRead() {
        return this.count;
    }

    public CountInputStream(InputStream is) {
        this.is = is;
    }
}

