/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.NotNull;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferBackedInputStream
extends InputStream {
    private final ByteBuffer buf;
    private final int pos;

    public ByteBufferBackedInputStream(ByteBuffer buf) {
        this.buf = buf;
        this.pos = buf.position();
    }

    @Override
    public int read() {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buf.remaining());
        this.buf.get(bytes, off, len);
        return len;
    }

    @Override
    public void close() {
        this.buf.position(this.pos);
    }
}

