/*
 * Decompiled with CFR 0.152.
 */
package com.lapissea.util;

import com.lapissea.util.NotNull;
import com.lapissea.util.Nullable;
import com.lapissea.util.UtilL;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;

public class AsynchronousBufferingInputStream
extends InputStream {
    private static final double SLEEP_START = 0.1;
    public static final int DEFAULT_CHUNK_SIZE = 10240;
    public static final int DEFAULT_MAX_MEMORY_CONSUMPTION = 655360;
    private Block bufferActive = new Block();
    private Block bufferBack = new Block();
    private boolean reading = true;
    private double starveCounter;
    private double overflowCounter;
    private final Object swapLock = new Object();

    @Deprecated
    public static AsynchronousBufferingInputStream makeAsync(AsynchronousBufferingInputStream stream) {
        return AsynchronousBufferingInputStream.makeAsync(stream, 10240, 655360);
    }

    @Deprecated
    public static AsynchronousBufferingInputStream makeAsync(AsynchronousBufferingInputStream stream, int chunkSize, int maxMemoryConsumption) {
        return stream;
    }

    public static AsynchronousBufferingInputStream makeAsync(InputStream stream) {
        return AsynchronousBufferingInputStream.makeAsync(stream, 10240, 655360);
    }

    public static AsynchronousBufferingInputStream makeAsync(InputStream stream, int chunkSize, int maxMemoryConsumption) {
        if (stream == null) {
            return null;
        }
        if (stream instanceof AsynchronousBufferingInputStream) {
            return (AsynchronousBufferingInputStream)stream;
        }
        return new AsynchronousBufferingInputStream(stream, chunkSize, maxMemoryConsumption);
    }

    private AsynchronousBufferingInputStream(@NotNull InputStream in, int chunkSize, int maxMemoryConsumption) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize(" + chunkSize + ") can not be equal or less to 0");
        }
        if (maxMemoryConsumption <= 0) {
            throw new IllegalArgumentException("maxMemoryConsumption(" + maxMemoryConsumption + ") can not be equal or less to 0");
        }
        if (maxMemoryConsumption % chunkSize != 0) {
            throw new IllegalArgumentException("maxMemoryConsumption(" + maxMemoryConsumption + ") must be dividable chunkSize(" + chunkSize + ")");
        }
        int chunkCountLimit = maxMemoryConsumption / chunkSize;
        new Thread(() -> this.readSource(in, chunkSize, chunkCountLimit), "async file read").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSource(@NotNull InputStream in, int chunkSize, int chunkCountLimit) {
        try {
            while (this.reading) {
                byte[] bb;
                int read;
                double sleep = 0.1;
                double t = System.nanoTime();
                while (true) {
                    Object object = this.swapLock;
                    synchronized (object) {
                        if (this.bufferActive.size() + this.bufferBack.size() < chunkCountLimit) {
                            break;
                        }
                    }
                    UtilL.sleep(sleep);
                    if (!((sleep *= 1.5) > 2.0)) continue;
                    sleep = Math.sqrt(sleep);
                }
                if (sleep != 0.1) {
                    this.overflowCounter += ((double)System.nanoTime() - t) / 1000000.0;
                }
                if ((read = in.read(bb = new byte[chunkSize])) <= 0) {
                    break;
                }
                if (read != bb.length) {
                    bb = Arrays.copyOfRange(bb, 0, read);
                }
                this.push(bb);
            }
        }
        catch (Throwable e) {
            UtilL.closeSilenty(in);
            this.reading = false;
        }
        finally {
            UtilL.closeSilenty(in);
            this.reading = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(byte[] data) {
        Object object = this.swapLock;
        synchronized (object) {
            this.bufferBack.push(data);
        }
    }

    private void pop() {
        this.bufferActive.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flip() {
        Object object = this.swapLock;
        synchronized (object) {
            Block q = this.bufferActive;
            this.bufferActive = this.bufferBack;
            this.bufferBack = q;
        }
    }

    @Nullable
    private Chunk getStream() {
        Chunk result;
        if (this.bufferActive.isEmpty()) {
            if (!this.bufferBack.isEmpty()) {
                this.flip();
            } else {
                if (!this.reading) {
                    return null;
                }
                double sleep = 0.1;
                double t = System.nanoTime();
                while (this.bufferBack.isEmpty() && this.reading) {
                    UtilL.sleep(sleep);
                    if (!((sleep *= 1.5) > 2.0)) continue;
                    sleep = Math.sqrt(sleep);
                }
                if (sleep != 0.1) {
                    this.starveCounter += ((double)System.nanoTime() - t) / 1000000.0;
                }
                if (this.bufferBack.isEmpty()) {
                    return null;
                }
                this.flip();
            }
        }
        if ((result = this.bufferActive.get()).noData()) {
            this.pop();
            if (!this.bufferActive.isEmpty()) {
                return this.bufferActive.get();
            }
            return this.getStream();
        }
        return result;
    }

    public double getStarveCounter() {
        return this.starveCounter;
    }

    public double getOverflowCounter() {
        return this.overflowCounter;
    }

    @Override
    public synchronized int available() {
        return this.bufferActive.getByteCount() + this.bufferBack.getByteCount();
    }

    @Override
    public synchronized int read() {
        Chunk s = this.getStream();
        return s == null ? -1 : s.read();
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        if (off + len > b.length) {
            throw new RuntimeException();
        }
        if (len == 0) {
            return 0;
        }
        Chunk s = this.getStream();
        int read = 0;
        while (s != null && len > 0) {
            int r = s.read(b, off, len);
            read += r;
            off += r;
            len -= r;
            if (!s.noData()) continue;
            s = this.getStream();
        }
        return read == 0 ? -1 : read;
    }

    @Override
    public synchronized void close() {
        this.reading = false;
    }

    @Override
    public synchronized long skip(long n) {
        long skipped;
        Chunk s;
        for (skipped = 0L; skipped < n && (s = this.getStream()) != null; skipped += (long)s.skip((int)(n - skipped))) {
        }
        return skipped;
    }

    private static class Block {
        Deque<Chunk> chunks = new LinkedList<Chunk>();
        int byteCount;

        private Block() {
        }

        private void pop() {
            Chunk removed = this.chunks.removeFirst();
            this.byteCount -= removed.data.length;
        }

        private void push(byte[] data) {
            this.chunks.addLast(new Chunk(data));
            this.byteCount += data.length;
        }

        private Chunk get() {
            return this.chunks.getFirst();
        }

        private int size() {
            return this.chunks.size();
        }

        public boolean isEmpty() {
            return this.chunks.isEmpty();
        }

        public int getByteCount() {
            return this.byteCount;
        }
    }

    private static class Chunk {
        final byte[] data;
        int pos;

        private Chunk(byte[] data) {
            this.data = data;
        }

        public int left() {
            return this.data.length - this.pos;
        }

        public boolean noData() {
            return this.data.length <= this.pos;
        }

        public int read() {
            return this.data[this.pos++] & 0xFF;
        }

        public synchronized int read(byte[] b, int off, int len) {
            if (this.pos >= this.data.length) {
                return -1;
            }
            int avail = this.data.length - this.pos;
            if (len > avail) {
                len = avail;
            }
            if (len <= 0) {
                return 0;
            }
            System.arraycopy(this.data, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        public int skip(int n) {
            int toSkip = Math.min(n, this.left());
            this.pos += toSkip;
            return toSkip;
        }
    }
}

